/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.datastore.EQLAdditionalWarnLogInfo;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexInsertSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreInsertSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreLockSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreSearchSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreUpdateSql;
import org.iplass.mtp.impl.datastore.grdb.sql.RecycleBinSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ReferenceDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ReferenceInsertSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ToSqlResult;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbRecycleBinIterator;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbSearchResultIterator;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkContextBaseBulkUpdateStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.EachRecordBulkUpdateStrategy;
import org.iplass.mtp.impl.datastore.strategy.EntityStoreStrategy;
import org.iplass.mtp.impl.datastore.strategy.RecycleBinIterator;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.entity.QueryOption;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.connection.PreparedStatementWrapper;
import org.iplass.mtp.impl.rdb.connection.StatementWrapper;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRdbEntityStoreStrategy
implements EntityStoreStrategy {
    private static Logger log = LoggerFactory.getLogger(GRdbEntityStoreStrategy.class);
    private static final String BULK_STRATEGY = "mtp.grdb.BulkUpdateStrategy";
    private static final String TREAT_NON_UNIQUE_EXT_INDEX = "mtp.grdb.treatNonUniqueExternalIndexTable";
    private static final String COUNTER_SERVICE_INC_KEY = "oid";
    private static final String COUNTER_SERVICE_INC_KEY_RB = "rbid";
    private GRdbDataStore dataStore;
    private RdbAdapter rdb;
    private CounterService counterService;
    private BulkUpdateStrategy buStrategy;
    private boolean treatNonUniqueExternalIndexTable;
    private ObjStoreInsertSql insertSql;
    private ObjStoreUpdateSql updateSql;
    private ObjStoreDeleteSql delSql;
    private ObjStoreSearchSql searchSql;
    private ObjStoreLockSql lockSql;
    private IndexDeleteSql indexDelSql;
    private ReferenceDeleteSql refDelSql;
    private ReferenceInsertSql referenceInsertSql;
    private IndexInsertSql indexInsertSql;
    private RecycleBinSql recycleBinSql;

    public GRdbEntityStoreStrategy(GRdbDataStore dataStore, RdbAdapter rdb, CounterService counterService) {
        this.dataStore = dataStore;
        this.rdb = rdb;
        this.counterService = counterService;
        this.buStrategy = this.createBulkUpdateStrategy();
        this.insertSql = rdb.getUpdateSqlCreator(ObjStoreInsertSql.class);
        this.updateSql = rdb.getUpdateSqlCreator(ObjStoreUpdateSql.class);
        this.delSql = rdb.getUpdateSqlCreator(ObjStoreDeleteSql.class);
        this.indexDelSql = rdb.getUpdateSqlCreator(IndexDeleteSql.class);
        this.refDelSql = rdb.getUpdateSqlCreator(ReferenceDeleteSql.class);
        this.referenceInsertSql = rdb.getUpdateSqlCreator(ReferenceInsertSql.class);
        this.indexInsertSql = rdb.getUpdateSqlCreator(IndexInsertSql.class);
        this.searchSql = rdb.getQuerySqlCreator(ObjStoreSearchSql.class);
        this.lockSql = rdb.getQuerySqlCreator(ObjStoreLockSql.class);
        this.recycleBinSql = rdb.getUpdateSqlCreator(RecycleBinSql.class);
        this.treatNonUniqueExternalIndexTable = Boolean.getBoolean(TREAT_NON_UNIQUE_EXT_INDEX);
    }

    private BulkUpdateStrategy createBulkUpdateStrategy() {
        String propBulkStrategy = System.getProperty(BULK_STRATEGY);
        if (propBulkStrategy != null && EachRecordBulkUpdateStrategy.class.getName().equals(propBulkStrategy)) {
            return new EachRecordBulkUpdateStrategy(this, this.rdb);
        }
        return new BulkContextBaseBulkUpdateStrategy(this, this.rdb);
    }

    @Override
    public int count(final EntityContext context, final Query query) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                EntityHandler handler = context.getHandlerByName(query.getFrom().getEntityName());
                ToSqlResult sql = GRdbEntityStoreStrategy.this.searchSql.count(handler, context, query, GRdbEntityStoreStrategy.this.rdb.isEnableBindHint(), GRdbEntityStoreStrategy.this.rdb);
                if (sql.bindVariables == null || sql.bindVariables.size() == 0) {
                    Statement stmt = this.getStatement();
                    stmt.setFetchSize(1);
                    QueryOption qo = QueryOption.getQueryOption(query);
                    if (qo != null && qo.getQueryTimeout() != 0) {
                        qo.setQueryTimeout(qo.getQueryTimeout());
                    }
                    if (stmt instanceof StatementWrapper) {
                        ((StatementWrapper)stmt).setAdditionalWarnLogInfo(new EQLAdditionalWarnLogInfo(query, true, handler, context));
                    }
                    try (ResultSet rs = stmt.executeQuery(sql.sql);){
                        if (stmt instanceof StatementWrapper) {
                            ((StatementWrapper)stmt).setAdditionalWarnLogInfo(null);
                        }
                        rs.next();
                        Integer n = rs.getInt(1);
                        return n;
                    }
                }
                PreparedStatement stmt = this.getPreparedStatement(sql.sql);
                if (stmt instanceof PreparedStatementWrapper) {
                    ((PreparedStatementWrapper)stmt).setAdditionalWarnLogInfo(new EQLAdditionalWarnLogInfo(query, true, handler, context));
                }
                int index = 1;
                for (ToSqlResult.BindValue val : sql.bindVariables) {
                    val.type.setParameter(index, val.value, stmt, GRdbEntityStoreStrategy.this.rdb);
                    ++index;
                }
                stmt.setFetchSize(1);
                QueryOption qo = QueryOption.getQueryOption(query);
                if (qo != null && qo.getQueryTimeout() != 0) {
                    qo.setQueryTimeout(qo.getQueryTimeout());
                }
                try (ResultSet rs = stmt.executeQuery();){
                    if (stmt instanceof PreparedStatementWrapper) {
                        ((PreparedStatementWrapper)stmt).setAdditionalWarnLogInfo(null);
                    }
                    rs.next();
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
        };
        return (Integer)exec.execute(this.rdb, true);
    }

    @Override
    public void delete(final EntityContext context, final Entity model, final EntityHandler handler, final DeleteOption option) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = context.getTenantId(handler);
                String mainSql = GRdbEntityStoreStrategy.this.delSql.deleteMainPageByOid(tenantId, handler, model.getOid(), model.getVersion(), option.isCheckTimestamp(), model.getUpdateDate(), GRdbEntityStoreStrategy.this.rdb);
                int count = this.getStatement().executeUpdate(mainSql);
                if (count < 1) {
                    throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                }
                if (((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).getCurrentMaxPage() > 0) {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.delSql.deleteByOid(tenantId, handler, model.getOid(), model.getVersion(), GRdbEntityStoreStrategy.this.rdb));
                }
                ArrayList<String> delTalbeIndex = new ArrayList<String>();
                ArrayList<String> delTalbeUnique = new ArrayList<String>();
                boolean hasReference = false;
                for (PropertyHandler ph : handler.getDeclaredPropertyList()) {
                    GRdbPropertyStoreRuntime psh;
                    if (ph instanceof ReferencePropertyHandler && ((MetaReferenceProperty)ph.getMetaData()).getMappedByPropertyMetaDataId() == null) {
                        hasReference = true;
                    }
                    if (!(ph.getStoreSpecProperty() instanceof GRdbPropertyStoreRuntime) || !(psh = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty())).getPropertyRuntime().isIndexed() || !psh.isExternalIndex()) continue;
                    if (IndexType.NON_UNIQUE == psh.getPropertyRuntime().getMetaData().getIndexType()) {
                        if (delTalbeIndex.contains(psh.getSingleColumnRdbTypeAdapter().getColOfIndex())) continue;
                        delTalbeIndex.add(psh.getSingleColumnRdbTypeAdapter().getColOfIndex());
                        continue;
                    }
                    if (delTalbeUnique.contains(psh.getSingleColumnRdbTypeAdapter().getColOfIndex())) continue;
                    delTalbeUnique.add(psh.getSingleColumnRdbTypeAdapter().getColOfIndex());
                }
                for (String table : delTalbeIndex) {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.indexDelSql.toSqlDelByOid(tenantId, handler, table, IndexType.NON_UNIQUE, model.getOid(), model.getVersion(), GRdbEntityStoreStrategy.this.rdb));
                }
                for (String table : delTalbeUnique) {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.indexDelSql.toSqlDelByOid(tenantId, handler, table, IndexType.UNIQUE, model.getOid(), model.getVersion(), GRdbEntityStoreStrategy.this.rdb));
                }
                if (hasReference) {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.refDelSql.toSql(tenantId, handler, model.getOid(), model.getVersion(), GRdbEntityStoreStrategy.this.rdb));
                }
                this.getStatement().executeBatch();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    @Override
    public String insert(final EntityContext context, final EntityHandler handler, final Entity model) {
        SqlExecuter<String> exec = new SqlExecuter<String>(){

            @Override
            public String logic() throws SQLException {
                int tenantId = context.getTenantId(handler);
                String oid = model.getOid();
                MultiInsertContext ctx = GRdbEntityStoreStrategy.this.rdb.createMultiInsertContext(this.getStatement());
                String updateSql = GRdbEntityStoreStrategy.this.insertSql.insertMain(tenantId, handler, model, GRdbEntityStoreStrategy.this.rdb, context);
                ctx.addInsertSql(updateSql);
                MetaGRdbEntityStore.GRdbEntityStoreRuntime store = (MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime();
                if (store.getCurrentMaxPage() > 0) {
                    for (int i = 1; i <= store.getCurrentMaxPage(); ++i) {
                        ctx.addInsertSql(GRdbEntityStoreStrategy.this.insertSql.insertSubPage(tenantId, handler, model, i, GRdbEntityStoreStrategy.this.rdb, context));
                    }
                }
                GRdbEntityStoreStrategy.this.insertIndex(tenantId, oid, handler, model, ctx, this.getStatement());
                List insRefs = GRdbEntityStoreStrategy.this.targetReference(handler, model, context, null);
                if (insRefs.size() > 0) {
                    if (GRdbEntityStoreStrategy.this.isInsertReferenceByPreparedBatch(insRefs)) {
                        ctx.execute();
                        try (PreparedStatement ps = this.getPreparedStatement(GRdbEntityStoreStrategy.this.referenceInsertSql.prepareInsert(handler));){
                            ps.clearBatch();
                            GRdbEntityStoreStrategy.this.insertReferences(tenantId, oid, model.getVersion(), handler, insRefs, null, ps, context);
                        }
                    } else {
                        GRdbEntityStoreStrategy.this.insertReferences(tenantId, oid, model.getVersion(), handler, insRefs, ctx, null, context);
                        ctx.execute();
                    }
                } else {
                    ctx.execute();
                }
                return oid;
            }
        };
        return (String)exec.execute(this.rdb, true);
    }

    private boolean insertIndex(int tenantId, String oid, EntityHandler dataModelHandler, Entity model, MultiInsertContext ctx, Statement stmt) throws SQLException {
        boolean result = false;
        List<PropertyHandler> props = dataModelHandler.getDeclaredPropertyList();
        for (PropertyHandler storeP : props) {
            MetaGRdbPropertyStore.GRdbPropertyStoreHandler storePropHandler;
            IndexType indexType;
            if (!(storeP instanceof PrimitivePropertyHandler) || ((PrimitivePropertyHandler)storeP).getMetaData().getType().isVirtual() || storeP.getMetaData().getMultiplicity() != 1 || (indexType = storeP.getMetaData().getIndexType()) != IndexType.NON_UNIQUE && indexType != IndexType.UNIQUE && indexType != IndexType.UNIQUE_WITHOUT_NULL || !(storePropHandler = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)storeP.getStoreSpecProperty()).isExternalIndex()) continue;
            Object val = model.getValue(storeP.getName());
            boolean needAdd = true;
            if (indexType != IndexType.NON_UNIQUE) {
                if (dataModelHandler.isVersioned()) {
                    try (ResultSet rs = stmt.executeQuery(this.indexInsertSql.searchByOid(tenantId, storePropHandler, oid, this.rdb));){
                        if (rs.next()) {
                            needAdd = false;
                        }
                    }
                }
                if (indexType == IndexType.UNIQUE_WITHOUT_NULL && val == null) {
                    needAdd = false;
                }
            }
            if (!needAdd) continue;
            ctx.addInsertSql(this.indexInsertSql.insert(tenantId, storePropHandler, oid, model.getVersion(), val, this.rdb));
            result = true;
        }
        return result;
    }

    private List<InsertReferenceTarget> targetReference(EntityHandler dataModelHandler, Entity model, EntityContext ectx, List<String> updatePropList) {
        List<InsertReferenceTarget> ret = null;
        if (updatePropList == null) {
            List<PropertyHandler> props = dataModelHandler.getDeclaredPropertyList();
            for (PropertyHandler p : props) {
                ret = this.addTargetRefrerence(ret, p, model, ectx);
            }
        } else {
            for (String propName : updatePropList) {
                PropertyHandler p = dataModelHandler.getDeclaredProperty(propName);
                ret = this.addTargetRefrerence(ret, p, model, ectx);
            }
        }
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    private List<InsertReferenceTarget> addTargetRefrerence(List<InsertReferenceTarget> list, PropertyHandler ph, Entity model, EntityContext ectx) {
        ReferencePropertyHandler rh;
        if (ph instanceof ReferencePropertyHandler && (rh = (ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() == null) {
            EntityHandler refEh = rh.getReferenceEntityHandler(ectx);
            if (list == null) {
                list = new LinkedList<InsertReferenceTarget>();
            }
            list.add(new InsertReferenceTarget(rh, refEh, model.getValue(rh.getName())));
        }
        return list;
    }

    private boolean isInsertReferenceByPreparedBatch(List<InsertReferenceTarget> list) {
        if (this.rdb.getThresholdCountOfUsePrepareStatement() <= 0) {
            return false;
        }
        int count = 0;
        for (InsertReferenceTarget t : list) {
            if (t.value == null) continue;
            if (t.rh.getMetaData().getMultiplicity() != 1) {
                if (t.value instanceof Object[]) {
                    count += ((Object[])t.value).length;
                    continue;
                }
                ++count;
                continue;
            }
            ++count;
        }
        return count >= this.rdb.getThresholdCountOfUsePrepareStatement();
    }

    private void insRef(int[] counter, int tenantId, String oid, Long version, Entity ref, EntityHandler eh, ReferencePropertyHandler rh, EntityHandler refEntityType, MultiInsertContext ctx, PreparedStatement ps) throws SQLException {
        String refOid = ref.getOid();
        Long refVer = ref.getVersion();
        if (refOid == null || refOid.length() == 0) {
            throw new EntityRuntimeException("cant insert reference:" + rh.getName() + ", cause reference entity oid is null or empty String...");
        }
        counter[0] = counter[0] + 1;
        if (ctx != null) {
            ctx.addInsertSql(this.referenceInsertSql.insert(tenantId, eh, rh.getId(), oid, version, refEntityType.getMetaData().getId(), refOid, refVer, this.rdb));
        } else {
            ps.clearParameters();
            this.referenceInsertSql.setPrepareInsertParameter(ps, tenantId, eh, rh.getId(), oid, version, refEntityType.getMetaData().getId(), refOid, refVer, this.rdb);
            ps.addBatch();
            if (counter[0] % this.rdb.getBatchSize() == 0) {
                ps.executeBatch();
            }
        }
    }

    private void insertReferences(int tenantId, String oid, Long version, EntityHandler eh, List<InsertReferenceTarget> list, MultiInsertContext ctx, PreparedStatement ps, EntityContext ectx) throws SQLException {
        int[] counter = new int[]{0};
        for (InsertReferenceTarget t : list) {
            if (t.value == null) continue;
            if (t.rh.getMetaData().getMultiplicity() != 1) {
                if (t.value instanceof Entity[]) {
                    for (Entity ref : (Entity[])t.value) {
                        this.insRef(counter, tenantId, oid, version, ref, eh, t.rh, t.refEh, ctx, ps);
                    }
                    continue;
                }
                this.insRef(counter, tenantId, oid, version, (Entity)t.value, eh, t.rh, t.refEh, ctx, ps);
                continue;
            }
            this.insRef(counter, tenantId, oid, version, (Entity)t.value, eh, t.rh, t.refEh, ctx, ps);
        }
        if (ps != null && counter[0] % this.rdb.getBatchSize() != 0) {
            ps.executeBatch();
        }
    }

    @Override
    public boolean lock(final EntityContext context, final EntityHandler handler, final String oid) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                String sql = GRdbEntityStoreStrategy.this.lockSql.lockByOid(context.getTenantId(handler), handler, context, oid, GRdbEntityStoreStrategy.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    Boolean bl = rs.next();
                    return bl;
                }
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    @Override
    public SearchResultIterator search(final EntityContext context, final Query query, final EntityHandler eh) {
        SqlExecuter<SearchResultIterator> exec = new SqlExecuter<SearchResultIterator>(){

            @Override
            public SearchResultIterator logic() throws SQLException {
                log.trace("query execute");
                QueryOption option = QueryOption.getQueryOption(query);
                EntityHandler handler = null;
                handler = eh.getMetaData().getName().equals(query.getFrom().getEntityName()) ? eh : context.getHandlerByName(query.getFrom().getEntityName());
                ToSqlResult sql = GRdbEntityStoreStrategy.this.searchSql.query(handler, context, query, false, GRdbEntityStoreStrategy.this.rdb.isEnableBindHint(), GRdbEntityStoreStrategy.this.dataStore.getStringTypeLengthOnQuery(), GRdbEntityStoreStrategy.this.rdb);
                log.trace("sql created");
                ResultSet rs = null;
                if (sql.bindVariables == null || sql.bindVariables.size() == 0) {
                    Statement stmt = this.getStatement();
                    if (stmt instanceof StatementWrapper) {
                        ((StatementWrapper)stmt).setAdditionalWarnLogInfo(new EQLAdditionalWarnLogInfo(query, false, handler, context));
                    }
                    if (option != null && option.getFetchSize() != 0) {
                        if (GRdbEntityStoreStrategy.this.rdb.getMaxFetchSize() < option.getFetchSize()) {
                            stmt.setFetchSize(GRdbEntityStoreStrategy.this.rdb.getMaxFetchSize());
                        } else {
                            stmt.setFetchSize(option.getFetchSize());
                        }
                    }
                    if (option != null && option.getQueryTimeout() != 0) {
                        stmt.setQueryTimeout(option.getQueryTimeout());
                    }
                    rs = this.getStatement().executeQuery(sql.sql);
                    if (stmt instanceof StatementWrapper) {
                        ((StatementWrapper)stmt).setAdditionalWarnLogInfo(null);
                    }
                } else {
                    PreparedStatement stmt = this.getPreparedStatement(sql.sql);
                    if (stmt instanceof PreparedStatementWrapper) {
                        ((PreparedStatementWrapper)stmt).setAdditionalWarnLogInfo(new EQLAdditionalWarnLogInfo(query, false, handler, context));
                    }
                    int index = 1;
                    for (ToSqlResult.BindValue val : sql.bindVariables) {
                        val.type.setParameter(index, val.value, stmt, GRdbEntityStoreStrategy.this.rdb);
                        ++index;
                    }
                    if (option != null && option.getFetchSize() != 0) {
                        if (GRdbEntityStoreStrategy.this.rdb.getMaxFetchSize() < option.getFetchSize()) {
                            stmt.setFetchSize(GRdbEntityStoreStrategy.this.rdb.getMaxFetchSize());
                        } else {
                            stmt.setFetchSize(option.getFetchSize());
                        }
                    }
                    if (option != null && option.getQueryTimeout() != 0) {
                        stmt.setQueryTimeout(option.getQueryTimeout());
                    }
                    rs = stmt.executeQuery();
                    if (stmt instanceof PreparedStatementWrapper) {
                        ((PreparedStatementWrapper)stmt).setAdditionalWarnLogInfo(null);
                    }
                }
                log.trace("executed sql");
                return new GRdbSearchResultIterator(rs, handler, context, query, GRdbEntityStoreStrategy.this.rdb);
            }
        };
        return (SearchResultIterator)exec.execute(this.rdb, false);
    }

    @Override
    public void update(final EntityContext context, final EntityHandler handler, final Entity model, final UpdateOption option) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = context.getTenantId(handler);
                String sql = GRdbEntityStoreStrategy.this.updateSql.updateMain(tenantId, handler, model, option.isCheckTimestamp(), option.getUpdateProperties(), GRdbEntityStoreStrategy.this.rdb, context);
                int count = this.getStatement().executeUpdate(sql);
                if (count < 1) {
                    throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                }
                MultiInsertContext ctx = GRdbEntityStoreStrategy.this.rdb.createMultiInsertContext(this.getStatement());
                MetaGRdbEntityStore.GRdbEntityStoreRuntime store = (MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime();
                if (store.getCurrentMaxPage() > 0) {
                    for (int i = 1; i <= store.getCurrentMaxPage(); ++i) {
                        String us = GRdbEntityStoreStrategy.this.updateSql.updateSub(tenantId, handler, model, option.getUpdateProperties(), i, GRdbEntityStoreStrategy.this.rdb, context);
                        if (us == null) continue;
                        ctx.addUpdateSql(us);
                    }
                }
                GRdbEntityStoreStrategy.this.updateIndex(tenantId, handler, model, ctx, option.getUpdateProperties());
                String oid = model.getOid();
                Long version = model.getVersion();
                List updRefs = GRdbEntityStoreStrategy.this.targetReference(handler, model, context, option.getUpdateProperties());
                if (updRefs.size() > 0) {
                    for (InsertReferenceTarget t : updRefs) {
                        ctx.addUpdateSql(GRdbEntityStoreStrategy.this.refDelSql.deleteByOidAndVersion(tenantId, handler, t.rh.getId(), oid, version, GRdbEntityStoreStrategy.this.rdb));
                    }
                    if (GRdbEntityStoreStrategy.this.isInsertReferenceByPreparedBatch(updRefs)) {
                        if (ctx.isSqlAdded()) {
                            ctx.execute();
                        }
                        try (PreparedStatement ps = this.getPreparedStatement(GRdbEntityStoreStrategy.this.referenceInsertSql.prepareInsert(handler));){
                            ps.clearBatch();
                            GRdbEntityStoreStrategy.this.insertReferences(tenantId, oid, model.getVersion(), handler, updRefs, null, ps, context);
                        }
                    } else {
                        GRdbEntityStoreStrategy.this.insertReferences(tenantId, oid, model.getVersion(), handler, updRefs, ctx, null, context);
                        if (ctx.isSqlAdded()) {
                            ctx.execute();
                        }
                    }
                } else if (ctx.isSqlAdded()) {
                    ctx.execute();
                }
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    private void updateIndex(int tenantId, EntityHandler dataModelHandler, Entity model, MultiInsertContext ctx, List<String> updatePropList) throws SQLException {
        for (String propName : updatePropList) {
            IndexType indexType;
            GRdbPropertyStoreRuntime col;
            PropertyHandler storeP = dataModelHandler.getDeclaredProperty(propName);
            if (storeP == null || !(storeP.getStoreSpecProperty() instanceof GRdbPropertyStoreRuntime) || !(col = (GRdbPropertyStoreRuntime)((Object)storeP.getStoreSpecProperty())).isExternalIndex() || (indexType = storeP.getMetaData().getIndexType()) != IndexType.NON_UNIQUE && indexType != IndexType.UNIQUE && indexType != IndexType.UNIQUE_WITHOUT_NULL) continue;
            ctx.addUpdateSql(this.indexDelSql.deleteByOidAndVersion(tenantId, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, model.getOid(), model.getVersion(), this.rdb));
            Object val = model.getValue(storeP.getName());
            if (indexType != IndexType.UNIQUE && val == null) continue;
            ctx.addInsertSql(this.indexInsertSql.insert(tenantId, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, model.getOid(), model.getVersion(), val, this.rdb));
        }
    }

    @Override
    public int deleteAll(final DeleteCondition cond, final EntityContext entityContext, final EntityHandler handler, String clientId) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer logic() throws SQLException {
                int tenantId = entityContext.getTenantId(handler);
                boolean hasIndexOrRef = false;
                for (PropertyHandler ph : handler.getDeclaredPropertyList()) {
                    if (ph instanceof ReferencePropertyHandler && ((MetaReferenceProperty)ph.getMetaData()).getMappedByPropertyMetaDataId() == null) {
                        hasIndexOrRef = true;
                        break;
                    }
                    if (!ph.isIndexed() || !(ph.getStoreSpecProperty() instanceof MetaGRdbPropertyStore.GRdbPropertyStoreHandler) || !((MetaGRdbPropertyStore.GRdbPropertyStoreHandler)ph.getStoreSpecProperty()).isExternalIndex()) continue;
                    hasIndexOrRef = true;
                    break;
                }
                if (!hasIndexOrRef && !cond.isLockStrictly()) {
                    int ret = this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.delSql.deleteByCondition(tenantId, handler, cond, GRdbEntityStoreStrategy.this.rdb, entityContext));
                    int maxPageNo = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).getCurrentMaxPage();
                    if (maxPageNo == 0) {
                        return ret;
                    }
                    return ret / (maxPageNo + 1);
                }
                try {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.rdb.deleteTemporaryTable("OBJ_STORE_TMP"));
                    if (!GRdbEntityStoreStrategy.this.rdb.isSupportGlobalTemporaryTable()) {
                        String createTempTable = GRdbEntityStoreStrategy.this.rdb.createLocalTemporaryTable("OBJ_STORE_TMP", "OBJ_STORE", new String[]{"OBJ_ID", "OBJ_VER"});
                        this.getStatement().addBatch(createTempTable);
                    }
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.insertSql.copyToTemporaryTable(handler, cond.getWhere(), GRdbEntityStoreStrategy.this.rdb, entityContext));
                    int[] count = this.getStatement().executeBatch();
                    if (count[count.length - 1] == 0) {
                        Integer maxPageNo = 0;
                        return maxPageNo;
                    }
                    if (cond.isLockStrictly()) {
                        String sql = GRdbEntityStoreStrategy.this.lockSql.lockByTempTable(tenantId, handler, entityContext, GRdbEntityStoreStrategy.this.rdb);
                        ResultSet rs = this.getStatement().executeQuery(sql);
                        Throwable throwable = null;
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    HashSet<String> delTalbeIndex = new HashSet<String>();
                    HashSet<String> delTalbeUnique = new HashSet<String>();
                    boolean hasReference = false;
                    for (PropertyHandler ph : handler.getDeclaredPropertyList()) {
                        MetaGRdbPropertyStore.GRdbPropertyStoreHandler psh;
                        if (ph instanceof ReferencePropertyHandler && ((MetaReferenceProperty)ph.getMetaData()).getMappedByPropertyMetaDataId() == null) {
                            hasReference = true;
                        }
                        if (!(ph.getStoreSpecProperty() instanceof MetaGRdbPropertyStore.GRdbPropertyStoreHandler) || !(psh = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)ph.getStoreSpecProperty()).isExternalIndex()) continue;
                        if (IndexType.NON_UNIQUE == psh.getPropertyRuntime().getMetaData().getIndexType()) {
                            delTalbeIndex.add(psh.getSingleColumnRdbTypeAdapter().getColOfIndex());
                            continue;
                        }
                        delTalbeUnique.add(psh.getSingleColumnRdbTypeAdapter().getColOfIndex());
                    }
                    for (String table : delTalbeIndex) {
                        this.getStatement().addBatch(GRdbEntityStoreStrategy.this.indexDelSql.deleteByTempTable(tenantId, handler, table, IndexType.NON_UNIQUE, GRdbEntityStoreStrategy.this.rdb));
                    }
                    for (String table : delTalbeUnique) {
                        this.getStatement().addBatch(GRdbEntityStoreStrategy.this.indexDelSql.deleteByTempTable(tenantId, handler, table, IndexType.UNIQUE, GRdbEntityStoreStrategy.this.rdb));
                    }
                    if (hasReference) {
                        this.getStatement().addBatch(GRdbEntityStoreStrategy.this.refDelSql.deleteByTempTable(tenantId, handler, GRdbEntityStoreStrategy.this.rdb, entityContext));
                    }
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.delSql.deleteByTempTable(tenantId, handler, GRdbEntityStoreStrategy.this.rdb, entityContext));
                    int[] resCounts = this.getStatement().executeBatch();
                    int ret = resCounts[resCounts.length - 1];
                    int maxPageNo = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).getCurrentMaxPage();
                    if (maxPageNo != 0) {
                        if (ret % (maxPageNo + 1) != 0) {
                            throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                        }
                        ret /= maxPageNo + 1;
                    }
                    if (count[count.length - 1] != ret) {
                        throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                    }
                    Integer n = ret;
                    return n;
                }
                finally {
                    if (!GRdbEntityStoreStrategy.this.rdb.isSupportAutoClearTemporaryTableWhenCommit()) {
                        try {
                            this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.rdb.deleteTemporaryTable("OBJ_STORE_TMP"));
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(GRdbEntityStoreStrategy.class).warn("temporary table:OBJ_STORE_TMP drop fail. may be resource leak...");
                        }
                    }
                }
            }
        };
        return (Integer)exec.execute(this.rdb, true);
    }

    @Override
    public int updateAll(final UpdateCondition cond, final EntityContext context, final EntityHandler handler, final String clientId) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer logic() throws SQLException {
                Object col;
                int tenantId = context.getTenantId(handler);
                boolean hasExIndex = false;
                for (UpdateCondition.UpdateValue uv : cond.getValues()) {
                    col = (GRdbPropertyStoreRuntime)((Object)handler.getProperty(uv.getEntityField(), context).getStoreSpecProperty());
                    if (!col.isExternalIndex()) continue;
                    hasExIndex = true;
                    break;
                }
                int maxPage = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).getCurrentMaxPage();
                if (!hasExIndex && !cond.isLockStrictly() && maxPage == 0) {
                    return this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.updateSql.updateAllOnlyMainByCondition(tenantId, handler, cond, clientId, GRdbEntityStoreStrategy.this.rdb, context));
                }
                try {
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.rdb.deleteTemporaryTable("OBJ_STORE_TMP"));
                    if (!GRdbEntityStoreStrategy.this.rdb.isSupportGlobalTemporaryTable()) {
                        String createTempTable = GRdbEntityStoreStrategy.this.rdb.createLocalTemporaryTable("OBJ_STORE_TMP", "OBJ_STORE", new String[]{"OBJ_ID", "OBJ_VER"});
                        this.getStatement().addBatch(createTempTable);
                    }
                    this.getStatement().addBatch(GRdbEntityStoreStrategy.this.insertSql.copyToTemporaryTable(handler, cond.getWhere(), GRdbEntityStoreStrategy.this.rdb, context));
                    int[] count = this.getStatement().executeBatch();
                    if (count[count.length - 1] == 0) {
                        col = 0;
                        return col;
                    }
                    if (cond.isLockStrictly()) {
                        String sql = GRdbEntityStoreStrategy.this.lockSql.lockByTempTable(tenantId, handler, context, GRdbEntityStoreStrategy.this.rdb);
                        ResultSet rs = this.getStatement().executeQuery(sql);
                        Throwable throwable = null;
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    int updatePageCount = 0;
                    MultiInsertContext ctx = GRdbEntityStoreStrategy.this.rdb.createMultiInsertContext(this.getStatement());
                    ctx.addUpdateSql(GRdbEntityStoreStrategy.this.updateSql.updateAllMainByTempTable(tenantId, handler, cond.getValues(), clientId, GRdbEntityStoreStrategy.this.rdb, context));
                    for (int i = 1; i <= maxPage; ++i) {
                        String us = GRdbEntityStoreStrategy.this.updateSql.updateAllSubByTempTable(tenantId, handler, cond.getValues(), clientId, i, GRdbEntityStoreStrategy.this.rdb, context);
                        if (us == null) continue;
                        ctx.addUpdateSql(us);
                        ++updatePageCount;
                    }
                    GRdbEntityStoreStrategy.this.updateIndexAll(tenantId, handler, ctx, cond.getValues());
                    int[] updateCounts = ctx.execute();
                    for (int i = 0; i <= updatePageCount; ++i) {
                        if (count[count.length - 1] == updateCounts[i]) continue;
                        throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                    }
                    Integer n = count[count.length - 1];
                    return n;
                }
                finally {
                    if (!GRdbEntityStoreStrategy.this.rdb.isSupportAutoClearTemporaryTableWhenCommit()) {
                        try {
                            this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.rdb.deleteTemporaryTable("OBJ_STORE_TMP"));
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(GRdbEntityStoreStrategy.class).warn("temporary table:OBJ_STORE_TMP drop fail. may be resource leak...");
                        }
                    }
                }
            }
        };
        return (Integer)exec.execute(this.rdb, true);
    }

    private void updateIndexAll(int tenantId, EntityHandler dataModelHandler, MultiInsertContext ctx, List<UpdateCondition.UpdateValue> updatePropList) throws SQLException {
        for (UpdateCondition.UpdateValue upadteValue : updatePropList) {
            IndexType indexType;
            GRdbPropertyStoreRuntime col;
            String propName = upadteValue.getEntityField();
            PropertyHandler storeP = dataModelHandler.getDeclaredProperty(propName);
            if (storeP == null || !(storeP.getStoreSpecProperty() instanceof GRdbPropertyStoreRuntime) || !(col = (GRdbPropertyStoreRuntime)((Object)storeP.getStoreSpecProperty())).isExternalIndex() || (indexType = storeP.getMetaData().getIndexType()) != IndexType.NON_UNIQUE && indexType != IndexType.UNIQUE && indexType != IndexType.UNIQUE_WITHOUT_NULL) continue;
            ctx.addUpdateSql(this.indexDelSql.deleteByTempTable(tenantId, dataModelHandler, col.getSingleColumnRdbTypeAdapter().getColOfIndex(), indexType, this.rdb));
            ctx.addUpdateSql(this.indexInsertSql.insertByTempTable(tenantId, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, this.rdb));
        }
    }

    @Override
    public Long copyToRecycleBin(final EntityContext context, final EntityHandler handler, final String oid, final String userId) {
        final Long rbid = this.newRbId(context, handler);
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = context.getTenantId(handler);
                StorageSpaceMap ssMap = GRdbEntityStoreStrategy.this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)handler.getMetaData().getStoreMapping());
                String copySql = GRdbEntityStoreStrategy.this.recycleBinSql.copyDataToRB(tenantId, handler, rbid, oid, userId, GRdbEntityStoreStrategy.this.rdb, ssMap);
                this.getStatement().executeUpdate(copySql);
                String refCopySql = GRdbEntityStoreStrategy.this.recycleBinSql.copyRefToRB(tenantId, rbid, handler, oid, GRdbEntityStoreStrategy.this.rdb);
                this.getStatement().executeUpdate(refCopySql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
        return rbid;
    }

    private Long newRbId(EntityContext context, EntityHandler handler) {
        return this.counterService.increment(context.getTenantId(handler), COUNTER_SERVICE_INC_KEY_RB, 1L);
    }

    @Override
    public void copyFromRecycleBin(final EntityContext context, final EntityHandler handler, final Long rbid, String userId) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String oid;
                int tenantId;
                block13: {
                    tenantId = context.getTenantId(handler);
                    String sql = GRdbEntityStoreStrategy.this.recycleBinSql.lockData(tenantId, handler, rbid, null, GRdbEntityStoreStrategy.this.rdb);
                    oid = null;
                    try (ResultSet rs = this.getStatement().executeQuery(sql);){
                        if (rs.next()) {
                            oid = rs.getString("OBJ_ID");
                            break block13;
                        }
                        throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                    }
                }
                MultiInsertContext ctx = GRdbEntityStoreStrategy.this.rdb.createMultiInsertContext(this.getStatement());
                StorageSpaceMap ssMap = GRdbEntityStoreStrategy.this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)handler.getMetaData().getStoreMapping());
                String copySql = GRdbEntityStoreStrategy.this.recycleBinSql.copyDataFromRB(tenantId, handler, rbid, GRdbEntityStoreStrategy.this.rdb, context, ssMap);
                ctx.addUpdateSql(copySql);
                String refCopySql = GRdbEntityStoreStrategy.this.recycleBinSql.copyRefFromRB(tenantId, rbid, handler, GRdbEntityStoreStrategy.this.rdb);
                ctx.addUpdateSql(refCopySql);
                GRdbEntityStoreStrategy.this.insertIndexForRestore(tenantId, handler, oid, ctx);
                ctx.execute();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    private void insertIndexForRestore(int tenantId, EntityHandler dataModelHandler, String oid, MultiInsertContext ctx) throws SQLException {
        List<PropertyHandler> props = dataModelHandler.getDeclaredPropertyList();
        for (PropertyHandler storeP : props) {
            IndexType indexType;
            GRdbPropertyStoreRuntime col;
            if (storeP == null || !(storeP.getStoreSpecProperty() instanceof GRdbPropertyStoreRuntime) || !(col = (GRdbPropertyStoreRuntime)((Object)storeP.getStoreSpecProperty())).isExternalIndex() || (indexType = storeP.getMetaData().getIndexType()) != IndexType.NON_UNIQUE && indexType != IndexType.UNIQUE && indexType != IndexType.UNIQUE_WITHOUT_NULL) continue;
            ctx.addUpdateSql(this.indexInsertSql.insertByOid(tenantId, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, oid, this.rdb));
        }
    }

    @Override
    public void deleteFromRecycleBin(final EntityContext context, final EntityHandler handler, final Long rbid, String userId) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = context.getTenantId(handler);
                String sql = GRdbEntityStoreStrategy.this.recycleBinSql.lockData(tenantId, handler, rbid, null, GRdbEntityStoreStrategy.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    if (!rs.next()) {
                        throw new EntityConcurrentUpdateException(GRdbEntityStoreStrategy.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                    }
                }
                String delSql = GRdbEntityStoreStrategy.this.recycleBinSql.deleteDataRB(tenantId, handler, rbid, null, GRdbEntityStoreStrategy.this.rdb);
                this.getStatement().addBatch(delSql);
                String refDelSql = GRdbEntityStoreStrategy.this.recycleBinSql.deleteRefRB(tenantId, handler, rbid, null, GRdbEntityStoreStrategy.this.rdb);
                this.getStatement().addBatch(refDelSql);
                this.getStatement().executeBatch();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    @Override
    public RecycleBinIterator getRecycleBin(final EntityContext context, final EntityHandler handler, final Long rbid) {
        SqlExecuter<RecycleBinIterator> exec = new SqlExecuter<RecycleBinIterator>(){

            @Override
            public RecycleBinIterator logic() throws SQLException {
                String sql = GRdbEntityStoreStrategy.this.recycleBinSql.searchRB(context.getTenantId(handler), handler, rbid, GRdbEntityStoreStrategy.this.rdb);
                ResultSet rs = this.getStatement().executeQuery(sql);
                return new GRdbRecycleBinIterator(rs, GRdbEntityStoreStrategy.this.rdb);
            }
        };
        return (RecycleBinIterator)exec.execute(this.rdb, false);
    }

    @Override
    public int countRecycleBin(final EntityContext context, final EntityHandler handler, final Timestamp ts) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer logic() throws SQLException {
                String sql = GRdbEntityStoreStrategy.this.recycleBinSql.searchRB(context.getTenantId(handler), handler, null, ts, GRdbEntityStoreStrategy.this.rdb);
                sql = GRdbEntityStoreStrategy.this.recycleBinSql.count(sql);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    rs.next();
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
        };
        return (Integer)exec.execute(this.rdb, false);
    }

    @Override
    public String newOid(EntityContext context, EntityHandler handler) {
        return Long.toString(this.counterService.increment(context.getTenantId(handler), COUNTER_SERVICE_INC_KEY, 1L));
    }

    @Override
    public void clean(EntityContext context, EntityHandler handler) {
        log.info("metaEntity restored. id = " + handler.getMetaData().getId() + ". execute cleanup entity data.");
        int tenantId = context.getLocalTenantId();
        String tableNamePostfix = ((MetaGRdbEntityStore)handler.getMetaData().getEntityStoreDefinition()).getTableNamePostfix();
        this.purgeDividedTable(tenantId, handler.getMetaData().getId(), tableNamePostfix, this.rdb);
    }

    @Override
    public void purgeById(EntityContext context, String defId) {
        int tenantId = context.getLocalTenantId();
        log.debug("start purge meta entity data. tenant id = " + tenantId + ",defId = " + defId + ".");
        for (StorageSpaceMap storage : this.dataStore.getStorageSpaceMap().values()) {
            for (String tableNamePostfix : storage.allTableNamePostfix()) {
                this.purgeDividedTable(tenantId, defId, tableNamePostfix, this.rdb);
            }
        }
        log.debug("end purge meta entity data. tenant id = " + tenantId + ",defId = " + defId + ".");
    }

    private void purgeDividedTable(int tenantId, String defId, String tableNamePostfix, RdbAdapter rdb) {
        this.doBatch(tenantId, defId, this.delSql.deleteAllDataByDefId(tenantId, defId, tableNamePostfix, rdb));
        HashSet<String> extIndexTable = new HashSet<String>();
        for (BaseRdbTypeAdapter adaptor : BaseRdbTypeAdapter.values()) {
            if (adaptor instanceof BaseRdbTypeAdapter.Null) continue;
            extIndexTable.add(adaptor.getColOfIndex());
        }
        for (String n : extIndexTable) {
            try {
                this.doBatch(tenantId, defId, this.indexDelSql.deleteAll(tenantId, defId, tableNamePostfix, n, IndexType.UNIQUE, rdb));
            }
            catch (EntityRuntimeException e) {
                log.warn("Unable to delete unique index data, but continue purge processing. indexType = " + n + ", tableNamePostfix = " + tableNamePostfix);
            }
            try {
                this.doBatch(tenantId, defId, this.indexDelSql.deleteAll(tenantId, defId, tableNamePostfix, n, IndexType.NON_UNIQUE, rdb));
            }
            catch (EntityRuntimeException e) {
                log.warn("Unable to delete none unique index data, but continue purge processing. indexType = " + n + ", tableNamePostfix = " + tableNamePostfix);
            }
        }
        this.doBatch(tenantId, defId, this.refDelSql.deleteAll(tenantId, defId, tableNamePostfix, rdb));
        this.doBatch(tenantId, defId, this.refDelSql.deleteAllByTargetDefId(tenantId, defId, tableNamePostfix, rdb));
        this.doBatch(tenantId, defId, this.recycleBinSql.deleteDataRB(tenantId, defId, tableNamePostfix, rdb));
        this.doBatch(tenantId, defId, this.recycleBinSql.deleteRefRB(tenantId, defId, tableNamePostfix, rdb));
        this.doBatch(tenantId, defId, this.recycleBinSql.deleteRefRBByTargetDefId(tenantId, defId, tableNamePostfix, rdb));
    }

    private int doBatch(int tenantId, String defId, final String sql) {
        int count = Transaction.requiresNew(t -> {
            SqlExecuter<Integer> purgeExec = new SqlExecuter<Integer>(){

                @Override
                public Integer logic() throws SQLException {
                    return this.getStatement().executeUpdate(sql);
                }
            };
            return (Integer)purgeExec.execute(this.rdb, true);
        });
        log.debug("execute sql. tenant id = " + tenantId + ", defId = " + defId + ", sql = " + sql + ", count = " + count + ".");
        return count;
    }

    @Override
    public void defragData(final EntityContext context, final EntityHandler handler) {
        Transaction.requiresNew(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                @Override
                public Void logic() throws SQLException {
                    String tableName;
                    Object col;
                    ArrayList<String> refPropertyIds = new ArrayList<String>();
                    for (PropertyHandler property : handler.getDeclaredPropertyList()) {
                        if (!(property instanceof ReferencePropertyHandler) || ((MetaReferenceProperty)property.getMetaData()).getMappedByPropertyMetaDataId() != null) continue;
                        refPropertyIds.add(property.getId());
                    }
                    this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.refDelSql.deleteForDefrag(context.getLocalTenantId(), handler, refPropertyIds, GRdbEntityStoreStrategy.this.rdb));
                    this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.recycleBinSql.deleteForDefragRB(context.getLocalTenantId(), handler, refPropertyIds, GRdbEntityStoreStrategy.this.rdb));
                    HashMap extIndexTable = new HashMap();
                    HashMap extUniqueIndexTable = new HashMap();
                    for (BaseRdbTypeAdapter adaptor : BaseRdbTypeAdapter.values()) {
                        if (adaptor instanceof BaseRdbTypeAdapter.Null) continue;
                        if (!extIndexTable.containsKey(adaptor.getColOfIndex())) {
                            extIndexTable.put(adaptor.getColOfIndex(), new ArrayList());
                        }
                        if (extUniqueIndexTable.containsKey(adaptor.getColOfIndex())) continue;
                        extUniqueIndexTable.put(adaptor.getColOfIndex(), new ArrayList());
                    }
                    for (PrimitivePropertyHandler property : handler.getIndexedPropertyList(context)) {
                        col = (GRdbPropertyStoreRuntime)((Object)property.getStoreSpecProperty());
                        if (!col.isExternalIndex()) continue;
                        List list = property.getMetaData().getIndexType() == IndexType.NON_UNIQUE ? (List)extIndexTable.get(col.getSingleColumnRdbTypeAdapter().getColOfIndex()) : (List)extUniqueIndexTable.get(col.getSingleColumnRdbTypeAdapter().getColOfIndex());
                        col.asList().get(0).getExternalIndexColName();
                        list.add(col.asList().get(0).getExternalIndexColName());
                    }
                    HashSet<String> existTables = new HashSet<String>();
                    ResultSet rs = GRdbEntityStoreStrategy.this.rdb.getTableNames("OBJ_INDEX_%", this.getConnection());
                    col = null;
                    try {
                        while (rs.next()) {
                            existTables.add(rs.getString("TABLE_NAME").toUpperCase());
                        }
                    }
                    catch (Throwable list) {
                        col = list;
                        throw list;
                    }
                    finally {
                        if (rs != null) {
                            if (col != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable list) {
                                    ((Throwable)col).addSuppressed(list);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    rs = GRdbEntityStoreStrategy.this.rdb.getTableNames("OBJ_UNIQUE_%", this.getConnection());
                    col = null;
                    try {
                        while (rs.next()) {
                            existTables.add(rs.getString("TABLE_NAME").toUpperCase());
                        }
                    }
                    catch (Throwable list) {
                        col = list;
                        throw list;
                    }
                    finally {
                        if (rs != null) {
                            if (col != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable list) {
                                    ((Throwable)col).addSuppressed(list);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    if (GRdbEntityStoreStrategy.this.treatNonUniqueExternalIndexTable) {
                        for (Map.Entry e : extIndexTable.entrySet()) {
                            tableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).OBJ_INDEX((String)e.getKey());
                            if (!existTables.contains(tableName)) continue;
                            this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.indexDelSql.deleteForDefrag(context.getLocalTenantId(), handler, (String)e.getKey(), IndexType.NON_UNIQUE, (List)e.getValue(), GRdbEntityStoreStrategy.this.rdb));
                        }
                    }
                    for (Map.Entry e : extUniqueIndexTable.entrySet()) {
                        tableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)handler.getEntityStoreRuntime()).OBJ_UNIQUE((String)e.getKey());
                        if (!existTables.contains(tableName)) continue;
                        this.getStatement().executeUpdate(GRdbEntityStoreStrategy.this.indexDelSql.deleteForDefrag(context.getLocalTenantId(), handler, (String)e.getKey(), IndexType.UNIQUE, (List)e.getValue(), GRdbEntityStoreStrategy.this.rdb));
                    }
                    return null;
                }
            };
            exec.execute(this.rdb, true);
        });
    }

    @Override
    public void bulkUpdate(BulkUpdatable bulkUpdatable, EntityContext entityContext, EntityHandler entityHandler, String clientId) {
        this.buStrategy.bulkUpdate(bulkUpdatable, entityContext, entityHandler, clientId);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    private static final class InsertReferenceTarget {
        ReferencePropertyHandler rh;
        EntityHandler refEh;
        Object value;

        private InsertReferenceTarget(ReferencePropertyHandler rh, EntityHandler refEh, Object value) {
            this.rh = rh;
            this.refEh = refEh;
            this.value = value;
        }
    }
}

