/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.datastore.RdbBaseValueTypeResolver;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRdbSearchResultIterator
implements SearchResultIterator {
    private ResultSet rs;
    private EntityHandler dataModelHandler;
    private EntityContext context;
    private Query query;
    private RdbAdapter rdb;
    private RdbBaseValueTypeResolver resolver;
    private IdentityHashMap<ValueExpression, SelectCol> colMap;
    private List<SelectCol> colList;

    public GRdbSearchResultIterator(ResultSet rs, EntityHandler dataModelHandler, EntityContext context, Query query, RdbAdapter rdb) {
        this.rs = rs;
        this.context = context;
        this.dataModelHandler = dataModelHandler;
        this.query = query;
        this.rdb = rdb;
        this.resolver = new RdbBaseValueTypeResolver(dataModelHandler, context, rdb);
        this.createCol();
    }

    private void createCol() {
        List<ValueExpression> select = this.query.getSelect().getSelectValues();
        this.colMap = new IdentityHashMap(select.size());
        this.colList = new ArrayList<SelectCol>(select.size());
        int res = 1;
        for (ValueExpression v : select) {
            SelectCol col = new SelectCol();
            col.val = v;
            col.colNum = res;
            if (!(v instanceof EntityField)) {
                PropertyType type = this.resolver.resolve(v);
                if (type != null) {
                    col.adapter = this.rdb.getRdbTypeAdapter(type);
                }
                ++res;
            } else {
                PropertyHandler ph = this.dataModelHandler.getPropertyCascade(((EntityField)v).getPropertyName(), this.context);
                col.colDef = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty());
                res += col.colDef.getColCount();
            }
            this.colMap.put(v, col);
            this.colList.add(col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Logger logger;
        Statement stmt = null;
        Connection con = null;
        try {
            stmt = this.rs.getStatement();
            con = stmt.getConnection();
            this.rs.close();
        }
        catch (SQLException e) {
            logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Object getValue(ValueExpression propName) {
        SelectCol col = this.colMap.get(propName);
        if (col == null) {
            throw new EntityRuntimeException(propName + " is not contains select clause.");
        }
        return this.getValueImpl(col);
    }

    private Object getValueImpl(SelectCol col) {
        try {
            if (col.colDef != null) {
                return col.colDef.fromDataStore(this.rs, col.colNum);
            }
            if (col.adapter != null) {
                return col.adapter.fromDataStore(this.rs, col.colNum, this.rdb);
            }
            return this.rs.getObject(col.colNum);
        }
        catch (SQLException e) {
            throw new EntityRuntimeException(col.val + " can not convert.", e);
        }
    }

    @Override
    public Object getValue(int index) {
        return this.getValueImpl(this.colList.get(index));
    }

    @Override
    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    private static class SelectCol {
        ValueExpression val;
        int colNum;
        GRdbPropertyStoreRuntime colDef;
        BaseRdbTypeAdapter adapter;

        private SelectCol() {
        }
    }
}

