/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateState;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.IndexTableKey;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.IndexBulkDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ObjStoreBulkDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ReferenceBulkDeleteSql;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkDeleteHandler {
    private static Logger logger = LoggerFactory.getLogger(BulkDeleteHandler.class);
    BulkDeleteContext objStoreDelete;
    BulkDeleteContext objRefDeleteByOid;
    Map<IndexTableKey, BulkDeleteContext> objIndexDelete;

    BulkDeleteHandler(BulkUpdateState state) throws SQLException {
        GRdbPropertyStoreRuntime colDef;
        this.objStoreDelete = ObjStoreBulkDeleteSql.deleteByOid(state.eh, state.con, state.rdb);
        if (state.eh.getReferencePropertyList(true, state.entityContext).size() > 0) {
            this.objRefDeleteByOid = ReferenceBulkDeleteSql.deleteByOidVersion(state.eh, state.con, state.rdb);
        }
        ArrayList<PrimitivePropertyHandler> indexes = new ArrayList<PrimitivePropertyHandler>();
        for (PrimitivePropertyHandler pph : state.eh.getIndexedPropertyList(state.entityContext)) {
            colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            if (!colDef.isExternalIndex()) continue;
            indexes.add(pph);
        }
        for (PrimitivePropertyHandler pph : indexes) {
            IndexTableKey ikey;
            BulkDeleteContext bdc;
            colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            if (this.objIndexDelete == null) {
                this.objIndexDelete = new HashMap<IndexTableKey, BulkDeleteContext>();
            }
            if ((bdc = this.objIndexDelete.get(ikey = new IndexTableKey(pph.getMetaData().getIndexType(), colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()))) != null) continue;
            bdc = IndexBulkDeleteSql.deleteByOidVersion(colDef.asList().get(0), state.con, state.rdb);
            this.objIndexDelete.put(ikey, bdc);
        }
    }

    public void addValue(BulkUpdateState state, Entity entity) throws SQLException {
        String oid = entity.getOid();
        Long ver = entity.getVersion();
        ObjStoreBulkDeleteSql.addValueForDeleteByOid(this.objStoreDelete, state.tenantId, state.eh, oid, ver);
        if (this.objStoreDelete.getCurrentSize() >= state.rdb.getBatchSize()) {
            this.objStoreDelete.execute();
        }
        if (this.objRefDeleteByOid != null) {
            ReferenceBulkDeleteSql.addValueForDeleteByOidVersion(this.objRefDeleteByOid, state.tenantId, state.eh, oid, ver);
            if (this.objRefDeleteByOid.getCurrentSize() >= state.rdb.getBatchSize()) {
                this.objRefDeleteByOid.execute();
            }
        }
        if (this.objIndexDelete != null) {
            for (Map.Entry<IndexTableKey, BulkDeleteContext> ent : this.objIndexDelete.entrySet()) {
                IndexBulkDeleteSql.addValueForDeleteByOidVersion(ent.getValue(), state.tenantId, state.eh, ent.getKey().indexType, oid, ver);
                if (ent.getValue().getCurrentSize() < state.rdb.getBatchSize()) continue;
                ent.getValue().execute();
            }
        }
    }

    public void flushAll() throws SQLException {
        if (this.objStoreDelete != null && this.objStoreDelete.getCurrentSize() > 0) {
            this.objStoreDelete.execute();
        }
        if (this.objRefDeleteByOid != null && this.objRefDeleteByOid.getCurrentSize() > 0) {
            this.objRefDeleteByOid.execute();
        }
        if (this.objIndexDelete != null) {
            for (Map.Entry<IndexTableKey, BulkDeleteContext> ent : this.objIndexDelete.entrySet()) {
                if (ent.getValue().getCurrentSize() <= 0) continue;
                ent.getValue().execute();
            }
        }
    }

    public void close() {
        if (this.objStoreDelete != null) {
            try {
                this.objStoreDelete.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkDeleteHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objRefDeleteByOid != null) {
            try {
                this.objRefDeleteByOid.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkDeleteHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objIndexDelete != null) {
            for (Map.Entry<IndexTableKey, BulkDeleteContext> ent : this.objIndexDelete.entrySet()) {
                try {
                    ent.getValue().close();
                }
                catch (SQLException e) {
                    logger.error("fail to BulkDeleteHandler close. maybe resource leak.", (Throwable)e);
                }
            }
        }
    }
}

