/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateState;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.IndexTableKey;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.ColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.IndexBulkInsertSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ObjStoreBulkInsertSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ReferenceBulkInsertSql;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkInsertHandler {
    private static Logger logger = LoggerFactory.getLogger(BulkInsertHandler.class);
    BulkInsertContext[] objStoreInsert;
    List<ColumnValueMapper>[] objStoreInsertMapper;
    int[] colSize;
    BulkInsertContext objRefInsert;
    List<ReferencePropertyHandler> refs;
    Map<IndexTableKey, BulkInsertContext> objIndexInsert;
    List<PrimitivePropertyHandler> indexes;
    Statement searchExtIndex;

    BulkInsertHandler(BulkUpdateState state, boolean timestampFromEntity) throws SQLException {
        GRdbPropertyStoreRuntime colDef;
        MetaGRdbEntityStore.GRdbEntityStoreRuntime store = (MetaGRdbEntityStore.GRdbEntityStoreRuntime)state.eh.getEntityStoreRuntime();
        String tableName = store.OBJ_STORE();
        this.objStoreInsertMapper = new List[store.getCurrentMaxPage() + 1];
        this.objStoreInsert = new BulkInsertContext[this.objStoreInsertMapper.length];
        this.colSize = new int[this.objStoreInsertMapper.length];
        for (int i = 0; i <= store.getCurrentMaxPage(); ++i) {
            this.objStoreInsertMapper[i] = i == 0 ? ObjStoreBulkInsertSql.insertMain(state.tenantId, state.eh, state.rdb, state.entityContext, timestampFromEntity) : ObjStoreBulkInsertSql.insertSubPage(state.tenantId, state.eh, i, state.rdb, state.entityContext);
            BulkInsertContext ret = state.rdb.createBulkInsertContext();
            ArrayList<ColumnValue> cv = new ArrayList<ColumnValue>();
            for (ColumnValueMapper m : this.objStoreInsertMapper[i]) {
                m.columns(cv, state.rdb);
            }
            ret.setContext(tableName, cv, state.con);
            this.objStoreInsert[i] = ret;
            this.colSize[i] = cv.size();
        }
        this.refs = state.eh.getReferencePropertyList(true, state.entityContext);
        if (this.refs.size() > 0) {
            this.objRefInsert = ReferenceBulkInsertSql.insert(state.eh, state.con, state.rdb);
        }
        this.indexes = new ArrayList<PrimitivePropertyHandler>();
        for (PrimitivePropertyHandler pph : state.eh.getIndexedPropertyList(state.entityContext)) {
            colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            if (!colDef.isExternalIndex()) continue;
            this.indexes.add(pph);
        }
        for (PrimitivePropertyHandler pph : this.indexes) {
            IndexTableKey ikey;
            BulkInsertContext bic;
            colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            if (this.objIndexInsert == null) {
                this.objIndexInsert = new HashMap<IndexTableKey, BulkInsertContext>();
            }
            if ((bic = this.objIndexInsert.get(ikey = new IndexTableKey(pph.getMetaData().getIndexType(), colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()))) != null) continue;
            bic = IndexBulkInsertSql.insert(colDef.asList().get(0), state.con, state.rdb);
            this.objIndexInsert.put(ikey, bic);
        }
    }

    void addValue(BulkUpdateState state, Entity e) throws SQLException {
        for (int i = 0; i < this.objStoreInsert.length; ++i) {
            ArrayList<Object> values = new ArrayList<Object>(this.colSize[i]);
            for (ColumnValueMapper cm : this.objStoreInsertMapper[i]) {
                cm.values(values, e, state.rdb);
            }
            this.objStoreInsert[i].add(values);
            if (this.objStoreInsert[i].getCurrentSize() < state.rdb.getBatchSize()) continue;
            this.objStoreInsert[i].execute();
        }
        String oid = e.getOid();
        Long ver = e.getVersion();
        if (this.objRefInsert != null) {
            for (ReferencePropertyHandler rh : this.refs) {
                String targetObjDefId = rh.getReferenceEntityHandler(state.entityContext).getMetaData().getId();
                Object val = e.getValue(rh.getName());
                if (val == null) continue;
                if (val instanceof Entity[]) {
                    for (Entity target : (Entity[])val) {
                        ReferenceBulkInsertSql.addValueForInsert(this.objRefInsert, state.tenantId, state.eh, rh.getId(), oid, ver, targetObjDefId, target.getOid(), target.getVersion());
                        if (this.objRefInsert.getCurrentSize() < state.rdb.getBatchSize()) continue;
                        this.objRefInsert.execute();
                    }
                    continue;
                }
                Entity target = (Entity)val;
                ReferenceBulkInsertSql.addValueForInsert(this.objRefInsert, state.tenantId, state.eh, rh.getId(), oid, ver, targetObjDefId, target.getOid(), target.getVersion());
                if (this.objRefInsert.getCurrentSize() < state.rdb.getBatchSize()) continue;
                this.objRefInsert.execute();
            }
        }
        if (this.objIndexInsert != null) {
            for (PrimitivePropertyHandler pph : this.indexes) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef = ((GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty())).asList().get(0);
                IndexTableKey ikey = new IndexTableKey(pph.getMetaData().getIndexType(), colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
                BulkInsertContext bic = this.objIndexInsert.get(ikey);
                Object val = e.getValue(pph.getName());
                boolean needAdd = true;
                if (ikey.indexType != IndexType.NON_UNIQUE) {
                    if (state.eh.isVersioned()) {
                        if (this.searchExtIndex == null) {
                            this.searchExtIndex = state.con.createStatement();
                        }
                        try (ResultSet rs = this.searchExtIndex.executeQuery(IndexBulkInsertSql.searchByOid(state.tenantId, colDef, oid, state.rdb));){
                            if (rs.next()) {
                                needAdd = false;
                            }
                        }
                    }
                    if (ikey.indexType == IndexType.UNIQUE_WITHOUT_NULL && val == null) {
                        needAdd = false;
                    }
                }
                if (needAdd) {
                    IndexBulkInsertSql.addValueForInsert(bic, state.tenantId, colDef, oid, ver, val);
                }
                if (bic.getCurrentSize() < state.rdb.getBatchSize()) continue;
                bic.execute();
            }
        }
    }

    public void flushAll() throws SQLException {
        for (BulkInsertContext bic : this.objStoreInsert) {
            if (bic.getCurrentSize() <= 0) continue;
            bic.execute();
        }
        if (this.objRefInsert != null && this.objRefInsert.getCurrentSize() > 0) {
            this.objRefInsert.execute();
        }
        if (this.objIndexInsert != null) {
            for (Map.Entry entry : this.objIndexInsert.entrySet()) {
                if (((BulkInsertContext)entry.getValue()).getCurrentSize() <= 0) continue;
                ((BulkInsertContext)entry.getValue()).execute();
            }
        }
    }

    public void close() {
        for (BulkInsertContext bic : this.objStoreInsert) {
            try {
                bic.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkInsertHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objRefInsert != null) {
            try {
                this.objRefInsert.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkInsertHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objIndexInsert != null) {
            for (Map.Entry<IndexTableKey, BulkInsertContext> ent : this.objIndexInsert.entrySet()) {
                try {
                    ent.getValue().close();
                }
                catch (SQLException e) {
                    logger.error("fail to BulkInsertHandler close. maybe resource leak.", (Throwable)e);
                }
            }
        }
        if (this.searchExtIndex != null) {
            try {
                this.searchExtIndex.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkInsertHandler close. maybe resource leak.", (Throwable)e);
            }
        }
    }
}

