/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreSearchSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreUpdateSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbEntityStoreStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateStrategy;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EachRecordBulkUpdateStrategy
implements BulkUpdateStrategy {
    private static Logger log = LoggerFactory.getLogger(EachRecordBulkUpdateStrategy.class);
    private GRdbEntityStoreStrategy storeStrategy;
    private RdbAdapter rdb;
    private ObjStoreSearchSql searchSql;

    public EachRecordBulkUpdateStrategy(GRdbEntityStoreStrategy storeStrategy, RdbAdapter rdb) {
        this.storeStrategy = storeStrategy;
        this.rdb = rdb;
        this.searchSql = rdb.getQuerySqlCreator(ObjStoreSearchSql.class);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void bulkUpdate(BulkUpdatable bulkUpdatable, EntityContext entityContext, EntityHandler entityHandler, String clientId) {
        tenantId = entityContext.getLocalTenantId();
        delOp = new DeleteOption(false);
        upOp = new UpdateOption(false);
        updateProps = new ArrayList<String>();
        if (bulkUpdatable.getUpdateProperties() != null) {
            for (String pn : bulkUpdatable.getUpdateProperties()) {
                if (!ObjStoreUpdateSql.canUpdateProperty(entityHandler.getProperty(pn, entityContext))) continue;
                updateProps.add(pn);
            }
        } else {
            for (Object ph : entityHandler.getPropertyList(entityContext)) {
                if (ph instanceof PrimitivePropertyHandler) {
                    if (!ObjStoreUpdateSql.canUpdateProperty((PropertyHandler)ph)) continue;
                    updateProps.add(ph.getName());
                    continue;
                }
                if (!(ph instanceof ReferencePropertyHandler) || ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null) continue;
                updateProps.add(ph.getName());
            }
        }
        upOp.setUpdateProperties(updateProps);
        stmt = null;
        try {
            for (BulkUpdateEntity target : bulkUpdatable) {
                if (target.getEntity().getVersion() == null) {
                    target.getEntity().setVersion(0L);
                }
                switch (1.$SwitchMap$org$iplass$mtp$entity$bulkupdate$BulkUpdateEntity$UpdateMethod[target.getMethod().ordinal()]) {
                    case 1: {
                        this.storeStrategy.delete(entityContext, target.getEntity(), entityHandler, delOp);
                        break;
                    }
                    case 2: {
                        if (target.getEntity().getOid() == null) {
                            target.getEntity().setOid(this.storeStrategy.newOid(entityContext, entityHandler));
                        }
                        this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                        break;
                    }
                    case 3: {
                        oid = target.getEntity().getOid();
                        if (oid == null) {
                            target.getEntity().setOid(this.storeStrategy.newOid(entityContext, entityHandler));
                            this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                            break;
                        }
                        if (stmt == null) {
                            stmt = this.rdb.getConnection().prepareStatement(this.searchSql.checkExistsSql(tenantId, entityHandler, target.getEntity(), this.rdb));
                        }
                        this.searchSql.checkExistsParameter((PreparedStatement)stmt, tenantId, entityHandler, target.getEntity());
                        rs = stmt.executeQuery();
                        var14_16 = null;
                        if (rs.next()) {
                            this.storeStrategy.update(entityContext, entityHandler, target.getEntity(), upOp);
                        } else {
                            this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                        }
                        if (rs == null) break;
                        if (var14_16 == null) ** GOTO lbl64
                        try {
                            rs.close();
                        }
                        catch (Throwable var15_17) {
                            var14_16.addSuppressed(var15_17);
                        }
                        break;
lbl64:
                        // 1 sources

                        rs.close();
                        break;
                        catch (Throwable var15_18) {
                            try {
                                var14_16 = var15_18;
                                throw var15_18;
                            }
                            catch (Throwable var16_19) {
                                if (rs != null) {
                                    if (var14_16 != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable var17_20) {
                                            var14_16.addSuppressed(var17_20);
                                        }
                                    } else {
                                        rs.close();
                                    }
                                }
                                throw var16_19;
                            }
                        }
                    }
                    case 4: {
                        this.storeStrategy.update(entityContext, entityHandler, target.getEntity(), upOp);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                bulkUpdatable.updated(target);
            }
        }
        catch (SQLException e) {
            throw new EntityRuntimeException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    EachRecordBulkUpdateStrategy.log.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
    }
}

