/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper;

import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.PropertyColumnValue;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.ColumnValueMapper;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;

public class PropertyColumnValueMapper
implements ColumnValueMapper {
    private int tenantId;
    private EntityHandler eh;
    private PrimitivePropertyHandler ph;
    private int pageNo;
    private String internalIndexKey;

    public PropertyColumnValueMapper(int tenantId, EntityHandler eh, PrimitivePropertyHandler ph, int pageNo) {
        this.tenantId = tenantId;
        this.eh = eh;
        this.ph = ph;
        this.pageNo = pageNo;
    }

    @Override
    public void columns(List<ColumnValue> columnValues, RdbAdapter rdb) {
        GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)this.ph.getStoreSpecProperty());
        if (!colDef.isMulti()) {
            MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
            if (scol.getMetaData().getPageNo() == this.pageNo) {
                columnValues.add(new PropertyColumnValue(scol.getMetaData().getColumnName(), scol.getSingleColumnRdbTypeAdapter(), scol.isNative(), null, rdb));
            }
            if (!scol.isExternalIndex() && scol.getIndexColName() != null && scol.getMetaData().getIndexPageNo() == this.pageNo) {
                columnValues.add(new DynamicColumnValue(scol.getIndexColName() + "_TD", rdb));
                columnValues.add(new PropertyColumnValue(scol.getIndexColName(), scol.getSingleColumnRdbTypeAdapter(), false, null, rdb));
                this.internalIndexKey = MetaGRdbPropertyStore.makeInternalIndexKey(this.tenantId, this.eh.getMetaData().getId(), this.pageNo);
            }
        } else {
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            for (MetaGRdbPropertyStore metaCol : mcol.getMetaData().getStore()) {
                if (metaCol.getPageNo() != this.pageNo) continue;
                columnValues.add(new PropertyColumnValue(metaCol.getColumnName(), mcol.getSingleColumnRdbTypeAdapter(), mcol.isNative(), null, rdb));
            }
        }
    }

    @Override
    public void values(List<Object> values, Entity target, RdbAdapter rdb) {
        GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)this.ph.getStoreSpecProperty());
        Object val = target.getValue(this.ph.getName());
        if (!colDef.isMulti()) {
            MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
            if (scol.getMetaData().getPageNo() == this.pageNo) {
                values.add(val);
            }
            if (!scol.isExternalIndex() && scol.getIndexColName() != null && scol.getMetaData().getIndexPageNo() == this.pageNo) {
                switch (scol.getIndexType()) {
                    case UNIQUE: {
                        values.add(this.internalIndexKey);
                        values.add(val);
                        break;
                    }
                    case UNIQUE_WITHOUT_NULL: 
                    case NON_UNIQUE: {
                        if (val != null) {
                            values.add(this.internalIndexKey);
                            values.add(val);
                            break;
                        }
                        values.add(null);
                        values.add(null);
                        break;
                    }
                }
            }
        } else {
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            for (int i = 0; i < mcol.getMetaData().getStore().size(); ++i) {
                MetaGRdbPropertyStore metaCol = mcol.getMetaData().getStore().get(i);
                if (metaCol.getPageNo() != this.pageNo) continue;
                if (val instanceof Object[]) {
                    Object[] valList = (Object[])val;
                    if (i < valList.length) {
                        values.add(valList[i]);
                        continue;
                    }
                    values.add(null);
                    continue;
                }
                if (i == 0) {
                    values.add(val);
                    continue;
                }
                values.add(null);
            }
        }
    }
}

