/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.IndexBulkInsertSql;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;

public class IndexBulkDeleteSql {
    private static final Long LONG_ZERO = 0L;

    public static BulkDeleteContext deleteByOidVersion(MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, Connection con, RdbAdapter rdb) throws SQLException {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        String indexTableName = IndexBulkInsertSql.indexTableName(eh, colDef);
        BulkDeleteContext bdc = rdb.createBulkDeleteContext();
        ArrayList<ColumnValue> columnValue = new ArrayList<ColumnValue>(4);
        columnValue.add(new DynamicColumnValue("TENANT_ID", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_DEF_ID", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_ID", rdb));
        if (type == IndexType.NON_UNIQUE) {
            columnValue.add(new DynamicColumnValue("OBJ_VER", rdb));
        }
        bdc.setContext(indexTableName, columnValue, null, con);
        return bdc;
    }

    public static void addValueForDeleteByOidVersion(BulkDeleteContext bdc, int tenantId, EntityHandler eh, IndexType type, String oid, Long version) throws SQLException {
        ArrayList<Object> values = type == IndexType.NON_UNIQUE ? new ArrayList<Object>(4) : new ArrayList(3);
        values.add(tenantId);
        values.add(eh.getMetaData().getId());
        values.add(oid);
        if (type == IndexType.NON_UNIQUE) {
            if (version == null) {
                version = LONG_ZERO;
            }
            values.add(version);
        }
        bdc.add(values);
    }

    public static BulkDeleteContext deleteByOidVersionColName(MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, Connection con, RdbAdapter rdb) throws SQLException {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        String indexTableName = IndexBulkInsertSql.indexTableName(eh, colDef);
        BulkDeleteContext bdc = rdb.createBulkDeleteContext();
        ArrayList<ColumnValue> columnValue = new ArrayList<ColumnValue>(5);
        columnValue.add(new DynamicColumnValue("TENANT_ID", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_DEF_ID", rdb));
        columnValue.add(new DynamicColumnValue("COL_NAME", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_ID", rdb));
        if (type == IndexType.NON_UNIQUE) {
            columnValue.add(new DynamicColumnValue("OBJ_VER", rdb));
        }
        bdc.setContext(indexTableName, columnValue, null, con);
        return bdc;
    }

    public static void addValueForDeleteByOidVersionColName(BulkDeleteContext bdc, int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, Long version) throws SQLException {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        ArrayList<Object> values = type == IndexType.NON_UNIQUE ? new ArrayList<Object>(5) : new ArrayList(4);
        values.add(tenantId);
        values.add(eh.getMetaData().getId());
        values.add(colDef.getExternalIndexColName());
        values.add(oid);
        if (type == IndexType.NON_UNIQUE) {
            if (version == null) {
                version = LONG_ZERO;
            }
            values.add(version);
        }
        bdc.add(values);
    }
}

