/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.PropertyColumnValue;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;

public class IndexBulkInsertSql {
    private static final Long LONG_ZERO = 0L;

    public static String indexTableName(EntityHandler eh, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef) {
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        if (type == IndexType.NON_UNIQUE) {
            return ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
        }
        return ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
    }

    public static BulkInsertContext insert(MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, Connection con, RdbAdapter rdb) throws SQLException {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        String indexTableName = IndexBulkInsertSql.indexTableName(eh, colDef);
        BulkInsertContext bic = rdb.createBulkInsertContext();
        ArrayList<ColumnValue> columnValue = new ArrayList<ColumnValue>();
        columnValue.add(new DynamicColumnValue("TENANT_ID", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_DEF_ID", rdb));
        columnValue.add(new DynamicColumnValue("COL_NAME", rdb));
        columnValue.add(new DynamicColumnValue("OBJ_ID", rdb));
        if (type == IndexType.NON_UNIQUE) {
            columnValue.add(new DynamicColumnValue("OBJ_VER", rdb));
        }
        columnValue.add(new PropertyColumnValue("VAL", colDef.getSingleColumnRdbTypeAdapter(), false, null, rdb));
        bic.setContext(indexTableName, columnValue, con);
        return bic;
    }

    public static void addValueForInsert(BulkInsertContext bic, int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, Long version, Object value) throws SQLException {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        ArrayList<Object> values = type == IndexType.NON_UNIQUE ? new ArrayList<Object>(6) : new ArrayList(5);
        values.add(tenantId);
        values.add(eh.getMetaData().getId());
        values.add(colDef.getExternalIndexColName());
        values.add(oid);
        if (type == IndexType.NON_UNIQUE) {
            if (version == null) {
                version = LONG_ZERO;
            }
            values.add(version);
        }
        values.add(value);
        bic.add(values);
    }

    public static String searchByOid(int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, RdbAdapter rdbAdaptor) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT VAL FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(objDefId)).append("'");
        sb.append(" AND OBJ_ID='").append(rdbAdaptor.sanitize(oid)).append("'");
        sb.append(" AND COL_NAME='").append(rdbAdaptor.sanitize(colDef.getExternalIndexColName())).append("'");
        return sb.toString();
    }
}

