/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.ColumnPosition;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.RawColIndexType;
import org.iplass.mtp.impl.datastore.grdb.RawColType;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColConverter;

public class ColContext {
    private Map<Integer, List<ColCopy>> colParPage;

    public boolean hasColCopy() {
        return this.colParPage != null && this.colParPage.size() > 0;
    }

    public List<ColCopy> getColCopyList(int pageNo) {
        if (this.colParPage == null) {
            return null;
        }
        return this.colParPage.get(pageNo);
    }

    private void add(ColConverter converter, int toPageNo, String toColName, int fromPageNo, String fromColName, IndexType indexType) {
        List<ColCopy> list;
        if (this.colParPage == null) {
            this.colParPage = new HashMap<Integer, List<ColCopy>>();
        }
        if ((list = this.colParPage.get(toPageNo)) == null) {
            list = new ArrayList<ColCopy>();
            this.colParPage.put(toPageNo, list);
        }
        list.add(new ColCopy(converter, toPageNo, toColName, fromPageNo, fromColName, indexType));
    }

    public void addConvert(ColConverter converter, MetaGRdbPropertyStore toStore, MetaGRdbPropertyStore fromStore) {
        this.add(converter, toStore.getPageNo(), toStore.getColumnName(), fromStore.getPageNo(), fromStore.getColumnName(), null);
    }

    public void addIndexConvert(ColConverter converter, IndexType indexType, MetaGRdbPropertyStore toStore, MetaGRdbPropertyStore fromStore) {
        RawColType ct = RawColType.typeOf(converter.to);
        this.add(converter, toStore.getIndexPageNo(), ct.getIndexColNamePrefix(indexType) + toStore.getIndexColumnNo(), fromStore.getPageNo(), fromStore.getColumnName(), indexType);
    }

    public void addMove(ColumnPosition to, ColumnPosition from, RawColType ct, IndexType indexType) {
        RawColIndexType cit = RawColIndexType.typeOf(indexType);
        this.add(new ColConverter.NoneColConverter(null, null), to.getPageNo(), ct.getColNamePrefix(cit) + to.getColumnNo(), from.getPageNo(), ct.getColNamePrefix(cit) + from.getColumnNo(), indexType);
    }

    public void addSetNull(ColumnPosition to, RawColType ct, IndexType indexType) {
        List<ColCopy> list;
        if (this.colParPage == null) {
            this.colParPage = new HashMap<Integer, List<ColCopy>>();
        }
        if ((list = this.colParPage.get(to.getPageNo())) == null) {
            list = new ArrayList<ColCopy>();
            this.colParPage.put(to.getPageNo(), list);
        }
        RawColIndexType cit = RawColIndexType.typeOf(indexType);
        list.add(new ColCopy(to.getPageNo(), ct.getColNamePrefix(cit) + to.getColumnNo(), indexType, true));
    }

    public static class ColCopy {
        IndexType indexType;
        ColConverter converter;
        int toPageNo;
        String toColName;
        int fromPageNo;
        String fromColName;
        boolean setToNull;

        public ColCopy(ColConverter converter, int toPageNo, String toColName, int fromPageNo, String fromColName, IndexType indexType) {
            this.converter = converter;
            this.toPageNo = toPageNo;
            this.toColName = toColName;
            this.fromPageNo = fromPageNo;
            this.fromColName = fromColName;
            this.indexType = indexType;
        }

        public ColCopy(int toPageNo, String toColName, IndexType indexType, boolean setToNull) {
            this.toPageNo = toPageNo;
            this.toColName = toColName;
            this.indexType = indexType;
            this.setToNull = setToNull;
        }

        public boolean isSetToNull() {
            return this.setToNull;
        }

        public IndexType getIndexType() {
            return this.indexType;
        }

        public ColConverter getConverter() {
            return this.converter;
        }

        public int getToPageNo() {
            return this.toPageNo;
        }

        public String getToColName() {
            return this.toColName;
        }

        public int getFromPageNo() {
            return this.fromPageNo;
        }

        public String getFromColName() {
            return this.fromColName;
        }
    }
}

