/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColConverterFactory;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.BooleanType;
import org.iplass.mtp.impl.properties.basic.DateTimeType;
import org.iplass.mtp.impl.properties.basic.DateType;
import org.iplass.mtp.impl.properties.basic.DecimalType;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.basic.TimeType;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.properties.extend.LongTextType;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class ColConverter {
    private static ColConverterFactory factory = ServiceRegistry.getRegistry().getService(ColConverterFactory.class);
    protected PropertyType from;
    protected PropertyType to;

    ColConverter(PropertyType from, PropertyType to) {
        this.from = from;
        this.to = to;
    }

    public abstract void appendConvertExp(StringBuilder var1, String var2, RdbAdapter var3);

    public abstract boolean canUseSameCol();

    public static class CastColConverter
    extends ColConverter {
        CastColConverter(PropertyType from, PropertyType to) {
            super(from, to);
        }

        @Override
        public void appendConvertExp(StringBuilder sb, String fromCol, RdbAdapter rdb) {
            BaseRdbTypeAdapter fromTypeAdapter = rdb.getRdbTypeAdapter(this.from);
            BaseRdbTypeAdapter toTypeAdapter = rdb.getRdbTypeAdapter(this.to);
            StringBuilder fromColSb = new StringBuilder(fromCol.length() + 16);
            fromTypeAdapter.appendFromTypedCol(fromColSb, rdb, () -> fromColSb.append(fromCol));
            Integer scale = this.to instanceof DecimalType ? Integer.valueOf(((DecimalType)this.to).getScale()) : null;
            toTypeAdapter.appendToTypedCol(sb, rdb, () -> sb.append(rdb.cast(fromTypeAdapter.sqlType(), toTypeAdapter.sqlType(), fromColSb, null, scale)));
        }

        @Override
        public boolean canUseSameCol() {
            switch (this.to.getEnumType()) {
                case DECIMAL: {
                    if (this.from instanceof DecimalType) {
                        DecimalType toDec = (DecimalType)this.to;
                        DecimalType fromDec = (DecimalType)this.from;
                        return toDec.getScale() == fromDec.getScale();
                    }
                    return false;
                }
                case SELECT: {
                    if (this.from instanceof SelectType) {
                        return true;
                    }
                    return this.from instanceof BooleanType;
                }
                case DATETIME: {
                    if (this.from instanceof DateTimeType) {
                        return true;
                    }
                    if (this.from instanceof DateType) {
                        return true;
                    }
                    return this.from instanceof TimeType;
                }
                case AUTONUMBER: {
                    if (this.from instanceof AutoNumberType) {
                        return true;
                    }
                    return this.from instanceof StringType;
                }
                case STRING: {
                    switch (this.from.getEnumType()) {
                        case AUTONUMBER: 
                        case BOOLEAN: 
                        case SELECT: 
                        case STRING: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return this.to.equals(this.from);
        }
    }

    public static class LongTextColConverter
    extends ColConverter {
        private ColConverter wrapped;

        LongTextColConverter(PropertyType from, PropertyType to) {
            super(from, to);
            this.wrapped = factory.getColConverter(from, new StringType());
        }

        @Override
        public void appendConvertExp(StringBuilder sb, String fromCol, RdbAdapter rdb) {
            StringBuilder inner = new StringBuilder();
            FunctionAdapter<Function> fa = rdb.resolveFunction("CONCAT");
            ArrayList<CharSequence> arg = new ArrayList<CharSequence>(2);
            StringBuilder arg1 = new StringBuilder();
            arg1.append('\'');
            LongTextType.LongText.appendLongTextFromStringExpression(arg1);
            arg1.append('\'');
            arg.add(arg1);
            StringBuilder arg2 = new StringBuilder();
            this.wrapped.appendConvertExp(arg2, fromCol, rdb);
            arg.add(arg2);
            fa.toSQL(inner, arg, rdb);
            sb.append(rdb.cast(12, 12, inner, null, null));
        }

        @Override
        public boolean canUseSameCol() {
            return this.to.equals(this.from);
        }
    }

    public static class NoneColConverter
    extends ColConverter {
        public NoneColConverter(PropertyType from, PropertyType to) {
            super(from, to);
        }

        @Override
        public void appendConvertExp(StringBuilder sb, String fromCol, RdbAdapter rdb) {
            sb.append(fromCol);
        }

        @Override
        public boolean canUseSameCol() {
            return true;
        }
    }
}

