/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff;

import java.sql.SQLException;
import java.sql.Statement;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColResolver;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.Diff;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.InsPropertyIndexType;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class InsProperty
extends Diff {
    private InsPropertyIndexType insPropertyIndexType;
    private MetaPrimitiveProperty insertProperty;
    private ColResolver colResolver;
    private MetaEntity entity;

    public InsProperty(MetaPrimitiveProperty insertProperty, MetaEntity entity, ColResolver colResolver) {
        this.insertProperty = insertProperty;
        this.colResolver = colResolver;
        this.entity = entity;
        if (insertProperty.getIndexType() != null && insertProperty.getIndexType() != IndexType.NON_INDEXED && !insertProperty.getType().isVirtual()) {
            this.insPropertyIndexType = new InsPropertyIndexType(insertProperty, entity);
        }
    }

    @Override
    public void applyToData(Statement stmt, RdbAdapter rdb, int tenantId) throws SQLException {
        if (this.insPropertyIndexType != null) {
            this.insPropertyIndexType.applyToData(stmt, rdb, tenantId);
        }
    }

    @Override
    public void modifyMetaData() {
        this.colResolver.allocateCol(this.insertProperty, null, this.entity.getVersionControlType());
        if (this.insPropertyIndexType != null) {
            this.insPropertyIndexType.modifyMetaData();
        }
    }

    @Override
    public boolean needDataModify() {
        if (this.insPropertyIndexType == null) {
            return false;
        }
        return this.insPropertyIndexType.needDataModify();
    }
}

