/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff;

import java.sql.SQLException;
import java.sql.Statement;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexInsertSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.Diff;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class UpdPropertyIndexType
extends Diff {
    private MetaPrimitiveProperty previousProperty;
    private MetaPrimitiveProperty nextProperty;
    private MetaEntity nextEntity;

    public UpdPropertyIndexType(MetaPrimitiveProperty previousProperty, MetaPrimitiveProperty nextProperty, MetaEntity nextEntity) {
        this.previousProperty = previousProperty;
        this.nextProperty = nextProperty;
        this.nextEntity = nextEntity;
    }

    @Override
    public void applyToData(Statement stmt, RdbAdapter rdb, int tenantId) throws SQLException {
        if (this.needDataModify()) {
            MetaGRdbPropertyStore propStore;
            boolean doExecute = false;
            if (this.previousProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore && (propStore = (MetaGRdbPropertyStore)this.previousProperty.getEntityStoreProperty()).isExternalIndex()) {
                IndexDeleteSql delSql = rdb.getUpdateSqlCreator(IndexDeleteSql.class);
                stmt.addBatch(delSql.deleteByColName(tenantId, this.nextEntity.getId(), ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).getTableNamePostfix(), propStore.getPageNo(), propStore.getColumnName(), rdb.getRdbTypeAdapter(this.previousProperty.getType()), this.previousProperty.getIndexType(), rdb));
                doExecute = true;
            }
            if (this.nextProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore && (propStore = (MetaGRdbPropertyStore)this.nextProperty.getEntityStoreProperty()).isExternalIndex()) {
                BaseRdbTypeAdapter typeMapping = rdb.getRdbTypeAdapter(this.nextProperty.getType());
                IndexDeleteSql delSql = rdb.getUpdateSqlCreator(IndexDeleteSql.class);
                stmt.addBatch(delSql.deleteByColName(tenantId, this.nextEntity.getId(), ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).getTableNamePostfix(), propStore.getPageNo(), propStore.getColumnName(), typeMapping, this.nextProperty.getIndexType(), rdb));
                IndexInsertSql insSql = rdb.getUpdateSqlCreator(IndexInsertSql.class);
                stmt.addBatch(insSql.insertAll(tenantId, this.nextEntity.getId(), ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).getTableNamePostfix(), propStore.getPageNo(), propStore.getColumnName(), this.nextProperty.getIndexType(), typeMapping, rdb));
                doExecute = true;
            }
            if (doExecute) {
                stmt.executeBatch();
            }
        }
    }

    @Override
    public void modifyMetaData() {
    }

    @Override
    public boolean needDataModify() {
        if (this.previousProperty.getIndexType() != this.nextProperty.getIndexType()) {
            return true;
        }
        if (!(this.previousProperty.getType().isCompatibleTo(this.nextProperty.getType()) || this.previousProperty.getType().isVirtual() && this.nextProperty.getType().isVirtual())) {
            return true;
        }
        if (!this.nextProperty.getType().isVirtual()) {
            if (this.nextProperty.getMultiplicity() != this.previousProperty.getMultiplicity()) {
                return true;
            }
            if (this.isExternalIndex(this.nextProperty) != this.isExternalIndex(this.previousProperty)) {
                return true;
            }
        }
        return false;
    }

    private boolean isExternalIndex(MetaPrimitiveProperty p) {
        if (p.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
            return false;
        }
        if (p.getEntityStoreProperty() instanceof MetaGRdbPropertyStore) {
            return ((MetaGRdbPropertyStore)p.getEntityStoreProperty()).isExternalIndex();
        }
        return false;
    }
}

