/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.tableallocators;

import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.TableAllocator;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class HashingTableAllocator
implements TableAllocator {
    private boolean useMetaDataId = true;
    private boolean useTenantId = true;

    public boolean isUseMetaDataId() {
        return this.useMetaDataId;
    }

    public void setUseMetaDataId(boolean useMetaDataId) {
        this.useMetaDataId = useMetaDataId;
    }

    public boolean isUseTenantId() {
        return this.useTenantId;
    }

    public void setUseTenantId(boolean useTenantId) {
        this.useTenantId = useTenantId;
    }

    @Override
    public int allocate(int tenantId, String metaId, StorageSpaceMap storage) {
        return Math.abs(this.toKey(tenantId, metaId).hashCode() % storage.getTableCount());
    }

    private String toKey(int tenantId, String metaId) {
        if (this.useMetaDataId) {
            if (this.useTenantId) {
                return metaId + tenantId;
            }
            return metaId;
        }
        if (this.useTenantId) {
            return Integer.toString(tenantId);
        }
        throw new ServiceConfigrationException("At least useMetaDataId or useTenantId must be specified to true.");
    }
}

