/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;

class BulkUpdateAdapter
implements BulkUpdatable {
    private static final String BEFORE_UPDATE_ENTITY = "____mtp_beforeUpdateEntity_";
    private BulkUpdatable actual;
    private EntityHandler eh;
    private EntityContext ec;
    private UpdateOption op;
    private Timestamp sysdate;
    private List<PropertyHandler> complexWrapperTypePropList;
    private List<PropertyHandler> autoNumPropList;

    BulkUpdateAdapter(BulkUpdatable actual, EntityHandler eh, EntityContext ec) {
        this.actual = actual;
        this.eh = eh;
        this.ec = ec;
        this.complexWrapperTypePropList = eh.getPropertyListByPropertyType(ComplexWrapperType.class, ec);
        this.autoNumPropList = eh.getPropertyListByPropertyType(AutoNumberType.class, ec);
        if (actual.getUpdateProperties() != null && actual.getUpdateProperties().size() > 0) {
            this.op = new UpdateOption(false);
            this.op.setUpdateProperties(actual.getUpdateProperties());
        }
    }

    @Override
    public Iterator<BulkUpdateEntity> iterator() {
        return new It(this.actual.iterator(), ExecuteContext.getCurrentContext().getClientId());
    }

    @Override
    public String getDefinitionName() {
        return this.actual.getDefinitionName();
    }

    @Override
    public void updated(BulkUpdateEntity updatedEntity) {
        if (updatedEntity instanceof BulkUpdateEntityWrapper) {
            Entity before;
            if (updatedEntity.getMethod() == BulkUpdateEntity.UpdateMethod.DELETE && (before = (Entity)updatedEntity.getEntity().getValue(BEFORE_UPDATE_ENTITY)) != null) {
                this.eh.postporcessDeleteDirect(before, this.ec, this.complexWrapperTypePropList, null);
            }
            BulkUpdateEntity forRet = ((BulkUpdateEntityWrapper)updatedEntity).actualBulkUpdateEntity;
            forRet.getEntity().setOid(updatedEntity.getEntity().getOid());
            forRet.getEntity().setVersion(updatedEntity.getEntity().getVersion());
            if (this.autoNumPropList != null) {
                for (PropertyHandler ph : this.autoNumPropList) {
                    forRet.getEntity().setValue(ph.getName(), updatedEntity.getEntity().getValue(ph.getName()));
                }
            }
            this.actual.updated(forRet);
        } else {
            this.actual.updated(updatedEntity);
        }
    }

    @Override
    public void close() {
        this.actual.close();
    }

    @Override
    public List<String> getUpdateProperties() {
        return this.actual.getUpdateProperties();
    }

    @Override
    public boolean isEnableAuditPropertySpecification() {
        return this.actual.isEnableAuditPropertySpecification();
    }

    private class It
    implements Iterator<BulkUpdateEntity> {
        private Iterator<BulkUpdateEntity> actualIt;
        private String clientId;

        private It(Iterator<BulkUpdateEntity> actualIt, String clientId) {
            this.actualIt = actualIt;
            this.clientId = clientId;
        }

        @Override
        public boolean hasNext() {
            return this.actualIt.hasNext();
        }

        private Timestamp sysdate() {
            if (BulkUpdateAdapter.this.sysdate == null) {
                BulkUpdateAdapter.this.sysdate = new Timestamp(System.currentTimeMillis());
            }
            return BulkUpdateAdapter.this.sysdate;
        }

        @Override
        public BulkUpdateEntity next() {
            BulkUpdateEntityWrapper forInternalUse = new BulkUpdateEntityWrapper(this.actualIt.next());
            if (forInternalUse.getEntity().getVersion() == null) {
                forInternalUse.getEntity().setVersion(0L);
            }
            if (BulkUpdateAdapter.this.isEnableAuditPropertySpecification()) {
                if (forInternalUse.getEntity().getCreateBy() == null) {
                    forInternalUse.getEntity().setCreateBy(this.clientId);
                }
                if (forInternalUse.getEntity().getUpdateBy() == null) {
                    forInternalUse.getEntity().setUpdateBy(this.clientId);
                }
            } else {
                forInternalUse.getEntity().setCreateBy(this.clientId);
                forInternalUse.getEntity().setUpdateBy(this.clientId);
            }
            if (forInternalUse.getEntity().getState() == null) {
                forInternalUse.getEntity().setState(new SelectValue("V"));
            }
            if (BulkUpdateAdapter.this.isEnableAuditPropertySpecification()) {
                if (forInternalUse.getEntity().getCreateDate() == null) {
                    forInternalUse.getEntity().setCreateDate(this.sysdate());
                }
                if (forInternalUse.getEntity().getUpdateDate() == null) {
                    forInternalUse.getEntity().setUpdateDate(this.sysdate());
                }
            }
            switch (forInternalUse.actualBulkUpdateEntity.getMethod()) {
                case INSERT: {
                    BulkUpdateAdapter.this.eh.nomalizeInternal(forInternalUse.getEntity(), null, BulkUpdateAdapter.this.ec);
                    BulkUpdateAdapter.this.eh.preprocessInsertDirect(forInternalUse.getEntity(), BulkUpdateAdapter.this.ec, BulkUpdateAdapter.this.complexWrapperTypePropList);
                    break;
                }
                case UPDATE: {
                    BulkUpdateAdapter.this.eh.nomalizeInternal(forInternalUse.getEntity(), BulkUpdateAdapter.this.op == null ? null : BulkUpdateAdapter.this.op.getUpdateProperties(), BulkUpdateAdapter.this.ec);
                    BulkUpdateAdapter.this.eh.preprocessUpdateDirect(forInternalUse.getEntity(), BulkUpdateAdapter.this.op, BulkUpdateAdapter.this.ec, BulkUpdateAdapter.this.complexWrapperTypePropList, true);
                    break;
                }
                case DELETE: {
                    Entity beforedelete = BulkUpdateAdapter.this.eh.preporcessDeleteDirect(forInternalUse.getEntity(), BulkUpdateAdapter.this.ec, BulkUpdateAdapter.this.complexWrapperTypePropList);
                    forInternalUse.getEntity().setValue(BulkUpdateAdapter.BEFORE_UPDATE_ENTITY, beforedelete);
                    break;
                }
                case MERGE: {
                    BulkUpdateAdapter.this.eh.nomalizeInternal(forInternalUse.getEntity(), null, BulkUpdateAdapter.this.ec);
                    if (forInternalUse.getEntity().getOid() == null) {
                        BulkUpdateAdapter.this.eh.preprocessInsertDirect(forInternalUse.getEntity(), BulkUpdateAdapter.this.ec, BulkUpdateAdapter.this.complexWrapperTypePropList);
                        forInternalUse.setMethod(BulkUpdateEntity.UpdateMethod.INSERT);
                        break;
                    }
                    boolean isPrevExists = BulkUpdateAdapter.this.eh.preprocessUpdateDirect(forInternalUse.getEntity(), BulkUpdateAdapter.this.op, BulkUpdateAdapter.this.ec, BulkUpdateAdapter.this.complexWrapperTypePropList, false);
                    if (!isPrevExists) break;
                    forInternalUse.setMethod(BulkUpdateEntity.UpdateMethod.UPDATE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return forInternalUse;
        }
    }

    private static class BulkUpdateEntityWrapper
    extends BulkUpdateEntity {
        BulkUpdateEntity actualBulkUpdateEntity;

        public BulkUpdateEntityWrapper(BulkUpdateEntity actualBulkUpdateEntity) {
            this.actualBulkUpdateEntity = actualBulkUpdateEntity;
            this.setMethod(actualBulkUpdateEntity.getMethod());
            this.setEntity(((GenericEntity)actualBulkUpdateEntity.getEntity()).copy());
        }
    }
}

