/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;

public class EntityContext {
    private int localTenantId;
    private int sharedTenantId;
    private EntityService service;

    public EntityContext(int localTenantId, int sharedTenantId, EntityService service) {
        this.localTenantId = localTenantId;
        this.sharedTenantId = sharedTenantId;
        this.service = service;
    }

    public int getLocalTenantId() {
        return this.localTenantId;
    }

    public int getSharedTenantId() {
        return this.sharedTenantId;
    }

    public int getTenantId(EntityHandler eh) {
        if (eh.isUseSharedData()) {
            return this.sharedTenantId;
        }
        return this.localTenantId;
    }

    public EntityHandler getHandlerByName(String name) {
        return this.service.getRuntimeByName(name);
    }

    public EntityHandler getHandlerById(String id) {
        return this.service.getRuntimeById(id);
    }

    public void refreshTransactionLocalCache(String id) {
        MetaDataContext.getContext().refreshTransactionLocalCache(id);
    }

    public static EntityContext getCurrentContext() {
        Transaction t;
        TenantContext tenantContext = ExecuteContext.getCurrentContext().getTenantContext();
        TransactionManager tm = ServiceRegistry.getRegistry().getService(TransactionService.class).getTransacitonManager();
        if (tm != null && (t = tm.currentTransaction()) != null && t.getStatus() == TransactionStatus.ACTIVE) {
            String key = EntityContext.class.getName() + ":" + tenantContext.getTenantId();
            EntityContext metaContext = (EntityContext)t.getAttribute(key);
            if (metaContext == null) {
                int sharedTenantId = ServiceRegistry.getRegistry().getService(TenantContextService.class).getSharedTenantId();
                metaContext = new EntityContext(tenantContext.getTenantId(), sharedTenantId, ServiceRegistry.getRegistry().getService(EntityService.class));
                t.setAttribute(key, metaContext);
            }
            return metaContext;
        }
        int sharedTenantId = ServiceRegistry.getRegistry().getService(TenantContextService.class).getSharedTenantId();
        return new EntityContext(tenantContext.getTenantId(), sharedTenantId, ServiceRegistry.getRegistry().getService(EntityService.class));
    }
}

