/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.auditlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auditlog.AuditLoggingService;
import org.iplass.mtp.impl.entity.auditlog.LogMaskHandler;
import org.iplass.mtp.impl.entity.auditlog.MaskTarget;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerAuditLoggingService
implements AuditLoggingService {
    private static Logger logger = LoggerFactory.getLogger((String)"mtp.audit");
    private boolean logCompact;
    private int textMaxLength = 256;
    private boolean logQuery;
    private boolean logSelectValueWithLabel;
    private boolean logReferenceWithLabel;
    private Map<String, PropertyMaskTarget> maskTargetMap;
    private boolean hasEntityWildcard;

    public boolean isLogQuery() {
        return this.logQuery;
    }

    public boolean isLogCompact() {
        return this.logCompact;
    }

    public boolean isLogSelectValueWithLabel() {
        return this.logSelectValueWithLabel;
    }

    public boolean isLogReferenceWithLabel() {
        return this.logReferenceWithLabel;
    }

    public int getTextMaxLength() {
        return this.textMaxLength;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        this.logQuery = "TRUE".equalsIgnoreCase(config.getValue("logQuery"));
        this.logCompact = "TRUE".equalsIgnoreCase(config.getValue("logCompact"));
        this.logSelectValueWithLabel = "TRUE".equalsIgnoreCase(config.getValue("logSelectValueWithLabel"));
        this.logReferenceWithLabel = "TRUE".equalsIgnoreCase(config.getValue("logReferenceWithLabel"));
        if (config.getValue("cutSize") != null) {
            this.textMaxLength = Integer.parseInt(config.getValue("textMaxLength"));
        }
        if (config.getValues("maskTarget", MaskTarget.class) != null) {
            List<MaskTarget> maskTarget = config.getValues("maskTarget", MaskTarget.class);
            Map<String, List<MaskTarget>> entityGroupingMap = maskTarget.stream().collect(Collectors.groupingBy(MaskTarget::getEntity));
            this.maskTargetMap = new HashMap<String, PropertyMaskTarget>();
            for (String entityName : entityGroupingMap.keySet()) {
                HashMap<String, LogMaskHandler> propertyMaskMap = new HashMap<String, LogMaskHandler>();
                PropertyMaskTarget propertyMaskTarget = new PropertyMaskTarget();
                List<MaskTarget> targetEntityList = entityGroupingMap.get(entityName);
                targetEntityList.forEach(target -> propertyMaskMap.put(target.getProperty(), target.getMaskHandler()));
                propertyMaskTarget.propertyMap = propertyMaskMap;
                propertyMaskTarget.hasWildcard = propertyMaskMap.containsKey("*");
                this.maskTargetMap.put(entityName, propertyMaskTarget);
            }
            if (this.maskTargetMap.containsKey("*")) {
                this.hasEntityWildcard = true;
                this.maskTargetMap.forEach((key, value) -> {
                    if (!key.equals("*")) {
                        PropertyMaskTarget target = this.maskTargetMap.get("*");
                        target.propertyMap.forEach((wildcardKey, wildcardValue) -> value.propertyMap.putIfAbsent((String)wildcardKey, (LogMaskHandler)wildcardValue));
                        if (target.hasWildcard) {
                            value.hasWildcard = true;
                        }
                    }
                });
            }
        }
    }

    public void log(String action, Object detail) {
        String str = null;
        if (detail != null) {
            str = detail.toString().replace("\n", "\\n").replace("\r", "\\r");
        }
        logger.info(action + "," + str);
    }

    private Object maskValue(String propertyName, Object value, PropertyMaskTarget propertyMaskTarget) {
        if (value == null || propertyMaskTarget == null) {
            return value;
        }
        Map<String, LogMaskHandler> propertyMap = propertyMaskTarget.propertyMap;
        LogMaskHandler maskHandler = null;
        maskHandler = propertyMap.get(propertyName);
        if (maskHandler == null && propertyMaskTarget.hasWildcard) {
            maskHandler = propertyMap.get("*");
        }
        if (maskHandler == null) {
            return value;
        }
        return maskHandler.mask(value.toString());
    }

    private void cutAppend(StringBuilder sb, Object target) {
        if (target == null) {
            sb.append(target);
        } else {
            String s = target.toString();
            if (this.logCompact) {
                if (s.length() > this.textMaxLength) {
                    s = s.substring(0, this.textMaxLength);
                    sb.append(s);
                    sb.append("...");
                }
            } else {
                sb.append(s);
            }
        }
    }

    private StringBuilder toLogFormat(Entity entity, List<PropertyHandler> logProps) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"definitionName\":\"").append(entity.getDefinitionName()).append("\"");
        sb.append(",\"oid\":\"").append(entity.getOid()).append("\"");
        if (logProps != null) {
            PropertyMaskTarget propertyMaskTarget = null;
            if (this.maskTargetMap != null && (propertyMaskTarget = this.maskTargetMap.get(entity.getDefinitionName())) == null && this.hasEntityWildcard) {
                propertyMaskTarget = this.maskTargetMap.get("*");
            }
            for (PropertyHandler key : logProps) {
                Object val;
                sb.append(",");
                sb.append("\"").append(key.getName()).append("\":");
                PropertyType pt = null;
                if (key instanceof PrimitivePropertyHandler) {
                    pt = ((PrimitivePropertyHandler)key).getMetaData().getType();
                }
                if ((val = entity.getValue(key.getName())) instanceof Object[]) {
                    Object[] valArray = (Object[])val;
                    sb.append("[");
                    for (int i = 0; i < valArray.length; ++i) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        if (valArray[i] instanceof GenericEntity) {
                            sb.append("{\"oid\":\"").append(((GenericEntity)valArray[i]).getOid()).append("\",\"name\":\"");
                            this.cutAppend(sb, this.maskValue(key.getName(), ((GenericEntity)valArray[i]).getName(), propertyMaskTarget));
                            sb.append("\"}");
                            continue;
                        }
                        Object toLogVal = pt != null ? pt.formatToLog(valArray[i]) : valArray[i];
                        if (toLogVal instanceof String) {
                            sb.append("\"");
                            this.cutAppend(sb, this.maskValue(key.getName(), toLogVal, propertyMaskTarget));
                            sb.append("\"");
                            continue;
                        }
                        sb.append(this.maskValue(key.getName(), toLogVal, propertyMaskTarget));
                    }
                    sb.append("]");
                    continue;
                }
                if (val instanceof GenericEntity) {
                    sb.append("{\"oid\":\"").append(((GenericEntity)val).getOid()).append("\",\"name\":\"");
                    this.cutAppend(sb, this.maskValue(key.getName(), ((GenericEntity)val).getName(), propertyMaskTarget));
                    sb.append("\"}");
                    continue;
                }
                if (pt != null) {
                    val = pt.formatToLog(val);
                }
                if (val instanceof String) {
                    sb.append("\"");
                    this.cutAppend(sb, this.maskValue(key.getName(), val, propertyMaskTarget));
                    sb.append("\"");
                    continue;
                }
                sb.append(this.maskValue(key.getName(), val, propertyMaskTarget));
            }
        }
        sb.append("}");
        return sb;
    }

    @Override
    public void logInsert(Entity entity) {
        EntityHandler eh = ServiceRegistry.getRegistry().getService(EntityService.class).getRuntimeByName(entity.getDefinitionName());
        if (eh != null) {
            this.log("create", this.toLogFormat(entity, eh.getPropertyList(EntityContext.getCurrentContext())));
        }
    }

    @Override
    public void logDelete(Entity entity, DeleteOption option) {
        String oid = entity.getOid();
        String defName = entity.getDefinitionName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"definitionName\":\"").append(defName).append("\"");
        sb.append(",\"oid\":\"").append(oid).append("\"");
        if (option.getTargetVersion() == DeleteTargetVersion.SPECIFIC) {
            sb.append(",\"version\":").append(entity.getVersion());
        }
        sb.append("}");
        this.log("delete", sb);
    }

    @Override
    public void logDeleteAll(DeleteCondition cond) {
        this.log("deleteAll", cond);
    }

    @Override
    public boolean isLogBeforeEntity(String definitionName) {
        return false;
    }

    @Override
    public void logUpdate(Entity beforeEntity, Entity entity, UpdateOption option) {
        EntityHandler eh = ServiceRegistry.getRegistry().getService(EntityService.class).getRuntimeByName(entity.getDefinitionName());
        if (eh != null) {
            ArrayList<PropertyHandler> props = new ArrayList<PropertyHandler>();
            if (option.getUpdateProperties() != null) {
                EntityContext ec = EntityContext.getCurrentContext();
                for (String up : option.getUpdateProperties()) {
                    if ("updateBy".equals(up)) continue;
                    props.add(eh.getProperty(up, ec));
                }
            }
            StringBuilder sb = this.toLogFormat(entity, props);
            this.log("update", sb);
        }
    }

    @Override
    public void logUpdateAll(UpdateCondition cond) {
        this.log("updateAll", cond);
    }

    @Override
    public void logPurge(Long rbid) {
        this.log("purge", "{\"recycleBinId\":" + rbid + "}");
    }

    @Override
    public void logRestore(String oid, String defName, Long rbid) {
        this.log("restore", "{\"definitionName\":\"" + defName + "\",\"oid\":\"" + oid + "\",\"recycleBinId\":" + rbid + "}");
    }

    @Override
    public void logBulkUpdate(String defName) {
        this.log("bulkUpdate", defName);
    }

    @Override
    public void logQuery(Query query, boolean isCount) {
        if (this.logQuery) {
            if (isCount) {
                this.log("countQuery", query);
            } else {
                this.log("query", query);
            }
        }
    }

    private class PropertyMaskTarget {
        boolean hasWildcard;
        Map<String, LogMaskHandler> propertyMap;

        private PropertyMaskTarget() {
        }
    }
}

