/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.From;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.ExpressionType;

class DefNameCollector
extends QueryVisitorSupport {
    private EntityContext ec;
    private EntityHandler eh;
    private List<String> defNames = new ArrayList<String>();
    private DefNameCollector parent;

    DefNameCollector(EntityContext ec) {
        this.ec = ec;
    }

    public String[] getDefNames() {
        return this.defNames.toArray(new String[this.defNames.size()]);
    }

    @Override
    public boolean visit(Query query) {
        From from = query.getFrom();
        if (from == null || from.getEntityName() == null) {
            return false;
        }
        this.eh = this.ec.getHandlerByName(from.getEntityName());
        if (this.eh == null) {
            return false;
        }
        if (!this.defNames.contains(from.getEntityName())) {
            this.defNames.add(from.getEntityName());
        }
        return super.visit(query);
    }

    @Override
    public boolean visit(EntityField entityField) {
        if (entityField.getPropertyName() != null) {
            PropertyType pt;
            PropertyHandler ph;
            EntityHandler refEH;
            int dotIndex;
            DefNameCollector target = this;
            String targetPropName = entityField.getPropertyName();
            int i = 0;
            while (targetPropName.charAt(i) == '.') {
                if (this.parent == null) {
                    return false;
                }
                target = this.parent;
                ++i;
            }
            if (i > 0) {
                targetPropName = entityField.getPropertyName().substring(i);
            }
            if ((dotIndex = targetPropName.lastIndexOf(46)) > 0 && !this.defNames.contains((refEH = ((ReferencePropertyHandler)(ph = (ReferencePropertyHandler)target.eh.getPropertyCascade(targetPropName.substring(0, dotIndex), this.ec))).getReferenceEntityHandler(this.ec)).getMetaData().getName())) {
                this.defNames.add(refEH.getMetaData().getName());
            }
            if ((ph = target.eh.getPropertyCascade(targetPropName, this.ec)) instanceof ReferencePropertyHandler) {
                refEH = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(this.ec);
                if (!this.defNames.contains(refEH.getMetaData().getName())) {
                    this.defNames.add(refEH.getMetaData().getName());
                }
            } else if (ph instanceof PrimitivePropertyHandler && (pt = ((MetaPrimitiveProperty)ph.getMetaData()).getType()) instanceof ExpressionType) {
                ValueExpression exp = ((ExpressionType)pt).translate(new EntityField(targetPropName));
                exp.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SubQuery subQuery) {
        DefNameCollector sub = new DefNameCollector(this.ec);
        sub.parent = this;
        Query subq = subQuery.getQuery();
        subq.accept(sub);
        if (subQuery.getOn() != null) {
            subQuery.getOn().accept(sub);
        }
        for (String subDefName : sub.defNames) {
            if (this.defNames.contains(subDefName)) continue;
            this.defNames.add(subDefName);
        }
        return false;
    }
}

