/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityInvocation;
import org.iplass.mtp.entity.interceptor.EntityLockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUnlockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.cache.DefNameCollector;
import org.iplass.mtp.impl.entity.cache.QueryCache;
import org.iplass.mtp.impl.entity.cache.QueryCacheKey;
import org.iplass.mtp.impl.entity.cache.TransactionLocalQueryCacheInterceptor;
import org.iplass.mtp.impl.entity.interceptor.EntityInvocationImpl;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryCacheInterceptor
extends EntityInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(TransactionLocalQueryCacheInterceptor.class);
    private CacheService cacheService = ServiceRegistry.getRegistry().getService(CacheService.class);

    QueryCacheInterceptor() {
    }

    private CacheStore getCache(boolean withCreate, CacheHint.CacheScope scope) {
        switch (scope) {
            case GLOBAL_KEEP: 
            case GLOBAL_RELOAD: {
                return this.cacheService.getCache("mtp.entity.keepQueryCache/" + ExecuteContext.getCurrentContext().getClientTenantId(), withCreate);
            }
        }
        return this.cacheService.getCache("mtp.entity.queryCache/" + ExecuteContext.getCurrentContext().getClientTenantId(), withCreate);
    }

    private void notifyUpdate(EntityInvocation<?> invocation) {
        EntityHandler eh = ((EntityInvocationImpl)invocation).getEntityHandler();
        if (eh.getMetaData().isQueryCache()) {
            CacheStore cache = this.getCache(true, CacheHint.CacheScope.GLOBAL);
            cache.removeByIndex(0, eh.getMetaData().getName());
        }
    }

    @Override
    public String insert(EntityInsertInvocation invocation) {
        String ret = (String)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        invocation.proceed();
        this.notifyUpdate(invocation);
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        invocation.proceed();
        this.notifyUpdate(invocation);
    }

    private CacheHint hasCacheHintAndEnableCache(Query q, EntityInvocation<?> inv) {
        HintComment hc;
        EntityHandler primaryEh = ((EntityInvocationImpl)inv).getEntityHandler();
        if (primaryEh != null && primaryEh.getMetaData().isQueryCache() && q.getSelect() != null && q.getSelect().getHintComment() != null && (hc = q.getSelect().getHintComment()).getHintList() != null) {
            for (Hint h : hc.getHintList()) {
                CacheHint.CacheScope cs;
                if (!(h instanceof CacheHint) || (cs = ((CacheHint)h).getScope()) != CacheHint.CacheScope.GLOBAL && cs != CacheHint.CacheScope.GLOBAL_KEEP && cs != CacheHint.CacheScope.GLOBAL_RELOAD) continue;
                return (CacheHint)h;
            }
        }
        return null;
    }

    private boolean isEnableCache(String[] defNameList, EntityContext ec) {
        if (defNameList == null || defNameList.length == 0) {
            return false;
        }
        for (String defName : defNameList) {
            EntityHandler eh = ec.getHandlerByName(defName);
            if (eh == null) {
                return false;
            }
            if (eh.getMetaData().isQueryCache()) continue;
            return false;
        }
        return true;
    }

    private String[] getUsedEntityDefs(Query q, EntityContext ec) {
        DefNameCollector collector = new DefNameCollector(ec);
        q.accept(collector);
        return collector.getDefNames();
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        if (invocation.getSearchOption().getResultMode() == SearchResult.ResultMode.STREAM) {
            invocation.proceed();
        } else {
            String[] usedEntityDefs;
            Query q = invocation.getQuery();
            CacheHint hint = this.hasCacheHintAndEnableCache(q, invocation);
            if (hint != null) {
                EntityContext ec = EntityContext.getCurrentContext();
                String[] ueds = this.getUsedEntityDefs(q, ec);
                if (this.isEnableCache(ueds, ec)) {
                    usedEntityDefs = ueds;
                } else {
                    usedEntityDefs = null;
                    logger.warn("Cant cache query, because query references non queryCache-able Entity. eql:" + q);
                }
            } else {
                usedEntityDefs = null;
            }
            if (hint != null && usedEntityDefs != null) {
                QueryCacheKey key;
                Predicate<?> callback = invocation.getPredicate();
                CacheStore store = this.getCache(true, hint.getScope());
                CacheEntry ce = store.get(key = new QueryCacheKey(q, invocation.getSearchOption().isReturnStructuredEntity(), false));
                if (this.isInvalidQueryCache(invocation, ce)) {
                    if (hint.getScope() == CacheHint.CacheScope.GLOBAL_RELOAD) {
                        ce = store.computeIfAbsentWithAutoReload(key, (k, v) -> {
                            if (AuthContext.getCurrentContext().isPrivileged()) {
                                return this.reloadQueryCache(k);
                            }
                            return AuthContext.doPrivileged(() -> this.reloadQueryCache(k));
                        });
                        store.remove(new QueryCacheKey(q, invocation.getSearchOption().isReturnStructuredEntity(), true));
                    } else {
                        ce = store.compute(key, (k, v) -> this.loadQueryCacheIfInvalid(invocation, q, hint, usedEntityDefs, (CacheEntry)v));
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace("Result list from global cache:" + q);
                }
                ((QueryCache)ce.getValue()).iterate(callback, q, invocation.getType(), ((EntityInvocationImpl)((Object)invocation)).getEntityHandler());
            } else {
                invocation.proceed();
            }
        }
    }

    private CacheEntry reloadQueryCache(Object k) {
        Query reloadQuery = ((QueryCacheKey)k).query.copy();
        HintComment hc = reloadQuery.getSelect().getHintComment();
        CacheHint ch = null;
        for (Hint h2 : hc.getHintList()) {
            if (!(h2 instanceof CacheHint)) continue;
            ch = (CacheHint)h2;
            break;
        }
        hc.getHintList().removeIf(h -> h instanceof CacheHint);
        reloadQuery.localized(false);
        SearchOption so = new SearchOption();
        so.setNotifyListeners(false);
        so.setReturnStructuredEntity(((QueryCacheKey)k).returnStructuredEntity);
        EntityManager em = ManagerLocator.manager(EntityManager.class);
        ArrayList list = new ArrayList();
        em.search(reloadQuery, so, row -> {
            list.add(row);
            return true;
        });
        QueryCache qc = new QueryCache(list.size(), list, InvocationType.SEARCH, -1);
        CacheEntry newCe = new CacheEntry(k, (Object)qc, null);
        newCe.setTimeToLive(TimeUnit.SECONDS.toMillis(ch.getTTL()));
        return newCe;
    }

    private CacheEntry loadQueryCacheIfInvalid(EntityQueryInvocation invocation, Query q, CacheHint hint, String[] usedEntityDefs, CacheEntry v) {
        if (this.isInvalidQueryCache(invocation, v)) {
            ArrayList list = new ArrayList();
            invocation.setPredicate(dataModel -> {
                list.add(dataModel);
                return true;
            });
            invocation.proceed();
            QueryCache qc = new QueryCache(list.size(), list, invocation.getType(), hint.getTTL());
            CacheEntry newCe = new CacheEntry((Object)new QueryCacheKey(q.copy(), invocation.getSearchOption().isReturnStructuredEntity(), false), (Object)qc, new Object[]{usedEntityDefs});
            if (hint.getTTL() > 0) {
                newCe.setTimeToLive(TimeUnit.SECONDS.toMillis(hint.getTTL()));
            }
            return newCe;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Result list from global cache:" + q);
        }
        return v;
    }

    private boolean isInvalidQueryCache(EntityQueryInvocation invocation, CacheEntry ce) {
        return ce == null || ce.getValue() == null || !((QueryCache)ce.getValue()).canIterate(invocation.getType()) || ((QueryCache)ce.getValue()).eol();
    }

    private boolean isInvalidCountCache(CacheEntry ce) {
        return ce == null || ce.getValue() == null || ((QueryCache)ce.getValue()).getCount() == null || ((QueryCache)ce.getValue()).eol();
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        String[] usedEntityDefs;
        Query q = invocation.getQuery();
        CacheHint hint = this.hasCacheHintAndEnableCache(q, invocation);
        if (hint != null) {
            EntityContext ec = EntityContext.getCurrentContext();
            String[] ueds = this.getUsedEntityDefs(q, ec);
            if (this.isEnableCache(ueds, ec)) {
                usedEntityDefs = ueds;
            } else {
                usedEntityDefs = null;
                logger.warn("Cant cache query, because query references non queryCache-able Entity. eql:" + q);
            }
        } else {
            usedEntityDefs = null;
        }
        if (hint != null && usedEntityDefs != null) {
            QueryCacheKey key;
            CacheStore store = this.getCache(true, hint.getScope());
            CacheEntry ce = store.get(key = new QueryCacheKey(q, false, false));
            if (ce == null && hint.getScope() == CacheHint.CacheScope.GLOBAL_RELOAD) {
                key = new QueryCacheKey(q, false, true);
                ce = store.get(key);
            }
            if (this.isInvalidCountCache(ce)) {
                ce = hint.getScope() == CacheHint.CacheScope.GLOBAL_RELOAD ? store.computeIfAbsentWithAutoReload(key, (k, v) -> {
                    if (AuthContext.getCurrentContext().isPrivileged()) {
                        return this.reloadCountCache(k);
                    }
                    return AuthContext.doPrivileged(() -> this.reloadCountCache(k));
                }) : store.compute(key, (k, v) -> this.loadCountCacheIfInvalid(invocation, q, hint, usedEntityDefs, (CacheEntry)v));
            } else if (logger.isTraceEnabled()) {
                logger.trace("Result list from global cache:" + q);
            }
            return ((QueryCache)ce.getValue()).getCount();
        }
        return (Integer)invocation.proceed();
    }

    private CacheEntry reloadCountCache(Object k) {
        Query reloadQuery = ((QueryCacheKey)k).query.copy();
        HintComment hc = reloadQuery.getSelect().getHintComment();
        CacheHint ch = null;
        for (Hint h2 : hc.getHintList()) {
            if (!(h2 instanceof CacheHint)) continue;
            ch = (CacheHint)h2;
            break;
        }
        hc.getHintList().removeIf(h -> h instanceof CacheHint);
        reloadQuery.localized(false);
        EntityManager em = ManagerLocator.manager(EntityManager.class);
        int count = em.count(reloadQuery);
        QueryCache qc = new QueryCache(count, null, InvocationType.COUNT, -1);
        CacheEntry newCe = new CacheEntry(k, (Object)qc, null);
        newCe.setTimeToLive(TimeUnit.SECONDS.toMillis(ch.getTTL()));
        return newCe;
    }

    private CacheEntry loadCountCacheIfInvalid(EntityCountInvocation invocation, Query q, CacheHint hint, String[] usedEntityDefs, CacheEntry v) {
        if (this.isInvalidCountCache(v)) {
            int ret = (Integer)invocation.proceed();
            QueryCache qc = new QueryCache(ret, null, invocation.getType(), hint.getTTL());
            CacheEntry newCe = new CacheEntry((Object)new QueryCacheKey(q.copy(), false, false), (Object)qc, new Object[]{usedEntityDefs});
            if (hint.getTTL() > 0) {
                newCe.setTimeToLive(TimeUnit.SECONDS.toMillis(hint.getTTL()));
            }
            return newCe;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Result list from global cache:" + q);
        }
        return v;
    }

    @Override
    public int updateAll(EntityUpdateAllInvocation invocation) {
        int ret = (Integer)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }

    @Override
    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        invocation.proceed();
        this.notifyUpdate(invocation);
    }

    @Override
    public int deleteAll(EntityDeleteAllInvocation invocation) {
        int ret = (Integer)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        invocation.proceed();
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        Entity ret = (Entity)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }

    @Override
    public boolean lockByUser(EntityLockByUserInvocation invocation) {
        boolean ret = (Boolean)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }

    @Override
    public boolean unlockByUser(EntityUnlockByUserInvocation invocation) {
        boolean ret = (Boolean)invocation.proceed();
        this.notifyUpdate(invocation);
        return ret;
    }
}

