/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityInvocation;
import org.iplass.mtp.entity.interceptor.EntityLoadInvocation;
import org.iplass.mtp.entity.interceptor.EntityLockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUnlockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.builtin.NullCacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.auth.EntityQueryAuthContextHolder;
import org.iplass.mtp.impl.entity.cache.TransactionLocalQueryCacheInterceptor;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionLocalLoadCacheInterceptor
extends EntityInterceptorAdapter {
    private static final NullCacheStore NULL_CACHE = new NullCacheStore("mtp.entity.transactionLocalCache", null);
    private static Logger logger = LoggerFactory.getLogger(TransactionLocalLoadCacheInterceptor.class);
    private TransactionLocalQueryCacheInterceptor transactionLocalQueryCacheInterceptor = new TransactionLocalQueryCacheInterceptor();

    TransactionLocalLoadCacheInterceptor() {
    }

    @Override
    public String insert(EntityInsertInvocation invocation) {
        String res = this.transactionLocalQueryCacheInterceptor.insert(invocation);
        CacheStore cache = this.getCache();
        cache.remove(this.crateCacheKey(invocation, invocation.getEntity().getOid(), invocation.getEntity().getVersion()));
        if (invocation.getEntity().getVersion() != null) {
            cache.remove(this.crateCacheKey(invocation, invocation.getEntity().getOid(), null));
        }
        return res;
    }

    private boolean isNameUpdate(EntityUpdateInvocation invocation) {
        if (invocation.getUpdateOption().getUpdateProperties().contains("name")) {
            return true;
        }
        String nameProperty = invocation.getEntityDefinition().getNamePropertyName();
        return nameProperty != null && invocation.getUpdateOption().getUpdateProperties().contains(nameProperty);
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        this.transactionLocalQueryCacheInterceptor.update(invocation);
        CacheStore cache = this.getCache();
        CacheKey updateKey = this.crateCacheKey(invocation, invocation.getEntity().getOid(), invocation.getEntity().getVersion());
        cache.remove(updateKey);
        if (invocation.getEntity().getVersion() != null) {
            cache.remove(this.crateCacheKey(invocation, invocation.getEntity().getOid(), null));
        }
        if (this.isNameUpdate(invocation)) {
            ArrayList<CacheKey> keyList = new ArrayList<CacheKey>();
            for (Object o : cache.keySet()) {
                CacheKey key = (CacheKey)o;
                CacheEntry val = cache.get(key);
                EntityCacheEntry ce = null;
                if (val != null) {
                    ce = (EntityCacheEntry)val.getValue();
                }
                if (ce == null || !ce.isRef(updateKey)) continue;
                keyList.add(key);
            }
            if (keyList.size() > 0) {
                for (CacheKey key : keyList) {
                    cache.remove(key);
                }
            }
        }
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        this.transactionLocalQueryCacheInterceptor.delete(invocation);
        CacheStore cache = this.getCache();
        cache.remove(this.crateCacheKey(invocation, invocation.getEntity().getOid(), invocation.getEntity().getVersion()));
        if (invocation.getEntity().getVersion() != null) {
            cache.remove(this.crateCacheKey(invocation, invocation.getEntity().getOid(), null));
        }
    }

    @Override
    public boolean lockByUser(EntityLockByUserInvocation invocation) {
        boolean res = this.transactionLocalQueryCacheInterceptor.lockByUser(invocation);
        if (res) {
            CacheStore cache = this.getCache();
            ArrayList<CacheKey> keyList = new ArrayList<CacheKey>();
            for (Object o : cache.keySet()) {
                CacheKey key = (CacheKey)o;
                if (key.getTenantId() != ExecuteContext.getCurrentContext().getClientTenantId() || !key.getDefitionName().equals(invocation.getEntityDefinition().getName()) || !key.getOid().equals(invocation.getOid())) continue;
                keyList.add(key);
            }
            if (keyList.size() > 0) {
                for (CacheKey key : keyList) {
                    cache.remove(key);
                }
            }
        }
        return res;
    }

    @Override
    public boolean unlockByUser(EntityUnlockByUserInvocation invocation) {
        boolean res = this.transactionLocalQueryCacheInterceptor.unlockByUser(invocation);
        if (res) {
            CacheStore cache = this.getCache();
            ArrayList<CacheKey> keyList = new ArrayList<CacheKey>();
            for (Object o : cache.keySet()) {
                CacheKey key = (CacheKey)o;
                if (key.getTenantId() != ExecuteContext.getCurrentContext().getClientTenantId() || !key.getDefitionName().equals(invocation.getEntityDefinition().getName()) || !key.getOid().equals(invocation.getOid())) continue;
                keyList.add(key);
            }
            if (keyList.size() > 0) {
                for (CacheKey key : keyList) {
                    cache.remove(key);
                }
            }
        }
        return res;
    }

    @Override
    public Entity load(EntityLoadInvocation invocation) {
        GenericEntity entity;
        Entity e;
        if (invocation.getLoadOption() != null && invocation.getLoadOption().isVersioned()) {
            return super.load(invocation);
        }
        EntityHandler eh = ((EntityLoadInvocationImpl)invocation).getEntityHandler();
        CacheStore cache = this.getCache();
        CacheKey key = this.crateCacheKey(invocation, invocation.getOid(), invocation.getVersion());
        CacheEntry val = cache.get(key);
        EntityCacheEntry ce = null;
        EntityPermission.Action entityPermissionAction = EntityQueryAuthContextHolder.getContext().getQueryAction();
        AuthContextHolder authContext = AuthContextHolder.getAuthContext();
        if (val != null) {
            EntityCacheEntry ceForCheck = (EntityCacheEntry)val.getValue();
            if (ceForCheck.authContext != authContext || ceForCheck.entityPermissionAction != entityPermissionAction) {
                cache.remove(key);
                val = null;
            }
        }
        if (val != null) {
            ce = (EntityCacheEntry)val.getValue();
            if (ce.entity == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("hit entity cache null:definition=" + invocation.getEntityDefinition().getName() + ", oid=" + invocation.getOid());
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("hit entity cache:definition=" + invocation.getEntityDefinition().getName() + ", oid=" + invocation.getOid());
                }
                if (invocation.withLock() && !ce.withLock) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("lock needed, so load entire store:definition=" + invocation.getEntityDefinition().getName() + ", oid=" + invocation.getOid());
                    }
                    ce = (e = (Entity)invocation.proceed()) == null ? this.nullEntry(entityPermissionAction, authContext) : this.createEntityCacheEntry(e, invocation, null, entityPermissionAction, authContext);
                    this.putToCache(cache, key, ce, eh);
                } else if (ce.needLoad(invocation.getLoadOption(), invocation.getEntityDefinition())) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("additional refProperty needed, so load entire store:definition=" + invocation.getEntityDefinition().getName() + ", oid=" + invocation.getOid());
                    }
                    ce = (e = (Entity)invocation.proceed()) == null ? this.nullEntry(entityPermissionAction, authContext) : this.createEntityCacheEntry(e, invocation, ce, entityPermissionAction, authContext);
                    this.putToCache(cache, key, ce, eh);
                }
            }
        } else {
            e = (Entity)invocation.proceed();
            if (e == null) {
                ce = this.nullEntry(entityPermissionAction, authContext);
                return null;
            }
            ce = this.createEntityCacheEntry(e, invocation, null, entityPermissionAction, authContext);
            this.putToCache(cache, key, ce, eh);
        }
        if ((entity = (GenericEntity)ce.getEntity()) == null) {
            return null;
        }
        GenericEntity toReturn = entity.deepCopy();
        return toReturn;
    }

    private void putToCache(CacheStore cache, CacheKey key, EntityCacheEntry ce, EntityHandler eh) {
        cache.put(new CacheEntry((Object)key, (Object)ce, new Object[0]), true);
        if (!eh.isVersioned()) {
            CacheKey noVersionKey = new CacheKey(key.getTenantId(), key.getDefitionName(), key.getOid(), null);
            cache.put(new CacheEntry((Object)noVersionKey, (Object)ce, new Object[0]), true);
        }
    }

    private EntityCacheEntry nullEntry(EntityPermission.Action entityPermissionAction, AuthContextHolder authContext) {
        return new EntityCacheEntry(null, true, null, false, null, entityPermissionAction, authContext);
    }

    private EntityCacheEntry createEntityCacheEntry(Entity e, EntityLoadInvocation invocation, EntityCacheEntry prev, EntityPermission.Action entityPermissionAction, AuthContextHolder authContext) {
        LoadOption option = invocation.getLoadOption();
        boolean all = false;
        HashSet<Object> loadRefNames = null;
        EntityDefinition def = invocation.getEntityDefinition();
        HashSet<String> defRefNames = new HashSet<String>();
        if (option == null || option.getLoadReferences() == null && option.isWithReference() && option.isWithMappedByReference()) {
            all = true;
        } else {
            loadRefNames = option.getLoadReferences() != null ? new HashSet<String>(option.getLoadReferences()) : new HashSet();
            for (PropertyDefinition pd : def.getPropertyList()) {
                if (!(pd instanceof ReferenceProperty)) continue;
                defRefNames.add(pd.getName());
                if (option.getLoadReferences() != null || !option.isWithReference()) continue;
                if (((ReferenceProperty)pd).getMappedBy() != null) {
                    if (!option.isWithMappedByReference()) continue;
                    loadRefNames.add(pd.getName());
                    continue;
                }
                loadRefNames.add(pd.getName());
            }
            if (defRefNames.size() == 0 || loadRefNames.containsAll(defRefNames)) {
                all = true;
            }
            if (!all && prev != null && e.getUpdateDate() != null && e.getUpdateDate().equals(prev.getEntity().getUpdateDate())) {
                for (PropertyDefinition pd : def.getPropertyList()) {
                    if (!(pd instanceof ReferenceProperty) || loadRefNames.contains(pd.getName())) continue;
                    e.setValue(pd.getName(), prev.getEntity().getValue(pd.getName()));
                }
                loadRefNames.addAll(prev.refNames);
                if (loadRefNames.containsAll(defRefNames)) {
                    all = true;
                }
            }
        }
        return new EntityCacheEntry(e, all, loadRefNames, invocation.withLock(), def, entityPermissionAction, authContext);
    }

    @Override
    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        this.transactionLocalQueryCacheInterceptor.bulkUpdate(invocation);
        this.getCache().removeAll();
    }

    @Override
    public int updateAll(EntityUpdateAllInvocation invocation) {
        Integer res = this.transactionLocalQueryCacheInterceptor.updateAll(invocation);
        this.getCache().removeAll();
        return res;
    }

    @Override
    public int deleteAll(EntityDeleteAllInvocation invocation) {
        Integer res = this.transactionLocalQueryCacheInterceptor.deleteAll(invocation);
        this.getCache().removeAll();
        return res;
    }

    private CacheKey crateCacheKey(EntityInvocation<?> invocation, String oid, Long version) {
        return new CacheKey(ExecuteContext.getCurrentContext().getClientTenantId(), invocation.getEntityDefinition().getName(), oid, version);
    }

    private CacheStore getCache() {
        Transaction t = ManagerLocator.getInstance().getManager(TransactionManager.class).currentTransaction();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
            CacheStore cache = (CacheStore)t.getAttribute("mtp.entity.transactionLocalCache");
            if (cache == null) {
                cache = ServiceRegistry.getRegistry().getService(CacheService.class).createLocalCache("mtp.entity.transactionLocalCache");
                t.setAttribute("mtp.entity.transactionLocalCache", cache);
            }
            return cache;
        }
        return NULL_CACHE;
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        this.transactionLocalQueryCacheInterceptor.query(invocation);
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        return this.transactionLocalQueryCacheInterceptor.count(invocation);
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        this.transactionLocalQueryCacheInterceptor.purge(invocation);
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        return this.transactionLocalQueryCacheInterceptor.restore(invocation);
    }

    private static class CacheKey {
        private int tenantId;
        private String defitionName;
        private String oid;
        private Long version;

        private CacheKey(int tenantId, String defitionName, String oid, Long version) {
            this.tenantId = tenantId;
            this.defitionName = defitionName;
            this.oid = oid;
            this.version = version;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public String getDefitionName() {
            return this.defitionName;
        }

        public String getOid() {
            return this.oid;
        }

        public Long getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defitionName == null ? 0 : this.defitionName.hashCode());
            result = 31 * result + (this.oid == null ? 0 : this.oid.hashCode());
            result = 31 * result + this.tenantId;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.defitionName == null ? other.defitionName != null : !this.defitionName.equals(other.defitionName)) {
                return false;
            }
            if (this.oid == null ? other.oid != null : !this.oid.equals(other.oid)) {
                return false;
            }
            if (this.tenantId != other.tenantId) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    private static class EntityCacheEntry {
        final Entity entity;
        final boolean all;
        final HashSet<String> refNames;
        final boolean withLock;
        final List<Entity> refEntity;
        final EntityPermission.Action entityPermissionAction;
        final AuthContextHolder authContext;

        private EntityCacheEntry(Entity entity, boolean all, HashSet<String> refNames, boolean withLock, EntityDefinition ed, EntityPermission.Action entityPermissionAction, AuthContextHolder authContext) {
            this.entity = entity;
            this.all = all;
            this.refNames = refNames;
            this.withLock = withLock;
            ArrayList<Entity> newRefEntity = null;
            if (ed != null) {
                for (PropertyDefinition pd : ed.getPropertyList()) {
                    Object o;
                    if (!(pd instanceof ReferenceProperty) || (o = entity.getValue(pd.getName())) == null) continue;
                    if (newRefEntity == null) {
                        newRefEntity = new ArrayList<Entity>();
                    }
                    if (o instanceof Entity) {
                        newRefEntity.add((Entity)o);
                        continue;
                    }
                    if (!(o instanceof Entity[])) continue;
                    for (Entity e : (Entity[])o) {
                        newRefEntity.add(e);
                    }
                }
            }
            this.refEntity = newRefEntity;
            this.entityPermissionAction = entityPermissionAction;
            this.authContext = authContext;
        }

        public boolean isRef(CacheKey updateKey) {
            if (this.refEntity != null) {
                for (Entity e : this.refEntity) {
                    if (!updateKey.getDefitionName().equals(e.getDefinitionName()) || !updateKey.getOid().equals(e.getOid())) continue;
                    return true;
                }
            }
            return false;
        }

        boolean needLoad(LoadOption option, EntityDefinition def) {
            if (this.all) {
                return false;
            }
            if (option != null && option.getLoadReferences() != null) {
                if (this.refNames != null && this.refNames.containsAll(option.getLoadReferences())) {
                    return false;
                }
            } else {
                ArrayList<String> refList = new ArrayList<String>();
                for (PropertyDefinition pd : def.getPropertyList()) {
                    if (!(pd instanceof ReferenceProperty)) continue;
                    if (option == null) {
                        refList.add(pd.getName());
                        continue;
                    }
                    if (!option.isWithReference()) continue;
                    if (((ReferenceProperty)pd).getMappedBy() != null) {
                        if (!option.isWithMappedByReference()) continue;
                        refList.add(pd.getName());
                        continue;
                    }
                    refList.add(pd.getName());
                }
                if (refList.size() == 0) {
                    return false;
                }
                if (this.refNames != null && this.refNames.containsAll(refList)) {
                    return false;
                }
            }
            return true;
        }

        Entity getEntity() {
            return this.entity;
        }
    }
}

