/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityLockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUnlockByUserInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.cache.DefNameCollector;
import org.iplass.mtp.impl.entity.cache.QueryCache;
import org.iplass.mtp.impl.entity.cache.QueryCacheInterceptor;
import org.iplass.mtp.impl.entity.cache.QueryCacheKey;
import org.iplass.mtp.impl.entity.interceptor.EntityInvocationImpl;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionLocalQueryCacheInterceptor
extends EntityInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(TransactionLocalQueryCacheInterceptor.class);
    private QueryCacheInterceptor queryCacheInterceptor = new QueryCacheInterceptor();

    TransactionLocalQueryCacheInterceptor() {
    }

    private CacheStore getCache(boolean withCreate) {
        Transaction t = ManagerLocator.getInstance().getManager(TransactionManager.class).currentTransaction();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
            CacheStore cache = (CacheStore)t.getAttribute("mtp.entity.transactionLocalQueryCache");
            if (withCreate && cache == null) {
                cache = ServiceRegistry.getRegistry().getService(CacheService.class).createLocalCache("mtp.entity.transactionLocalQueryCache");
                t.setAttribute("mtp.entity.transactionLocalQueryCache", cache);
            }
            return cache;
        }
        return null;
    }

    private void notifyUpdate(String defName) {
        CacheStore cache = this.getCache(false);
        if (cache != null) {
            cache.removeByIndex(0, defName);
        }
    }

    @Override
    public String insert(EntityInsertInvocation invocation) {
        String ret = this.queryCacheInterceptor.insert(invocation);
        this.notifyUpdate(invocation.getEntity().getDefinitionName());
        return ret;
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        this.queryCacheInterceptor.update(invocation);
        this.notifyUpdate(invocation.getEntity().getDefinitionName());
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        this.queryCacheInterceptor.delete(invocation);
        this.notifyUpdate(invocation.getEntity().getDefinitionName());
    }

    private boolean hasCacheTransactionHint(Query q) {
        HintComment hc;
        if (q.getSelect() != null && q.getSelect().getHintComment() != null && (hc = q.getSelect().getHintComment()).getHintList() != null) {
            for (Hint h : hc.getHintList()) {
                if (!(h instanceof CacheHint) || ((CacheHint)h).getScope() != CacheHint.CacheScope.TRANSACTION) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getUsedEntityDefs(Query q) {
        DefNameCollector collector = new DefNameCollector(EntityContext.getCurrentContext());
        q.accept(collector);
        return collector.getDefNames();
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        if (invocation.getSearchOption().getResultMode() == SearchResult.ResultMode.STREAM) {
            this.queryCacheInterceptor.query(invocation);
        } else {
            Query q = invocation.getQuery();
            CacheStore store = null;
            if (this.hasCacheTransactionHint(q) && (store = this.getCache(true)) != null) {
                Predicate<?> callback = invocation.getPredicate();
                CacheEntry ce = store.get(new QueryCacheKey(q, invocation.getSearchOption().isReturnStructuredEntity(), false));
                if (ce == null || ce.getValue() == null || !((QueryCache)ce.getValue()).canIterate(invocation.getType())) {
                    ArrayList list = new ArrayList();
                    invocation.setPredicate(dataModel -> {
                        list.add(dataModel);
                        return true;
                    });
                    this.queryCacheInterceptor.query(invocation);
                    QueryCache qc = new QueryCache(list.size(), list, invocation.getType());
                    q = q.copy();
                    ce = new CacheEntry((Object)new QueryCacheKey(q, invocation.getSearchOption().isReturnStructuredEntity(), false), (Object)qc, new Object[]{this.getUsedEntityDefs(q)});
                    store.put(ce, true);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("Result list from transaction local cache:" + q);
                }
                ((QueryCache)ce.getValue()).iterate(callback, q, invocation.getType(), ((EntityInvocationImpl)((Object)invocation)).getEntityHandler());
            } else {
                this.queryCacheInterceptor.query(invocation);
            }
        }
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        Query q = invocation.getQuery();
        CacheStore store = null;
        if (this.hasCacheTransactionHint(q) && (store = this.getCache(true)) != null) {
            CacheEntry ce = store.get(new QueryCacheKey(q, false, false));
            if (ce == null || ce.getValue() == null || ((QueryCache)ce.getValue()).getCount() == null) {
                int ret = this.queryCacheInterceptor.count(invocation);
                QueryCache qc = new QueryCache(ret, null, invocation.getType());
                q = q.copy();
                ce = new CacheEntry((Object)new QueryCacheKey(q, false, false), (Object)qc, new Object[]{this.getUsedEntityDefs(q)});
                store.put(ce, true);
            } else if (logger.isTraceEnabled()) {
                logger.trace("Count from transaction local cache:" + q);
            }
            return ((QueryCache)ce.getValue()).getCount();
        }
        return this.queryCacheInterceptor.count(invocation);
    }

    @Override
    public int updateAll(EntityUpdateAllInvocation invocation) {
        int ret = this.queryCacheInterceptor.updateAll(invocation);
        this.notifyUpdate(invocation.getUpdateCondition().getDefinitionName());
        return ret;
    }

    @Override
    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        this.queryCacheInterceptor.bulkUpdate(invocation);
        this.notifyUpdate(invocation.getBulkUpdatable().getDefinitionName());
    }

    @Override
    public int deleteAll(EntityDeleteAllInvocation invocation) {
        int ret = this.queryCacheInterceptor.deleteAll(invocation);
        this.notifyUpdate(invocation.getDeleteCondition().getDefinitionName());
        return ret;
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        this.queryCacheInterceptor.purge(invocation);
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        Entity ret = this.queryCacheInterceptor.restore(invocation);
        this.notifyUpdate(invocation.getEntityDefinition().getName());
        return ret;
    }

    @Override
    public boolean lockByUser(EntityLockByUserInvocation invocation) {
        boolean ret = this.queryCacheInterceptor.lockByUser(invocation);
        this.notifyUpdate(invocation.getEntityDefinition().getName());
        return ret;
    }

    @Override
    public boolean unlockByUser(EntityUnlockByUserInvocation invocation) {
        boolean ret = this.queryCacheInterceptor.unlockByUser(invocation);
        this.notifyUpdate(invocation.getEntityDefinition().getName());
        return ret;
    }
}

