/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fulltextsearch;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.interceptor.EntityCountInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityRestoreInvocationImpl;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchQueryASTTransformer;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogInsertSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogTable;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public class FulltextSearchInterceptor
extends EntityInterceptorAdapter
implements ServiceInitListener<EntityService> {
    private RdbAdapter rdb;
    private FulltextSearchService fss;
    private DeleteLogInsertSql deleteLogInsertSql;

    @Override
    public void inited(EntityService service, Config config) {
        this.rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
        this.fss = ServiceRegistry.getRegistry().getService(FulltextSearchService.class);
        if (this.fss.isUseFulltextSearch()) {
            this.deleteLogInsertSql = this.rdb.getUpdateSqlCreator(DeleteLogInsertSql.class);
        }
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        if (this.fss.isUseFulltextSearch()) {
            EntityQueryInvocationImpl inv = (EntityQueryInvocationImpl)invocation;
            Query query = inv.getQuery();
            String defName = query.getFrom().getEntityName();
            FulltextSearchQueryASTTransformer t = new FulltextSearchQueryASTTransformer(defName);
            Query tQuery = (Query)query.accept(t);
            if (StringUtil.isEmpty(t.getSearchText())) {
                invocation.proceed();
                return;
            }
            inv.setQuery(tQuery);
            final Map<String, Map<String, List<String>>> highlightMap = t.getHighlightMap();
            if (invocation.getType() == InvocationType.SEARCH_ENTITY) {
                final Predicate<?> actual = invocation.getPredicate();
                Predicate<Entity> wrapper = new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        entity.setValue("highlightInfo", highlightMap.get(entity.getOid()));
                        return actual.test(entity);
                    }
                };
                invocation.setPredicate(wrapper);
            }
            invocation.proceed();
        } else {
            invocation.proceed();
        }
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        if (this.fss.isUseFulltextSearch()) {
            EntityCountInvocationImpl inv = (EntityCountInvocationImpl)invocation;
            Query query = inv.getQuery();
            String defName = query.getFrom().getEntityName();
            FulltextSearchQueryASTTransformer t = new FulltextSearchQueryASTTransformer(defName);
            Query tQuery = (Query)query.accept(t);
            if (StringUtil.isEmpty(t.getSearchText())) {
                return (Integer)invocation.proceed();
            }
            inv.setQuery(tQuery);
            return (Integer)invocation.proceed();
        }
        return (Integer)invocation.proceed();
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        if (this.fss.isUseFulltextSearch()) {
            Entity entity = null;
            EntityHandler eh = ((EntityDeleteInvocationImpl)invocation).getEntityHandler();
            eh = ((EntityDeleteInvocationImpl)invocation).getEntityHandler();
            entity = (Entity)new EntityLoadInvocationImpl(invocation.getEntity().getOid(), invocation.getEntity().getVersion(), new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed();
            invocation.proceed();
            if (eh.getMetaData().isCrawl()) {
                ExecuteContext ctx = ExecuteContext.getCurrentContext();
                final int tenantId = ctx.getClientTenantId();
                final String objDefId = eh.getMetaData().getId();
                final String objId = entity.getOid();
                final Long objVer = entity.getVersion();
                SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                    @Override
                    public Void logic() throws SQLException {
                        String sql = FulltextSearchInterceptor.this.deleteLogInsertSql.toSql(tenantId, objDefId, objId, objVer, DeleteLogTable.Status.DELETE, InternalDateUtil.getNow(), FulltextSearchInterceptor.this.rdb);
                        this.getStatement().executeUpdate(sql);
                        return null;
                    }
                };
                exec.execute(this.rdb, true);
            }
        } else {
            invocation.proceed();
        }
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        EntityHandler eh = ((EntityRestoreInvocationImpl)invocation).getEntityHandler();
        Entity entity = (Entity)invocation.proceed();
        if (this.fss.isUseFulltextSearch()) {
            ExecuteContext ctx = ExecuteContext.getCurrentContext();
            final int tenantId = ctx.getClientTenantId();
            final String objDefId = eh.getMetaData().getId();
            final String objId = entity.getOid();
            final Long objVer = entity.getVersion();
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                @Override
                public Void logic() throws SQLException {
                    String sql = FulltextSearchInterceptor.this.deleteLogInsertSql.toSql(tenantId, objDefId, objId, objVer, DeleteLogTable.Status.RESTORE, InternalDateUtil.getNow(), FulltextSearchInterceptor.this.rdb);
                    this.getStatement().executeUpdate(sql);
                    return null;
                }
            };
            exec.execute(this.rdb, true);
        }
        return entity;
    }
}

