/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fulltextsearch;

import java.sql.SQLException;
import org.iplass.mtp.impl.entity.AdditionalStoreMaintainer;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogDeleteSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogDeleteSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;

public class FulltextSearchStoreMaintainer
implements AdditionalStoreMaintainer {
    private RdbAdapter rdb;
    private CrawlLogDeleteSql crawlLogDeleteSql;
    private DeleteLogDeleteSql deleteLogDeleteSql;

    @Override
    public void inited(EntityService service, Config config) {
        this.rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
        this.crawlLogDeleteSql = this.rdb.getUpdateSqlCreator(CrawlLogDeleteSql.class);
        this.deleteLogDeleteSql = this.rdb.getUpdateSqlCreator(DeleteLogDeleteSql.class);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void clean(final int tenantId, final String defId) {
        FulltextSearchService fulltextSearchService = ServiceRegistry.getRegistry().getService(FulltextSearchService.class);
        if (fulltextSearchService.isUseFulltextSearch()) {
            new SqlExecuter<Void>(){

                @Override
                public Void logic() throws SQLException {
                    String sql1 = FulltextSearchStoreMaintainer.this.crawlLogDeleteSql.deleteByDefId(tenantId, defId, FulltextSearchStoreMaintainer.this.rdb);
                    this.getStatement().executeUpdate(sql1);
                    String sql2 = FulltextSearchStoreMaintainer.this.deleteLogDeleteSql.deleteByDefId(tenantId, defId, FulltextSearchStoreMaintainer.this.rdb);
                    this.getStatement().executeUpdate(sql2);
                    return null;
                }
            }.execute(this.rdb, true);
        }
    }

    @Override
    public void defrag(int tenantId, EntityHandler eh) {
    }
}

