/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.l10n;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.DataLocalizationStrategy;
import org.iplass.mtp.entity.definition.l10n.EachInstanceDataLocalizationStrategy;
import org.iplass.mtp.entity.definition.l10n.EachPropertyDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.l10n.MetaEachInstanceDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.l10n.MetaEachPropertyDataLocalizationStrategy;
import org.iplass.mtp.impl.metadata.MetaData;

@XmlSeeAlso(value={MetaEachInstanceDataLocalizationStrategy.class, MetaEachPropertyDataLocalizationStrategy.class})
public abstract class MetaDataLocalizationStrategy
implements MetaData {
    private static final long serialVersionUID = 4197648632656222700L;
    private List<String> languages;

    public static MetaDataLocalizationStrategy newInstance(DataLocalizationStrategy def) {
        if (def instanceof EachInstanceDataLocalizationStrategy) {
            return new MetaEachInstanceDataLocalizationStrategy();
        }
        if (def instanceof EachPropertyDataLocalizationStrategy) {
            return new MetaEachPropertyDataLocalizationStrategy();
        }
        return null;
    }

    public MetaDataLocalizationStrategy() {
    }

    public MetaDataLocalizationStrategy(List<String> languages) {
        this.languages = languages;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public abstract void applyConfig(DataLocalizationStrategy var1);

    public abstract DataLocalizationStrategy currentConfig();

    @Override
    public abstract MetaDataLocalizationStrategy copy();

    public abstract DataLocalizationStrategyRuntime createDataLocalizationStrategyRuntime(EntityHandler var1);

    protected void copyTo(MetaDataLocalizationStrategy c) {
        if (this.languages != null) {
            c.languages = new ArrayList<String>(this.languages);
        }
    }

    protected void fillFrom(DataLocalizationStrategy def) {
        this.languages = def.getLanguages() != null ? new ArrayList<String>(def.getLanguages()) : null;
    }

    protected void fillTo(DataLocalizationStrategy def) {
        if (this.languages != null) {
            def.setLanguages(new ArrayList<String>(this.languages));
        } else {
            def.setLanguages(null);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.languages == null ? 0 : this.languages.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaDataLocalizationStrategy other = (MetaDataLocalizationStrategy)obj;
        return !(this.languages == null ? other.languages != null : !this.languages.equals(other.languages));
    }

    public static abstract class DataLocalizationStrategyRuntime {
        public abstract void handleEntityForInsert(Entity var1, InsertOption var2);

        public abstract void handleEntityForUpdate(Entity var1, UpdateOption var2);

        public abstract Entity handleEntityForLoad(Entity var1);
    }
}

