/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.l10n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.DataLocalizationStrategy;
import org.iplass.mtp.entity.definition.l10n.EachPropertyDataLocalizationStrategy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.l10n.MetaDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.property.MetaProperty;

public class MetaEachPropertyDataLocalizationStrategy
extends MetaDataLocalizationStrategy {
    private static final long serialVersionUID = 7582698366671336713L;

    public MetaEachPropertyDataLocalizationStrategy() {
    }

    public MetaEachPropertyDataLocalizationStrategy(List<String> languages) {
        super(languages);
    }

    @Override
    public MetaDataLocalizationStrategy copy() {
        MetaEachPropertyDataLocalizationStrategy copy = new MetaEachPropertyDataLocalizationStrategy();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void applyConfig(DataLocalizationStrategy def) {
        this.fillFrom(def);
    }

    @Override
    public DataLocalizationStrategy currentConfig() {
        EachPropertyDataLocalizationStrategy def = new EachPropertyDataLocalizationStrategy();
        this.fillTo(def);
        return def;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime createDataLocalizationStrategyRuntime(EntityHandler eh) {
        return new EachPropertyDataLocalizationStrategyRuntime(eh);
    }

    public class EachPropertyDataLocalizationStrategyRuntime
    extends MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime {
        private Map<String, Map<String, String>> map;
        private Map<String, String> defaultMap;
        private EntityHandler eh;

        private EachPropertyDataLocalizationStrategyRuntime(EntityHandler eh) {
            this.eh = eh;
            this.map = new HashMap<String, Map<String, String>>();
            HashSet<String> propNames = new HashSet<String>();
            MetaEntity meta = eh.getMetaData();
            while (meta != null) {
                List<MetaProperty> plist = meta.getDeclaredPropertyList();
                for (MetaProperty metaProperty : plist) {
                    propNames.add(metaProperty.getName());
                }
                if (meta.getInheritedEntityMetaDataId() != null) {
                    EntityHandler superEh = EntityContext.getCurrentContext().getHandlerById(meta.getInheritedEntityMetaDataId());
                    if (superEh != null) {
                        meta = superEh.getMetaData();
                        continue;
                    }
                    meta = null;
                    continue;
                }
                meta = null;
            }
            HashSet<String> subProps = new HashSet<String>();
            if (MetaEachPropertyDataLocalizationStrategy.this.getLanguages() != null) {
                for (String string : MetaEachPropertyDataLocalizationStrategy.this.getLanguages()) {
                    String userLangPostFix = "_" + string.replace('-', '_');
                    HashMap<String, String> propMap = new HashMap<String, String>();
                    for (String pname : propNames) {
                        String lpn = pname + userLangPostFix;
                        if (propNames.contains(lpn)) {
                            propMap.put(pname, lpn);
                            subProps.add(lpn);
                            continue;
                        }
                        if (subProps.contains(pname)) continue;
                        propMap.put(pname, null);
                    }
                    this.map.put(string, propMap);
                }
            }
            for (Map.Entry entry : this.map.entrySet()) {
                Iterator it = ((Map)entry.getValue()).entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry ee = it.next();
                    if (!subProps.contains(ee.getKey())) continue;
                    it.remove();
                }
            }
            this.defaultMap = new HashMap<String, String>();
            if (MetaEachPropertyDataLocalizationStrategy.this.getLanguages() != null && MetaEachPropertyDataLocalizationStrategy.this.getLanguages().size() > 0) {
                Map<String, String> ent = this.map.values().iterator().next();
                for (String k : ent.keySet()) {
                    this.defaultMap.put(k, null);
                }
            } else {
                for (String string : propNames) {
                    this.defaultMap.put(string, null);
                }
            }
        }

        public Map<String, String> getPropMap(String userLang) {
            return this.map.getOrDefault(userLang, this.defaultMap);
        }

        @Override
        public void handleEntityForInsert(Entity e, InsertOption option) {
            String userLang = ExecuteContext.getCurrentContext().getLanguage();
            String entityNameValue = e.getName();
            Map<String, String> propMap = this.map.get(userLang);
            if (propMap != null) {
                for (Map.Entry<String, String> ft : propMap.entrySet()) {
                    Object val;
                    if (ft.getValue() == null || (val = e.getValue(ft.getKey())) == null) continue;
                    e.setValue(ft.getKey(), null);
                    e.setValue(ft.getValue(), val);
                }
            }
            e.setName(entityNameValue);
        }

        @Override
        public void handleEntityForUpdate(Entity e, UpdateOption option) {
            String userLang = ExecuteContext.getCurrentContext().getLanguage();
            Map<String, String> propMap = this.map.get(userLang);
            if (propMap != null && propMap.size() > 0) {
                ArrayList<String> ups = new ArrayList<String>();
                for (String prop : option.getUpdateProperties()) {
                    String lpn = propMap.get(prop);
                    if (lpn != null) {
                        Object val = e.getValue(prop);
                        if (val != null) {
                            e.setValue(prop, null);
                            e.setValue(lpn, val);
                        }
                        ups.add(lpn);
                        continue;
                    }
                    ups.add(prop);
                }
                option.setUpdateProperties(ups);
            }
        }

        @Override
        public Entity handleEntityForLoad(Entity e) {
            if (e == null) {
                return null;
            }
            String userLang = ExecuteContext.getCurrentContext().getLanguage();
            Map<String, String> propMap = this.map.getOrDefault(userLang, this.defaultMap);
            if (propMap != null && propMap.size() > 0) {
                Entity ret = this.eh.newInstance();
                for (Map.Entry<String, String> me : propMap.entrySet()) {
                    String lpn = me.getValue();
                    if (lpn == null) {
                        lpn = me.getKey();
                    }
                    ret.setValue(me.getKey(), e.getValue(lpn));
                }
                return ret;
            }
            return e;
        }
    }
}

