/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.l10n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.l10n.MetaEachInstanceDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.l10n.MetaEachPropertyDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

class QueryLocalizer
extends ASTTransformerSupport {
    private QueryLocalizer parent;
    private EntityHandler eh;
    private EntityContext ec;
    private Map<String, EntityHandler> refers;
    private String userLang;
    private String userLangReplace;

    QueryLocalizer(EntityHandler eh, EntityContext ec) {
        this.eh = eh;
        this.ec = ec;
        this.userLang = ExecuteContext.getCurrentContext().getLanguage();
    }

    @Override
    public ASTNode visit(EntityField entityField) {
        int unnestCount = entityField.unnestCount();
        QueryLocalizer target = this;
        for (int i = 0; i < unnestCount; ++i) {
            target = target.parent;
            if (target != null) continue;
            throw new QueryException(entityField + " specify outer query's field, but has no outer query.");
        }
        String propName = entityField.getPropertyName();
        if (unnestCount > 0) {
            propName = propName.substring(unnestCount);
        }
        String l10nPropName = null;
        int lastDot = propName.lastIndexOf(46);
        if (lastDot < 0) {
            PropertyHandler ph = target.eh.getProperty(propName, this.ec);
            if (ph != null) {
                if (ph instanceof PrimitivePropertyHandler) {
                    PropertyHandler l10nPh;
                    if (target.eh.getMetaData().getDataLocalizationStrategy() != null && target.eh.getMetaData().getDataLocalizationStrategy() instanceof MetaEachPropertyDataLocalizationStrategy && (l10nPh = target.eh.getProperty(l10nPropName = propName + "_" + this.userLangReplace(), this.ec)) == null) {
                        l10nPropName = null;
                    }
                } else {
                    EntityHandler refEh = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(this.ec);
                    target.addRefers(propName, refEh);
                }
            }
        } else {
            String propNameDirect;
            ReferencePropertyHandler ref = (ReferencePropertyHandler)target.eh.getPropertyCascade(propName.substring(0, lastDot), this.ec);
            if (ref == null) {
                throw new QueryException(entityField + " not defined.");
            }
            EntityHandler targetEh = ref.getReferenceEntityHandler(this.ec);
            PropertyHandler ph = targetEh.getProperty(propNameDirect = propName.substring(lastDot + 1, propName.length()), this.ec);
            if (ph != null) {
                if (ph instanceof PrimitivePropertyHandler) {
                    if (targetEh.getMetaData().getDataLocalizationStrategy() != null && targetEh.getMetaData().getDataLocalizationStrategy() instanceof MetaEachPropertyDataLocalizationStrategy) {
                        l10nPropName = propName + "_" + this.userLangReplace();
                        String l10nPropNameDirect = propNameDirect + "_" + this.userLangReplace();
                        PropertyHandler l10nPh = targetEh.getProperty(l10nPropNameDirect, this.ec);
                        if (l10nPh == null) {
                            l10nPropName = null;
                        }
                    }
                } else {
                    EntityHandler refEh = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(this.ec);
                    target.addRefers(propName, refEh);
                }
            }
            String refPath = propName;
            int index = lastDot;
            while (index > 0) {
                refPath = refPath.substring(0, index);
                ReferencePropertyHandler refPh = (ReferencePropertyHandler)target.eh.getPropertyCascade(refPath, this.ec);
                EntityHandler refEh = refPh.getReferenceEntityHandler(this.ec);
                target.addRefers(refPath, refEh);
                index = refPath.lastIndexOf(46);
            }
        }
        if (l10nPropName == null) {
            return new EntityField(entityField.getPropertyName());
        }
        if (unnestCount > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < unnestCount; ++i) {
                sb.append('.');
            }
            sb.append(l10nPropName);
            return new EntityField(sb.toString());
        }
        return new EntityField(l10nPropName);
    }

    private void addRefers(String refName, EntityHandler refEh) {
        if (refEh.getMetaData().getDataLocalizationStrategy() instanceof MetaEachInstanceDataLocalizationStrategy) {
            if (this.refers == null) {
                this.refers = new HashMap<String, EntityHandler>();
            }
            if (!this.refers.containsKey(refName)) {
                this.refers.put(refName, refEh);
            }
        }
    }

    private String userLangReplace() {
        if (this.userLangReplace == null) {
            this.userLangReplace = this.userLang.replace('-', '_');
        }
        return this.userLangReplace;
    }

    @Override
    public ASTNode visit(SubQuery subQuery) {
        EntityHandler subEh = this.ec.getHandlerByName(subQuery.getQuery().getFrom().getEntityName());
        QueryLocalizer subQueryLocalizer = new QueryLocalizer(subEh, this.ec);
        subQueryLocalizer.parent = this;
        Query subQ = (Query)subQuery.getQuery().accept(subQueryLocalizer);
        Condition on = null;
        if (subQuery.getOn() != null) {
            on = (Condition)subQuery.getOn().accept(subQueryLocalizer);
        }
        return new SubQuery(subQ, on);
    }

    @Override
    public ASTNode visit(Query query) {
        Query q = (Query)super.visit(query);
        if (this.eh.getMetaData().getDataLocalizationStrategy() != null && this.eh.getMetaData().getDataLocalizationStrategy() instanceof MetaEachInstanceDataLocalizationStrategy) {
            MetaEachInstanceDataLocalizationStrategy st = (MetaEachInstanceDataLocalizationStrategy)this.eh.getMetaData().getDataLocalizationStrategy();
            Condition condition = this.l10nCond(this.userLang, st, null);
            if (q.getWhere() == null || q.getWhere().getCondition() == null) {
                q.where(condition);
            } else {
                q.where(new And(q.getWhere().getCondition(), condition));
            }
        }
        if (q.getRefer() != null && q.getRefer().size() > 0) {
            for (Refer refer : q.getRefer()) {
                EntityHandler refEh = this.refers == null ? null : this.refers.remove(refer.getReferenceName().getPropertyName());
                if (refEh == null) continue;
                MetaEachInstanceDataLocalizationStrategy st = (MetaEachInstanceDataLocalizationStrategy)refEh.getMetaData().getDataLocalizationStrategy();
                Condition l10nCond = this.l10nCond(this.userLang, st, refer.getReferenceName().getPropertyName());
                if (refer.getCondition() == null) {
                    refer.setCondition(l10nCond);
                    continue;
                }
                refer.setCondition(new And(refer.getCondition(), l10nCond));
            }
        }
        if (this.refers != null && this.refers.size() > 0) {
            if (q.getRefer() == null) {
                q.setRefer(new ArrayList<Refer>());
            }
            for (Map.Entry entry : this.refers.entrySet()) {
                MetaEachInstanceDataLocalizationStrategy st = (MetaEachInstanceDataLocalizationStrategy)((EntityHandler)entry.getValue()).getMetaData().getDataLocalizationStrategy();
                Condition l10nCond = this.l10nCond(this.userLang, st, (String)entry.getKey());
                q.getRefer().add(new Refer(new EntityField((String)entry.getKey()), l10nCond));
            }
        }
        return q;
    }

    private Condition l10nCond(String userLang, MetaEachInstanceDataLocalizationStrategy st, String refPath) {
        Predicate l10nCond = null;
        l10nCond = st.getLanguages() != null && st.getLanguages().contains(userLang) ? (refPath == null ? new Equals(st.getLanguagePropertyName(), userLang) : new Equals(refPath + "." + st.getLanguagePropertyName(), userLang)) : (refPath == null ? new IsNull(st.getLanguagePropertyName()) : new IsNull(refPath + "." + st.getLanguagePropertyName()));
        return l10nCond;
    }
}

