/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.listener;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.EventType;
import org.iplass.mtp.entity.definition.listeners.SendNotificationEventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.SendNotificationType;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.webhook.DefaultWebhookResponseHandler;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.MailManager;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationManager;
import org.iplass.mtp.sms.SmsMail;
import org.iplass.mtp.sms.SmsMailManager;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webhook.Webhook;
import org.iplass.mtp.webhook.WebhookManager;
import org.iplass.mtp.webhook.WebhookResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSendNotificationEventListener
extends MetaEventListener {
    private static final long serialVersionUID = 3089787592456473699L;
    private static final Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.mail");
    public static final String TENANT_BINDING_NAME = "tenant";
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String EVENT_TYPE_BINDING_NAME = "event";
    public static final String CONTEXT_BINDING_NAME = "context";
    public static final String USER_BINDING_NAME = "user";
    public static final String DATE_BINGING_NAME = "date";
    private SendNotificationType notificationType;
    private String tmplDefName;
    private String notificationCondScript;
    private List<EventType> listenEvent;
    private boolean sendTogether;
    private List<String> destinationList;
    private boolean synchronous;
    private String responseHandler;

    public SendNotificationType getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(SendNotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public String getTmplDefName() {
        return this.tmplDefName;
    }

    public void setTmplDefName(String tmplDefName) {
        this.tmplDefName = tmplDefName;
    }

    public String getNotificationCondScript() {
        return this.notificationCondScript;
    }

    public void setNotificationCondScript(String notificationCondScript) {
        this.notificationCondScript = notificationCondScript;
    }

    public List<EventType> getListenEvent() {
        return this.listenEvent;
    }

    public void setListenEvent(List<EventType> listenEvent) {
        this.listenEvent = listenEvent;
    }

    public List<String> getDestinationList() {
        return this.destinationList;
    }

    public void setDestinationList(List<String> destinationList) {
        this.destinationList = destinationList;
    }

    public String getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(String responseHandler) {
        this.responseHandler = responseHandler;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean isSynchronous) {
        this.synchronous = isSynchronous;
    }

    public boolean isSendTogether() {
        return this.sendTogether;
    }

    public void setSendTogether(boolean isSendTogether) {
        this.sendTogether = isSendTogether;
    }

    @Override
    public MetaEventListener copy() {
        MetaSendNotificationEventListener copy = new MetaSendNotificationEventListener();
        this.copyTo(copy);
        copy.notificationType = this.notificationType;
        copy.tmplDefName = this.tmplDefName;
        copy.notificationCondScript = this.notificationCondScript;
        copy.responseHandler = this.responseHandler;
        copy.setSendTogether(this.sendTogether);
        if (this.listenEvent != null) {
            copy.listenEvent = new ArrayList<EventType>();
            copy.listenEvent.addAll(this.listenEvent);
        }
        copy.setSynchronous(this.synchronous);
        if (this.destinationList != null) {
            copy.destinationList = new ArrayList<String>(this.destinationList);
            copy.destinationList.addAll(this.destinationList);
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.listenEvent == null ? 0 : this.listenEvent.hashCode());
        result = 31 * result + (this.notificationCondScript == null ? 0 : this.notificationCondScript.hashCode());
        result = 31 * result + (this.notificationType == null ? 0 : this.notificationType.hashCode());
        result = 31 * result + (this.tmplDefName == null ? 0 : this.tmplDefName.hashCode());
        result = 31 * result + (this.sendTogether ? 1231 : 1237);
        result = 31 * result + (this.destinationList == null ? 0 : this.destinationList.hashCode());
        result = 31 * result + (this.synchronous ? 1231 : 1237);
        result = 31 * result + (this.responseHandler == null ? 0 : this.responseHandler.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaSendNotificationEventListener other = (MetaSendNotificationEventListener)obj;
        if (this.listenEvent == null ? other.listenEvent != null : !this.listenEvent.equals(other.listenEvent)) {
            return false;
        }
        if (this.notificationCondScript == null ? other.notificationCondScript != null : !this.notificationCondScript.equals(other.notificationCondScript)) {
            return false;
        }
        if (this.notificationType != other.notificationType) {
            return false;
        }
        if (this.tmplDefName == null) {
            if (other.tmplDefName != null) {
                return false;
            }
        } else {
            if (!this.tmplDefName.equals(other.tmplDefName)) {
                return false;
            }
            if (!this.synchronous == other.synchronous) {
                return false;
            }
            if (this.destinationList == null) {
                if (other.destinationList != null) {
                    return false;
                }
            } else {
                if (!this.destinationList.equals(other.destinationList)) {
                    return false;
                }
                if (this.responseHandler == null) {
                    if (other.responseHandler != null) {
                        return false;
                    }
                } else {
                    if (!this.responseHandler.equals(other.responseHandler)) {
                        return false;
                    }
                    if (!this.sendTogether == other.sendTogether) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void applyConfig(EventListenerDefinition def) {
        this.fillFrom(def);
        SendNotificationEventListenerDefinition d = (SendNotificationEventListenerDefinition)def;
        this.notificationType = d.getNotificationType();
        this.tmplDefName = d.getTmplDefName();
        this.notificationCondScript = d.getNotificationCondScript();
        this.responseHandler = d.getResponseHandler();
        this.synchronous = d.isSynchronous();
        this.sendTogether = d.isSendTogether();
        if (d.getListenEvent() != null) {
            this.listenEvent = new ArrayList<EventType>();
            this.listenEvent.addAll(d.getListenEvent());
        } else {
            this.listenEvent = null;
        }
        if (d.getDestinationList() != null) {
            this.destinationList = new ArrayList<String>();
            this.destinationList.addAll(d.getDestinationList());
        } else {
            this.destinationList = null;
        }
    }

    @Override
    public EventListenerDefinition currentConfig() {
        ArrayList<EventType> es;
        SendNotificationEventListenerDefinition d = new SendNotificationEventListenerDefinition();
        this.fillTo(d);
        d.setNotificationType(this.notificationType);
        d.setTmplDefName(this.tmplDefName);
        d.setNotificationCondScript(this.notificationCondScript);
        d.setResponseHandler(this.responseHandler);
        d.setSendTogether(this.sendTogether);
        if (this.listenEvent != null) {
            es = new ArrayList<EventType>();
            es.addAll(this.listenEvent);
            d.setListenEvent(es);
        }
        d.setSynchronous(this.synchronous);
        if (this.destinationList != null) {
            es = new ArrayList();
            es.addAll(this.destinationList);
            d.setDestinationList(es);
        }
        return d;
    }

    @Override
    public MetaEventListener.EventListenerRuntime createRuntime(MetaEntity entity) {
        if (this.notificationType == SendNotificationType.MAIL) {
            return new SendMailNotificationEventListenerHandler(entity);
        }
        if (this.notificationType == SendNotificationType.SMS) {
            return new SendSMSNotificationEventListenerHandler(entity);
        }
        if (this.notificationType == SendNotificationType.PUSH) {
            return new SendPushNotificationEventListenerHandler(entity);
        }
        if (this.notificationType == SendNotificationType.WEBHOOK) {
            return new SendWebhookNotificationEventListenerHandler(entity);
        }
        return null;
    }

    public class SendWebhookNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private WebhookManager wm;

        public SendWebhookNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.wm = ManagerLocator.getInstance().getManager(WebhookManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            List<String> processedDestinationList = this.processDestinationGroovyTemplate(bindings);
            ArrayList<Webhook> webhookList = new ArrayList<Webhook>();
            for (String endpoint : processedDestinationList) {
                WebhookResponseHandler whrh;
                Webhook webhook = this.wm.createWebhook(MetaSendNotificationEventListener.this.tmplDefName, bindings, endpoint);
                if (MetaSendNotificationEventListener.this.responseHandler == null || MetaSendNotificationEventListener.this.responseHandler.isEmpty()) {
                    whrh = new DefaultWebhookResponseHandler();
                } else {
                    try {
                        whrh = (WebhookResponseHandler)Class.forName(MetaSendNotificationEventListener.this.responseHandler).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        whrh = new DefaultWebhookResponseHandler();
                    }
                }
                webhook.setResponseHandler(whrh);
                webhookList.add(webhook);
            }
            return webhookList;
        }

        @Override
        protected void sendNotification(Object webhookList) {
            if (MetaSendNotificationEventListener.this.synchronous) {
                for (Webhook wh : (List)webhookList) {
                    this.wm.sendWebhookSync(wh);
                }
            } else {
                for (Webhook wh : (List)webhookList) {
                    this.wm.sendWebhookAsync(wh);
                }
            }
        }
    }

    public class SendPushNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private PushNotificationManager pm;

        public SendPushNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.pm = ManagerLocator.getInstance().getManager(PushNotificationManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            ArrayList<PushNotification> pushNotificationList = new ArrayList<PushNotification>();
            List<String> processedDestinationList = this.processDestinationGroovyTemplate(bindings);
            if (MetaSendNotificationEventListener.this.sendTogether) {
                PushNotification pushNotification = this.pm.createNotification(MetaSendNotificationEventListener.this.tmplDefName, bindings);
                for (String destination : processedDestinationList) {
                    pushNotification.addTo(destination);
                }
                pushNotificationList.add(pushNotification);
            } else {
                for (String destination : processedDestinationList) {
                    PushNotification pushNotification = this.pm.createNotification(MetaSendNotificationEventListener.this.tmplDefName, bindings);
                    pushNotification.addTo(destination);
                    pushNotificationList.add(pushNotification);
                }
            }
            return pushNotificationList;
        }

        @Override
        protected void sendNotification(Object mail) {
            for (PushNotification m : (List)mail) {
                this.pm.push(m);
            }
        }
    }

    public class SendSMSNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private SmsMailManager smm;

        public SendSMSNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.smm = ManagerLocator.getInstance().getManager(SmsMailManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            List<String> processedDestinationList = this.processDestinationGroovyTemplate(bindings);
            ArrayList<SmsMail> smsMailList = new ArrayList<SmsMail>();
            for (String desination : processedDestinationList) {
                SmsMail smsMail = this.smm.createMail(MetaSendNotificationEventListener.this.tmplDefName, bindings);
                smsMail.setTo(desination);
                smsMailList.add(smsMail);
            }
            return smsMailList;
        }

        @Override
        protected void sendNotification(Object mail) {
            for (SmsMail m : (List)mail) {
                this.smm.sendMail(m);
            }
        }
    }

    public class SendMailNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private MailManager mm;

        public SendMailNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.mm = ManagerLocator.getInstance().getManager(MailManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            List<String> processedDestinationList = this.processDestinationGroovyTemplate(bindings);
            ArrayList<Mail> mailList = new ArrayList<Mail>();
            if (MetaSendNotificationEventListener.this.sendTogether) {
                Mail mail = this.mm.createMail(MetaSendNotificationEventListener.this.tmplDefName, bindings);
                for (String destination : processedDestinationList) {
                    mail.addRecipientTo(destination, "");
                }
                mailList.add(mail);
            } else {
                for (String destination : processedDestinationList) {
                    Mail mail = this.mm.createMail(MetaSendNotificationEventListener.this.tmplDefName, bindings);
                    mail.addRecipientTo(destination, "");
                    mailList.add(mail);
                }
            }
            return mailList;
        }

        @Override
        protected void sendNotification(Object mail) {
            for (Mail m : (List)mail) {
                this.mm.sendMail(m);
            }
        }
    }

    private abstract class SendNotificationListenerEventHandler
    extends MetaEventListener.EventListenerRuntime {
        private static final String SCRIPT_PREFIX = "SendNotificationListenerEventHandler_notificationCondScript";
        private static final String DESTINATION_PREFIX = "SendNotificationListenerEventHandler_destinationList";
        private Script compiledScript;
        private ScriptEngine scriptEngine;
        private List<GroovyTemplate> destinationTemplateList;
        private boolean isNotifyAfterDelete;
        private boolean isNotifyAfterInsert;
        private boolean isNotifyAfterUpdate;
        private boolean isNotifyBeforeDelete;
        private boolean isNotifyBeforeInsert;
        private boolean isNotifyBeforeUpdate;
        private boolean isNotifyBeforeValidate;
        private boolean isNotifyOnLoad;
        private boolean isNotifyAfterRestore;
        private boolean isNotifyAfterPurge;

        public SendNotificationListenerEventHandler(MetaEntity entity) {
            super(MetaSendNotificationEventListener.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            if (StringUtil.isNotEmpty(MetaSendNotificationEventListener.this.notificationCondScript)) {
                String scriptWithImport = "import " + EventType.class.getName() + ";\n" + MetaSendNotificationEventListener.this.notificationCondScript;
                String scriptName = null;
                for (int i = 0; i < entity.getEventListenerList().size(); ++i) {
                    if (MetaSendNotificationEventListener.this != entity.getEventListenerList().get(i)) continue;
                    scriptName = "SendNotificationListenerEventHandler_notificationCondScript_" + entity.getId() + "_" + i;
                    break;
                }
                this.compiledScript = this.scriptEngine.createScript(scriptWithImport, scriptName);
            }
            this.destinationTemplateList = this.createDestinationTemplate(MetaSendNotificationEventListener.this.destinationList, entity);
            if (MetaSendNotificationEventListener.this.listenEvent != null) {
                for (EventType eType : MetaSendNotificationEventListener.this.listenEvent) {
                    switch (eType) {
                        case AFTER_DELETE: {
                            this.isNotifyAfterDelete = true;
                            break;
                        }
                        case AFTER_INSERT: {
                            this.isNotifyAfterInsert = true;
                            break;
                        }
                        case AFTER_UPDATE: {
                            this.isNotifyAfterUpdate = true;
                            break;
                        }
                        case BEFORE_DELETE: {
                            this.isNotifyBeforeDelete = true;
                            break;
                        }
                        case BEFORE_INSERT: {
                            this.isNotifyBeforeInsert = true;
                            break;
                        }
                        case BEFORE_UPDATE: {
                            this.isNotifyBeforeUpdate = true;
                            break;
                        }
                        case BEFORE_VALIDATE: {
                            this.isNotifyBeforeValidate = true;
                            break;
                        }
                        case ON_LOAD: {
                            this.isNotifyOnLoad = true;
                            break;
                        }
                        case AFTER_RESTORE: {
                            this.isNotifyAfterRestore = true;
                            break;
                        }
                        case AFTER_PURGE: {
                            this.isNotifyAfterPurge = true;
                        }
                    }
                }
            }
        }

        private void setupHandleAfterCommit(Entity entity, EventType type, EntityEventContext context) {
            Transaction t = ManagerLocator.getInstance().getManager(TransactionManager.class).currentTransaction();
            Object n = this.createNotification(entity, type, context);
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                t.afterCommit(() -> {
                    try {
                        this.sendNotification(n);
                    }
                    catch (RuntimeException e) {
                        fatalLog.error("cannot send notification:entity=" + entity + ",event=" + (Object)((Object)type) + ",context=" + context + ",templateName=" + MetaSendNotificationEventListener.this.tmplDefName, (Throwable)e);
                    }
                });
            } else {
                this.sendNotification(n);
            }
        }

        private boolean callScript(Entity entity, EventType type, EntityEventContext context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaSendNotificationEventListener.ENTITY_BINDING_NAME, entity);
            sc.setAttribute(MetaSendNotificationEventListener.EVENT_TYPE_BINDING_NAME, (Object)type);
            sc.setAttribute(MetaSendNotificationEventListener.CONTEXT_BINDING_NAME, context);
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            sc.setAttribute(MetaSendNotificationEventListener.USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            sc.setAttribute(MetaSendNotificationEventListener.DATE_BINGING_NAME, ex.getCurrentTimestamp());
            Object val = this.compiledScript.eval(sc);
            if (val != null) {
                if (val instanceof Boolean) {
                    return (Boolean)val;
                }
                if (val instanceof String) {
                    return Boolean.parseBoolean((String)val);
                }
            }
            return false;
        }

        protected abstract Object createNotification(Entity var1, EventType var2, EntityEventContext var3);

        protected abstract void sendNotification(Object var1);

        @Override
        public void handleAfterDelete(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterDelete && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_DELETE, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_DELETE, context);
            }
        }

        @Override
        public void handleAfterInsert(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterInsert && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_INSERT, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_INSERT, context);
            }
        }

        @Override
        public void handleAfterUpdate(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterUpdate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_UPDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_UPDATE, context);
            }
        }

        @Override
        public boolean handleBeforeDelete(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeDelete && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_DELETE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_DELETE, context);
            }
            return true;
        }

        @Override
        public boolean handleBeforeInsert(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeInsert && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_INSERT, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_INSERT, context);
            }
            return true;
        }

        @Override
        public boolean handleBeforeUpdate(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeUpdate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_UPDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_UPDATE, context);
            }
            return true;
        }

        @Override
        public void handleOnLoad(Entity entity) {
            if (this.isNotifyOnLoad && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.ON_LOAD, null))) {
                this.setupHandleAfterCommit(entity, EventType.ON_LOAD, null);
            }
        }

        @Override
        public void handleBeforeValidate(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeValidate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_VALIDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_VALIDATE, context);
            }
        }

        @Override
        public void handleAfterRestore(Entity entity) {
            if (this.isNotifyAfterRestore && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_RESTORE, null))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_RESTORE, null);
            }
        }

        @Override
        public void handleAfterPurge(Entity entity) {
            if (this.isNotifyAfterPurge && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_PURGE, null))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_PURGE, null);
            }
        }

        @Override
        public MetaSendNotificationEventListener getMetaData() {
            return MetaSendNotificationEventListener.this;
        }

        protected Map<String, Object> generateBindings(Entity entity, EventType type, EntityEventContext context) {
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put(MetaSendNotificationEventListener.TENANT_BINDING_NAME, ex.getCurrentTenant());
            bindings.put(MetaSendNotificationEventListener.ENTITY_BINDING_NAME, entity);
            bindings.put(MetaSendNotificationEventListener.EVENT_TYPE_BINDING_NAME, (Object)type);
            bindings.put(MetaSendNotificationEventListener.CONTEXT_BINDING_NAME, context);
            bindings.put(MetaSendNotificationEventListener.USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            bindings.put(MetaSendNotificationEventListener.DATE_BINGING_NAME, ex.getCurrentTimestamp());
            return bindings;
        }

        protected List<String> processDestinationGroovyTemplate(Map<String, Object> bindings) {
            ArrayList<String> processedDestinationList = new ArrayList<String>();
            if (this.destinationTemplateList == null) {
                return processedDestinationList;
            }
            for (GroovyTemplate destinationTemplate : this.destinationTemplateList) {
                StringWriter sw = new StringWriter();
                GroovyTemplateBinding gtb = new GroovyTemplateBinding(sw, bindings);
                try {
                    destinationTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String temp = sw.toString();
                if (temp == null || temp.replaceAll("\\s+", "").isEmpty()) continue;
                processedDestinationList.add(temp);
            }
            return processedDestinationList;
        }

        private List<GroovyTemplate> createDestinationTemplate(List<String> destinationList, MetaEntity entity) {
            int i;
            ArrayList<GroovyTemplate> templateList = new ArrayList<GroovyTemplate>();
            if (destinationList == null) {
                return templateList;
            }
            String entityName = new String(entity.getName());
            for (i = 0; i < entity.getEventListenerList().size() && MetaSendNotificationEventListener.this != entity.getEventListenerList().get(i); ++i) {
            }
            for (int j = 0; j < destinationList.size(); ++j) {
                String script = destinationList.get(j);
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                GroovyTemplate destinationTemplate = GroovyTemplateCompiler.compile(script, "SendNotificationListenerEventHandler_destinationList_Entity_" + entityName + "_listener" + i + "_destination" + j, (GroovyScriptEngine)se);
                templateList.add(destinationTemplate);
            }
            return templateList;
        }
    }
}

