/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.normalizer;

import java.util.regex.Pattern;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.NormalizerDefinition;
import org.iplass.mtp.entity.definition.normalizers.RegexReplace;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.normalizer.MetaNormalizer;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaRegexReplace
extends MetaNormalizer {
    private static final long serialVersionUID = 5110747155053169365L;
    private String regex;
    private String replacement;

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaRegexReplace other = (MetaRegexReplace)obj;
        if (this.regex == null ? other.regex != null : !this.regex.equals(other.regex)) {
            return false;
        }
        return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
    }

    @Override
    public MetaRegexReplace copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(NormalizerDefinition definition) {
        RegexReplace d = (RegexReplace)definition;
        this.regex = d.getRegex();
        this.replacement = d.getReplacement();
    }

    @Override
    public RegexReplace currentConfig(EntityContext context) {
        return new RegexReplace(this.regex, this.replacement);
    }

    @Override
    public MetaNormalizer.NormalizerRuntime createRuntime(MetaEntity entity, MetaProperty property) {
        return new RegexReplaceRuntime(property);
    }

    public class RegexReplaceRuntime
    extends MetaNormalizer.NormalizerRuntime {
        private Pattern pattern;

        RegexReplaceRuntime(MetaProperty property) {
            if (MetaRegexReplace.this.regex == null || MetaRegexReplace.this.replacement == null) {
                throw new NullPointerException(property.getName() + "'s RegexReplace regex and replacement must specified");
            }
            this.pattern = Pattern.compile(MetaRegexReplace.this.regex);
        }

        @Override
        public Object normalize(Object value, ValidationContext context) {
            if (value == null) {
                return null;
            }
            return this.pattern.matcher(value.toString()).replaceAll(MetaRegexReplace.this.replacement);
        }
    }
}

