/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class MetaPrimitiveProperty
extends MetaProperty {
    private static final long serialVersionUID = 1566456340736914795L;
    private PropertyType type;

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    @Override
    public void applyConfig(PropertyDefinition pDef, EntityContext context) {
        if (pDef instanceof ReferenceProperty) {
            throw new EntityRuntimeException("Illegal Type Convert. PrimitiveProperty to ReferenceProperty cannot support.");
        }
        this.fillFrom(pDef, context);
        PropertyService pService = ServiceRegistry.getRegistry().getService(PropertyService.class);
        this.type = pService.newPropertyType(pDef);
        if (this.type == null) {
            throw new EntityRuntimeException("Unsupported PropertyType." + pDef.getClass().getName());
        }
    }

    @Override
    public PropertyDefinition currentConfig(EntityContext context) {
        PropertyDefinition pd = this.type.createPropertyDefinitionInstance();
        this.fillTo(pd, context);
        return pd;
    }

    @Override
    public MetaPrimitiveProperty copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public PrimitivePropertyHandler createRuntime(MetaEntity metaEntity) {
        return new PrimitivePropertyHandler(this, metaEntity);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaPrimitiveProperty other = (MetaPrimitiveProperty)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

