/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.BooleanType;
import org.iplass.mtp.impl.properties.basic.DateTimeType;
import org.iplass.mtp.impl.properties.basic.DateType;
import org.iplass.mtp.impl.properties.basic.DecimalType;
import org.iplass.mtp.impl.properties.basic.FloatType;
import org.iplass.mtp.impl.properties.basic.IntegerType;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.basic.TimeType;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.properties.extend.BinaryType;
import org.iplass.mtp.impl.properties.extend.ExpressionType;
import org.iplass.mtp.impl.properties.extend.LongTextType;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class PropertyService
implements Service {
    private int longTextInlineStoreMaxLength = 1024;
    private boolean remainInlineText = false;
    private Map<Class<?>, PropertyType> map;
    private EnumMap<PropertyDefinitionType, PropertyType> enumMap;

    public int getLongTextInlineStoreMaxLength() {
        return this.longTextInlineStoreMaxLength;
    }

    public boolean isRemainInlineText() {
        return this.remainInlineText;
    }

    public PropertyType newPropertyType(PropertyDefinition pDef) {
        PropertyType pt = null;
        switch (pDef.getType()) {
            case AUTONUMBER: {
                pt = new AutoNumberType();
                break;
            }
            case BINARY: {
                pt = new BinaryType();
                break;
            }
            case BOOLEAN: {
                pt = new BooleanType();
                break;
            }
            case DATE: {
                pt = new DateType();
                break;
            }
            case DATETIME: {
                pt = new DateTimeType();
                break;
            }
            case DECIMAL: {
                pt = new DecimalType();
                break;
            }
            case EXPRESSION: {
                pt = new ExpressionType();
                break;
            }
            case FLOAT: {
                pt = new FloatType();
                break;
            }
            case INTEGER: {
                pt = new IntegerType();
                break;
            }
            case LONGTEXT: {
                pt = new LongTextType();
                break;
            }
            case REFERENCE: {
                throw new IllegalArgumentException();
            }
            case SELECT: {
                pt = new SelectType();
                break;
            }
            case STRING: {
                pt = new StringType();
                break;
            }
            case TIME: {
                pt = new TimeType();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        pt.applyDefinition(pDef);
        return pt;
    }

    public PropertyType getPropertyType(Class<?> type) {
        return this.map.get(type);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        String longTextInlineStoreMaxLengthString = config.getValue("longTextInlineStoreMaxLength");
        if (longTextInlineStoreMaxLengthString != null) {
            this.longTextInlineStoreMaxLength = Integer.parseInt(longTextInlineStoreMaxLengthString);
        }
        if (config.getValue("remainInlineText") != null) {
            this.remainInlineText = Boolean.valueOf(config.getValue("remainInlineText"));
        }
        this.map = new HashMap();
        this.enumMap = new EnumMap(PropertyDefinitionType.class);
        this.map.put(BinaryReference.class, new BinaryType());
        this.map.put(Boolean.class, new BooleanType());
        this.map.put(Timestamp.class, new DateTimeType());
        this.map.put(Date.class, new DateType());
        this.map.put(Time.class, new TimeType());
        this.map.put(BigDecimal.class, new DecimalType(Integer.MIN_VALUE, null));
        this.map.put(Double.class, new FloatType());
        this.map.put(Long.class, new IntegerType());
        this.map.put(String.class, new StringType());
        this.map.put(SelectValue.class, new SelectType());
        this.enumMap.put(PropertyDefinitionType.BINARY, new BinaryType());
        this.enumMap.put(PropertyDefinitionType.BOOLEAN, new BooleanType());
        this.enumMap.put(PropertyDefinitionType.DATETIME, new DateTimeType());
        this.enumMap.put(PropertyDefinitionType.DATE, new DateType());
        this.enumMap.put(PropertyDefinitionType.TIME, new TimeType());
        this.enumMap.put(PropertyDefinitionType.DECIMAL, new DecimalType(Integer.MIN_VALUE, null));
        this.enumMap.put(PropertyDefinitionType.FLOAT, new FloatType());
        this.enumMap.put(PropertyDefinitionType.INTEGER, new IntegerType());
        this.enumMap.put(PropertyDefinitionType.STRING, new StringType());
        this.enumMap.put(PropertyDefinitionType.SELECT, new SelectType());
    }

    public PropertyType getPropertyType(PropertyDefinitionType et) {
        return this.enumMap.get((Object)et);
    }
}

