/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import java.util.ArrayList;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.DeleteTarget;
import org.iplass.mtp.impl.entity.versioning.VersionController;

public class NonVersionController
implements VersionController {
    @Override
    public void normalizeForInsert(Entity entity, InsertOption option, EntityContext entityContext) {
        entity.setVersion(0L);
    }

    @Override
    public void update(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        entity.setVersion(0L);
        eh.updateDirect(entity, option, entityContext);
    }

    @Override
    public DeleteTarget[] getDeleteTarget(Entity entity, DeleteOption option, EntityHandler eh, EntityContext entityContext) {
        return new DeleteTarget[]{new DeleteTarget(entity.getOid(), 0L, entity.getUpdateDate())};
    }

    @Override
    public String[] getCascadeDeleteTarget(Entity entity, EntityHandler eh, ReferencePropertyHandler rph, EntityContext entityContext) {
        Entity loadedEntity = (Entity)new EntityLoadInvocationImpl(entity.getOid(), 0L, null, false, eh.getService().getInterceptors(), eh).proceed();
        if (loadedEntity != null) {
            if (rph.getMetaData().getMultiplicity() == 1) {
                Entity cascade = (Entity)loadedEntity.getValue(rph.getName());
                if (cascade != null) {
                    return new String[]{cascade.getOid()};
                }
            } else {
                Entity[] cascade = (Entity[])loadedEntity.getValue(rph.getName());
                if (cascade != null && cascade.length != 0) {
                    String[] oids = new String[cascade.length];
                    for (int i = 0; i < cascade.length; ++i) {
                        oids[i] = cascade[i].getOid();
                    }
                    return oids;
                }
            }
        }
        return null;
    }

    @Override
    public Condition mainQueryCondition(EntityHandler eh, AsOf asOf, EntityContext context) {
        return new Equals("version", 0L);
    }

    @Override
    public Condition refEntityQueryCondition(String refPropPath, ReferencePropertyHandler rph, AsOf asOf, EntityContext context) {
        return null;
    }

    @Override
    public Entity[] normalizeRefEntity(Entity[] refEntity, ReferencePropertyHandler rph, EntityContext context) {
        if (refEntity == null) {
            return null;
        }
        Long zero = 0L;
        for (Entity e : refEntity) {
            if (e == null) continue;
            e.setVersion(zero);
        }
        return refEntity;
    }

    @Override
    public Entity[] getCascadeDeleteTargetForUpdate(Entity[] refEntity, Entity[] beforeRefEntity, ReferencePropertyHandler rph, Entity beforeEntity, EntityHandler eh, EntityContext entityContext) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity e : beforeRefEntity) {
            if (e == null) continue;
            if (refEntity == null) {
                ret.add(e);
                continue;
            }
            boolean match = false;
            for (Entity newE : refEntity) {
                if (newE == null || !newE.getOid().equals(e.getOid())) continue;
                match = true;
                break;
            }
            if (match) continue;
            ret.add(e);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret.toArray(new Entity[ret.size()]);
    }
}

