/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import java.sql.Timestamp;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.hint.SuppressWarningsHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.NumberbaseVersionController;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;

public class SimpleTimebaseVersionController
extends NumberbaseVersionController {
    @Override
    public void normalizeForInsert(Entity entity, InsertOption option, EntityContext entityContext) {
        super.normalizeForInsert(entity, option, entityContext);
        if (entity.getStartDate() == null) {
            entity.setStartDate(ExecuteContext.getCurrentContext().getCurrentTimestamp());
        }
        if (entity.getEndDate() == null) {
            entity.setEndDate(ExecuteContext.getCurrentContext().getDefaultEndDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        if (entity.getStartDate() == null) {
            entity.setStartDate(ExecuteContext.getCurrentContext().getCurrentTimestamp());
        }
        if (entity.getEndDate() == null) {
            entity.setEndDate(ExecuteContext.getCurrentContext().getDefaultEndDate());
        }
        super.update(entity, option, eh, entityContext);
        if (option.getTargetVersion() == TargetVersion.NEW || option.getUpdateProperties() != null && (option.getUpdateProperties().contains("startDate") || option.getUpdateProperties().contains("endDate") || option.getUpdateProperties().contains("state"))) {
            Query q = new Query().select(new Count()).hint(new SuppressWarningsHint()).from(eh.getMetaData().getName()).where(new And(new Equals("oid", entity.getOid()), new Equals("state", "V"), new Lesser("startDate", (Object)new ScalarSubQuery(new Query().select(new EntityField("endDate")).from(eh.getMetaData().getName()).where(new And(new Equals("oid", entity.getOid()), new Equals("version", entity.getVersion()), new Equals("state", "V"))).versioned())), new Greater("endDate", (Object)new ScalarSubQuery(new Query().select(new EntityField("startDate")).from(eh.getMetaData().getName()).where(new And(new Equals("oid", entity.getOid()), new Equals("version", entity.getVersion()), new Equals("state", "V"))).versioned())))).versioned();
            Long[] res = new Long[1];
            try (SearchResultIterator it = eh.getStrategy().search(entityContext, q, eh);){
                if (it.next()) {
                    res[0] = (Long)it.getValue(0);
                }
            }
            if (res[0] > 1L) {
                throw new EntityApplicationException(CoreResourceBundleUtil.resourceString("impl.core.versioning.SimpleTimebaseVersionController.overlappingPeriods", eh.getLocalizedDisplayName()));
            }
        }
    }

    @Override
    public Condition refEntityQueryCondition(String refPropPath, ReferencePropertyHandler rph, AsOf asOf, EntityContext context) {
        asOf = this.judgeAsOf(refPropPath, rph, asOf);
        Timestamp ts = ExecuteContext.getCurrentContext().getCurrentTimestamp();
        switch (asOf.getSpec()) {
            case UPDATE_TIME: {
                return null;
            }
            case NOW: {
                return new And(new Equals(refPropPath + "." + "state", "V"), new LesserEqual(refPropPath + "." + "startDate", ts), new Greater(refPropPath + "." + "endDate", ts));
            }
            case SPEC_VALUE: {
                ValueExpression asOfVal = asOf.getValue();
                return new And(new Equals(refPropPath + "." + "state", "V"), new LesserEqual(refPropPath + "." + "startDate", (Object)asOfVal), new Greater(refPropPath + "." + "endDate", (Object)asOfVal));
            }
        }
        return null;
    }

    @Override
    public Condition mainQueryCondition(EntityHandler eh, AsOf asOf, EntityContext context) {
        if (asOf == null || asOf.getSpec() != AsOf.AsOfSpec.SPEC_VALUE) {
            Timestamp ts = ExecuteContext.getCurrentContext().getCurrentTimestamp();
            return new And(new Equals("state", "V"), new LesserEqual("startDate", ts), new Greater("endDate", ts));
        }
        ValueExpression asOfVal = asOf.getValue();
        return new And(new Equals("state", "V"), new LesserEqual("startDate", (Object)asOfVal), new Greater("endDate", (Object)asOfVal));
    }
}

