/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import java.sql.Timestamp;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.DeleteTarget;
import org.iplass.mtp.impl.entity.versioning.NumberbaseVersionController;

public class TimebaseVersionController
extends NumberbaseVersionController {
    @Override
    public void normalizeForInsert(Entity entity, InsertOption option, EntityContext entityContext) {
        super.normalizeForInsert(entity, option, entityContext);
        if (entity.getStartDate() == null) {
            entity.setStartDate(ExecuteContext.getCurrentContext().getCurrentTimestamp());
        }
        if (entity.getEndDate() == null) {
            entity.setEndDate(ExecuteContext.getCurrentContext().getDefaultEndDate());
        }
    }

    @Override
    public void update(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        if (entity.getStartDate() == null) {
            entity.setStartDate(ExecuteContext.getCurrentContext().getCurrentTimestamp());
        }
        if (entity.getEndDate() == null) {
            entity.setEndDate(ExecuteContext.getCurrentContext().getDefaultEndDate());
        }
        super.update(entity, option, eh, entityContext);
    }

    @Override
    public DeleteTarget[] getDeleteTarget(Entity entity, DeleteOption option, EntityHandler eh, EntityContext entityContext) {
        return super.getDeleteTarget(entity, option, eh, entityContext);
    }

    @Override
    public Condition refEntityQueryCondition(String refPropPath, ReferencePropertyHandler rph, AsOf asOf, EntityContext context) {
        asOf = this.judgeAsOf(refPropPath, rph, asOf);
        Timestamp ts = ExecuteContext.getCurrentContext().getCurrentTimestamp();
        switch (asOf.getSpec()) {
            case UPDATE_TIME: {
                return null;
            }
            case NOW: {
                In in = new In(new String[]{refPropPath + "." + "oid", refPropPath + "." + "version"}, new SubQuery(new Query().select(new EntityField("oid"), new Max("version")).from(rph.getReferenceEntityHandler(context).getMetaData().getName()).where(new And(new Equals("state", "V"), new LesserEqual("startDate", ts), new Greater("endDate", ts))).groupBy("oid")).on(refPropPath, "this"));
                return in;
            }
            case SPEC_VALUE: {
                ValueExpression asOfVal = asOf.getValue();
                if (asOfVal != null) {
                    asOfVal = (ValueExpression)asOfVal.accept(new NumberbaseVersionController.PropertyUnnester());
                }
                In in2 = new In(new String[]{refPropPath + "." + "oid", refPropPath + "." + "version"}, new SubQuery(new Query().select(new EntityField("oid"), new Max("version")).from(rph.getReferenceEntityHandler(context).getMetaData().getName()).where(new Equals("state", "V")).groupBy("oid")).on(new And(new Equals(new EntityField("." + refPropPath), new EntityField("this")), new LesserEqual("startDate", (Object)asOfVal), new Greater("endDate", (Object)asOfVal))));
                return in2;
            }
        }
        return null;
    }

    @Override
    public Condition mainQueryCondition(EntityHandler eh, AsOf asOf, EntityContext context) {
        if (asOf == null || asOf.getSpec() != AsOf.AsOfSpec.SPEC_VALUE) {
            Timestamp ts = ExecuteContext.getCurrentContext().getCurrentTimestamp();
            return new Equals("version", (Object)new ScalarSubQuery(new Query().select(new Max("version")).from(eh.getMetaData().getName()).where(new And(new Equals("state", "V"), new LesserEqual("startDate", ts), new Greater("endDate", ts)))).on("this", "this"));
        }
        ValueExpression asOfVal = asOf.getValue();
        if (asOfVal != null) {
            asOfVal = (ValueExpression)asOfVal.accept(new NumberbaseVersionController.PropertyUnnester());
        }
        return new Equals("version", (Object)new ScalarSubQuery(new Query().select(new Max("version")).from(eh.getMetaData().getName()).where(new Equals("state", "V"))).on(new And(new Equals(new EntityField(".this"), new EntityField("this")), new LesserEqual("startDate", (Object)asOfVal), new Greater("endDate", (Object)asOfVal))));
    }
}

