/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.DefinitionSummary;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchCondition;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchOption;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchResult;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.impl.fulltextsearch.IndexedEntity;
import org.iplass.mtp.impl.fulltextsearch.TempEntityList;
import org.iplass.mtp.impl.fulltextsearch.parser.BinaryNameTypeParser;
import org.iplass.mtp.impl.fulltextsearch.parser.BinaryReferenceParseException;
import org.iplass.mtp.impl.fulltextsearch.parser.BinaryReferenceParser;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogDeleteSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogInsertSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogSearchSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogUpdateSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogDeleteSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogSearchSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogTable;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.impl.properties.extend.ExpressionType;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFulltextSearchService
implements FulltextSearchService {
    private static Logger logger = LoggerFactory.getLogger(AbstractFulltextSearchService.class);
    private RdbAdapter rdb;
    private CrawlLogDeleteSql crawlLogDeleteSql;
    private CrawlLogSearchSql crawlLogSearchSql;
    private CrawlLogInsertSql crawlLogInsertSql;
    private CrawlLogUpdateSql crawlLogUpdateSql;
    private DeleteLogDeleteSql deleteLogDeleteSql;
    private DeleteLogSearchSql deleteLogSearchSql;
    private boolean useFulltextSearch;
    private int maxRows = 0;
    private boolean throwExceptionWhenOverLimit;
    protected long redundantTimeMinutes;
    private List<BinaryReferenceParser> binaryParsers;
    private int binaryParseLimitLength = 100000;
    private String scorePropertyName = "score";
    private boolean includeMappedByReferenceIfNoPropertySpecified = false;

    @Override
    public void init(Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.useFulltextSearch = Boolean.valueOf(config.getValue("useFulltextSearch"));
        this.maxRows = Integer.valueOf(config.getValue("maxRows"));
        this.throwExceptionWhenOverLimit = Boolean.valueOf(config.getValue("throwExceptionWhenOverLimit"));
        this.redundantTimeMinutes = config.getValue("redundantTimeMinutes", Long.TYPE, 10L);
        this.binaryParsers = config.getValues("binaryParser", BinaryReferenceParser.class);
        if (this.binaryParsers == null) {
            this.binaryParsers = Collections.singletonList(new BinaryNameTypeParser());
        } else if (!(this.binaryParsers.get(this.binaryParsers.size() - 1) instanceof BinaryNameTypeParser)) {
            this.binaryParsers.add(new BinaryNameTypeParser());
        }
        this.binaryParseLimitLength = config.getValue("binaryParseLimitLength", Integer.TYPE, 100000);
        this.scorePropertyName = config.getValue("scorePropertyName", String.class, "score");
        this.includeMappedByReferenceIfNoPropertySpecified = config.getValue("includeMappedByReferenceIfNoPropertySpecified", Boolean.class, false);
        if (this.useFulltextSearch) {
            this.crawlLogSearchSql = this.rdb.getQuerySqlCreator(CrawlLogSearchSql.class);
            this.crawlLogDeleteSql = this.rdb.getUpdateSqlCreator(CrawlLogDeleteSql.class);
            this.crawlLogInsertSql = this.rdb.getUpdateSqlCreator(CrawlLogInsertSql.class);
            this.crawlLogUpdateSql = this.rdb.getUpdateSqlCreator(CrawlLogUpdateSql.class);
            this.deleteLogDeleteSql = this.rdb.getUpdateSqlCreator(DeleteLogDeleteSql.class);
            this.deleteLogSearchSql = this.rdb.getQuerySqlCreator(DeleteLogSearchSql.class);
        }
    }

    @Override
    public void initTenantContext(TenantContext tenantContext) {
    }

    @Override
    public void destroyTenantContext(TenantContext tenantContext) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isUseFulltextSearch() {
        return this.useFulltextSearch;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public boolean isThrowExceptionWhenOverLimit() {
        return this.throwExceptionWhenOverLimit;
    }

    @Override
    public void execCrawlEntity(String ... defNames) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        EntityDefinitionManager edm = ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        if (defNames == null || defNames.length == 0) {
            List<DefinitionSummary> defList = edm.definitionNameList();
            for (DefinitionSummary def : defList) {
                this.createIndexData(tenantId, def.getName());
            }
        } else {
            for (String defName : defNames) {
                this.createIndexData(tenantId, defName);
            }
        }
    }

    protected abstract void createIndexData(int var1, String var2);

    protected String toValue(Object val) throws IOException {
        if (val == null) {
            return "";
        }
        if (val instanceof Timestamp) {
            SimpleDateFormat dateTimeFormat = DateUtil.getSimpleDateFormat(this.getLocaleFormat().getOutputDatetimeSecFormat(), true);
            dateTimeFormat.setLenient(false);
            return dateTimeFormat.format((Timestamp)val);
        }
        if (val instanceof Date) {
            SimpleDateFormat dateFormat = DateUtil.getSimpleDateFormat(this.getLocaleFormat().getOutputDateFormat(), false);
            dateFormat.setLenient(false);
            return dateFormat.format((Date)val);
        }
        if (val instanceof Time) {
            SimpleDateFormat timeFormat = DateUtil.getSimpleDateFormat(this.getLocaleFormat().getOutputTimeSecFormat(), false);
            timeFormat.setLenient(false);
            return timeFormat.format((Time)val);
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).toPlainString();
        }
        if (val instanceof Long) {
            return val.toString();
        }
        if (val instanceof Double) {
            return val.toString();
        }
        if (val instanceof BinaryReference) {
            return this.parseBinaryReference((BinaryReference)val);
        }
        return val.toString();
    }

    private LocaleFormat getLocaleFormat() {
        return ExecuteContext.getCurrentContext().getLocaleFormat();
    }

    private String parseBinaryReference(BinaryReference br) throws IOException {
        for (int i = 0; i < this.binaryParsers.size(); ++i) {
            BinaryReferenceParser support = this.binaryParsers.get(i).getParser(br);
            if (support == null) continue;
            try {
                String value = support.parse(br, this.binaryParseLimitLength);
                if (!StringUtil.isNotEmpty(value)) continue;
                logger.debug("binary reference parsed on " + support.getClass().getSimpleName() + ". type=" + br.getType());
                return value;
            }
            catch (BinaryReferenceParseException e) {
                logger.warn("binary reference parse error. so try to parse on next paser. type=" + br.getType() + ",parser=" + support.getClass().getSimpleName(), (Throwable)e);
            }
        }
        throw new FulltextSearchRuntimeException("invalid service status.");
    }

    protected Map<String, String> generateCrawlPropMap(MetaEntity meta) {
        HashMap<String, String> crawlPropertyNameMap = new HashMap<String, String>();
        EntityService ehs = ServiceRegistry.getRegistry().getService(EntityService.class);
        MetaEntity superMeta = ehs.getRuntimeById(meta.getInheritedEntityMetaDataId()).getMetaData();
        for (String crawlId : meta.getCrawlPropertyId()) {
            MetaProperty metaProperty = meta.getDeclaredPropertyById(crawlId);
            if (metaProperty == null) {
                metaProperty = superMeta.getDeclaredPropertyById(crawlId);
            }
            if (metaProperty != null) {
                String propertyName = metaProperty.getName();
                if (metaProperty instanceof MetaReferenceProperty) {
                    crawlPropertyNameMap.put(propertyName + ".name", metaProperty.getId());
                    continue;
                }
                crawlPropertyNameMap.put(propertyName, metaProperty.getId());
                continue;
            }
            logger.warn("### DefinitionName [" + meta.getName() + "] ### crawlId " + crawlId + " is not found.");
        }
        return crawlPropertyNameMap;
    }

    @Override
    public Map<String, Timestamp> getLastCrawlTimestamp(String ... defNames) {
        HashMap<String, Timestamp> result = new HashMap<String, Timestamp>();
        Map<String, CrawlTimestampDto> crawlData = this.getAllLastCrawlTimestamp();
        EntityService ehs = ServiceRegistry.getRegistry().getService(EntityService.class);
        if (defNames.length == 0) {
            crawlData.forEach((key, value) -> {
                EntityHandler entity = ehs.getRuntimeById((String)key);
                if (entity != null) {
                    result.put(entity.getMetaData().getName(), value.getUpDate());
                }
            });
        } else {
            for (String defName : defNames) {
                EntityHandler entity = ehs.getRuntimeByName(defName);
                if (entity == null) {
                    throw new FulltextSearchRuntimeException("A target entity is not exist. [Entity\uff1a" + defName + "]");
                }
                String key2 = entity.getMetaData().getId();
                if (!crawlData.containsKey(key2)) continue;
                result.put(defName, crawlData.get(key2).getUpDate());
            }
        }
        return result;
    }

    protected Timestamp getLastCrawlTimestamp(final String defId, final int version) {
        SqlExecuter<Timestamp> exec = new SqlExecuter<Timestamp>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Timestamp logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.crawlLogSearchSql.toGetLastCrawlTimestampSql(tenantId, defId, version, AbstractFulltextSearchService.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    if (rs.next()) {
                        Timestamp timestamp = rs.getTimestamp(1, AbstractFulltextSearchService.this.rdb.rdbCalendar());
                        return timestamp;
                    }
                }
                return null;
            }
        };
        return (Timestamp)exec.execute(this.rdb, true);
    }

    private Map<String, CrawlTimestampDto> getAllLastCrawlTimestamp() {
        SqlExecuter<Map<String, CrawlTimestampDto>> exec = new SqlExecuter<Map<String, CrawlTimestampDto>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, CrawlTimestampDto> logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.crawlLogSearchSql.toGetAllLastCrawlTimestampSql(tenantId, AbstractFulltextSearchService.this.rdb);
                HashMap<String, CrawlTimestampDto> data = new HashMap<String, CrawlTimestampDto>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        CrawlTimestampDto dto = AbstractFulltextSearchService.this.crawlLogSearchSql.toFulltextSearchCrawlTimestampDto(rs, AbstractFulltextSearchService.this.rdb);
                        data.put(dto.getObjDefId(), dto);
                    }
                }
                return data;
            }
        };
        return (Map)exec.execute(this.rdb, true);
    }

    protected <T> List<T> mergeSortByScore(List<T> list1, List<T> list2, int maxSize, GetScore<T> func) {
        if (list2.isEmpty()) {
            return list1;
        }
        if (list1.isEmpty()) {
            return list2;
        }
        int size = list1.size() + list2.size();
        if (maxSize > 0 && size > maxSize) {
            size = maxSize;
        }
        ArrayList<T> mergeList = new ArrayList<T>(size);
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < size; ++i) {
            if (i1 >= list1.size()) {
                mergeList.add(list2.get(i2));
                ++i2;
                continue;
            }
            if (i2 >= list2.size()) {
                mergeList.add(list1.get(i1));
                ++i1;
                continue;
            }
            T ie1 = list1.get(i1);
            T ie2 = list2.get(i2);
            if (func.get(ie1) > func.get(ie2)) {
                mergeList.add(ie1);
                ++i1;
                continue;
            }
            mergeList.add(ie2);
            ++i2;
        }
        return mergeList;
    }

    protected abstract List<IndexedEntity> fulltextSearchImpl(Integer var1, EntityHandler var2, String var3, int var4);

    private <T extends Entity> SearchResult<T> entitySearchImpl(List<IndexedEntity> oidList, EntityHandler eh, FulltextSearchCondition condition) {
        HashMap<String, Object> map;
        SearchResult searched;
        if (oidList.isEmpty()) {
            return new SearchResult(-1, null);
        }
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        Query query = new Query();
        if (condition == null || condition.getProperties() == null) {
            query.selectAll(eh.getMetaData().getName(), true, true, true, this.includeMappedByReferenceIfNoPropertySpecified);
        } else {
            for (String prop : condition.getProperties()) {
                query.select().add((Object)prop);
            }
            if (!condition.getProperties().contains("oid")) {
                query.select().add((Object)"oid");
            }
            if (condition != null && condition.getOrder() != null) {
                for (SortSpec sortSpec : condition.getOrder().getSortSpecList()) {
                    String sortKey = sortSpec.getSortKey().toString();
                    if (condition.getProperties().contains(sortKey)) continue;
                    query.select().add((Object)sortKey);
                }
            }
            query.from(eh.getMetaData().getName());
        }
        In in = new In();
        in.setPropertyName("oid");
        ArrayList<ValueExpression> inValues = new ArrayList<ValueExpression>(oidList.size());
        for (IndexedEntity ie : oidList) {
            inValues.add(new Literal(ie.getOid()));
        }
        in.setValue(inValues);
        query.where(in);
        if (condition != null && condition.getOrder() != null) {
            query.setOrderBy(condition.getOrder());
        }
        if ((searched = em.searchEntity(query)).getList().isEmpty()) {
            return searched;
        }
        if (condition == null || condition.getOrder() == null) {
            map = new HashMap<String, Object>((int)((float)searched.getList().size() / 0.75f) + 1, 0.75f);
            for (Object e : searched.getList()) {
                map.compute(e.getOid(), (arg_0, arg_1) -> AbstractFulltextSearchService.lambda$entitySearchImpl$1((Entity)e, arg_0, arg_1));
            }
            ArrayList<Entity> mergedList = new ArrayList<Entity>(searched.getList().size());
            for (IndexedEntity ie : oidList) {
                Object o = map.get(ie.getOid());
                if (o == null) continue;
                if (o instanceof List) {
                    for (Entity e : (List)o) {
                        e.setValue(this.scorePropertyName, ie.getScore());
                        mergedList.add(e);
                    }
                    continue;
                }
                Entity e = (Entity)o;
                e.setValue(this.scorePropertyName, ie.getScore());
                mergedList.add(e);
            }
            return new SearchResult(searched.getTotalCount(), mergedList);
        }
        map = new HashMap((int)((float)oidList.size() / 0.75f) + 1, 0.75f);
        for (IndexedEntity ie : oidList) {
            map.put(ie.getOid(), ie);
        }
        for (Entity e : searched.getList()) {
            IndexedEntity ie = (IndexedEntity)map.get(e.getOid());
            e.setValue(this.scorePropertyName, ie.getScore());
        }
        return searched;
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(String searchDefName, String fulltext) {
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(searchDefName);
        List<IndexedEntity> fromIndexList = this.fulltextSearchImpl(ec.getTenantId(eh), eh, fulltext, this.getMaxRows());
        return this.entitySearchImpl(fromIndexList, eh, null);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(Map<String, List<String>> entityProperties, String fulltext) {
        FulltextSearchOption option = new FulltextSearchOption();
        for (Map.Entry<String, List<String>> data : entityProperties.entrySet()) {
            FulltextSearchCondition cond = new FulltextSearchCondition(data.getValue());
            option.getConditions().put(data.getKey(), cond);
        }
        return this.fulltextSearchEntity(fulltext, option);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(String fulltext, FulltextSearchOption option) {
        if (option.getConditions().size() <= 1) {
            EntityContext ec = EntityContext.getCurrentContext();
            Map.Entry<String, FulltextSearchCondition> e = option.getConditions().entrySet().iterator().next();
            EntityHandler eh = ec.getHandlerByName(e.getKey());
            List<IndexedEntity> fromIndexList = this.fulltextSearchImpl(ec.getTenantId(eh), eh, fulltext, this.getMaxRows());
            return this.entitySearchImpl(fromIndexList, eh, e.getValue());
        }
        EntityContext ec = EntityContext.getCurrentContext();
        List<Object> fromIndexList = Collections.emptyList();
        LinkedHashMap<String, TempEntityList> tempEntityListMap = new LinkedHashMap<String, TempEntityList>();
        boolean hasOrderBy = false;
        for (Map.Entry<String, FulltextSearchCondition> e : option.getConditions().entrySet()) {
            EntityHandler eh = ec.getHandlerByName(e.getKey());
            List<IndexedEntity> iel = this.fulltextSearchImpl(ec.getTenantId(eh), eh, fulltext, this.getMaxRows());
            fromIndexList = this.mergeSortByScore(fromIndexList, iel, this.getMaxRows(), t -> t.getScore());
            tempEntityListMap.put(e.getKey(), new TempEntityList(eh, e.getValue()));
            hasOrderBy = hasOrderBy || e.getValue() != null && e.getValue().getOrder() != null;
        }
        if (fromIndexList.isEmpty()) {
            return new SearchResult(-1, null);
        }
        for (IndexedEntity ie : fromIndexList) {
            TempEntityList tel = (TempEntityList)tempEntityListMap.get(ie.getDefName());
            tel.addOids(ie);
        }
        List<Object> resultList = new ArrayList<T>();
        for (Map.Entry e : tempEntityListMap.entrySet()) {
            TempEntityList tel = (TempEntityList)e.getValue();
            if (tel.getOids().size() <= 0) continue;
            SearchResult<T> resPerEntity = this.entitySearchImpl(tel.getOids(), tel.getEh(), tel.getCond());
            if (hasOrderBy) {
                resultList.addAll(resPerEntity.getList());
                continue;
            }
            resultList = this.mergeSortByScore(resultList, resPerEntity.getList(), this.getMaxRows(), t -> (Double)t.getValue(this.scorePropertyName));
        }
        return new SearchResult(-1, resultList);
    }

    @Override
    public List<String> fulltextSearchOidList(String searchDefName, String fulltext) {
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(searchDefName);
        List<IndexedEntity> fromIndexList = this.fulltextSearchImpl(ec.getTenantId(eh), eh, fulltext, -1);
        ArrayList<String> res = new ArrayList<String>(fromIndexList.size());
        for (IndexedEntity ie : fromIndexList) {
            res.add(ie.getOid());
        }
        return res;
    }

    @Override
    public Map<String, List<String>> fulltextSearchOidList(List<String> searchDefNames, String fulltext) {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        EntityContext ec = EntityContext.getCurrentContext();
        List<Object> fromIndexList = Collections.emptyList();
        for (String searchDefName : searchDefNames) {
            resMap.put(searchDefName, new ArrayList());
            EntityHandler eh = ec.getHandlerByName(searchDefName);
            List<IndexedEntity> iel = this.fulltextSearchImpl(ec.getTenantId(eh), eh, fulltext, this.getMaxRows());
            fromIndexList = this.mergeSortByScore(fromIndexList, iel, this.getMaxRows(), t -> t.getScore());
        }
        for (IndexedEntity ie : fromIndexList) {
            List oidList = (List)resMap.get(ie.getDefName());
            oidList.add(ie.getOid());
        }
        return resMap;
    }

    @Override
    public List<FulltextSearchResult> execFulltextSearch(String searchDefName, String keywords) {
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(searchDefName);
        List<IndexedEntity> fromIndexList = this.fulltextSearchImpl(ec.getTenantId(eh), eh, keywords, this.getMaxRows());
        ArrayList<FulltextSearchResult> res = new ArrayList<FulltextSearchResult>(fromIndexList.size());
        for (IndexedEntity ie : fromIndexList) {
            FulltextSearchResult r = new FulltextSearchResult();
            r.setOid(ie.getOid());
            res.add(r);
        }
        return res;
    }

    protected void insertCrawlLog(final String defId, final int version, final Timestamp sysdate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.crawlLogInsertSql.toSql(tenantId, defId, version, sysdate, AbstractFulltextSearchService.this.rdb);
                logger.debug("insert crawl log sql : " + sql);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void updateCrawlLog(final String defId, final int version, final Timestamp sysdate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.crawlLogUpdateSql.toSql(tenantId, defId, version, sysdate, AbstractFulltextSearchService.this.rdb);
                logger.debug("update crawl log sql : " + sql);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected List<RestoreDto> getRestoreIndexData(final String defId, final Timestamp baseDate) {
        SqlExecuter<List<RestoreDto>> exec = new SqlExecuter<List<RestoreDto>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RestoreDto> logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.deleteLogSearchSql.toGetDeleteIndexDataSql(tenantId, defId, baseDate, AbstractFulltextSearchService.this.rdb);
                ArrayList<RestoreDto> dtoList = new ArrayList<RestoreDto>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        dtoList.add(AbstractFulltextSearchService.this.deleteLogSearchSql.toFulltextSearchRestoreDto(rs));
                    }
                }
                return dtoList;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    protected void removeDeleteLog(final String defId, final Timestamp baseDate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.deleteLogDeleteSql.deleteProcessedLog(tenantId, defId, baseDate, AbstractFulltextSearchService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void removeAllDeleteLog() {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.deleteLogDeleteSql.deleteAll(tenantId, AbstractFulltextSearchService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void removeAllCrawlLog() {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSearchService.this.crawlLogDeleteSql.deleteAll(tenantId, AbstractFulltextSearchService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected Map<String, String> generateCrawlPropInfo(MetaEntity meta) {
        HashMap<String, String> crawlPropertyNameMap = new HashMap<String, String>();
        List<MetaProperty> declaredProperties = meta.getDeclaredPropertyList();
        List<MetaProperty> superProperties = null;
        int refCnt = 1;
        int expCnt = 1;
        int columnIndex = 1;
        String columnStr = "V_";
        for (String crawlId : meta.getCrawlPropertyId()) {
            String propertyName;
            boolean match = false;
            for (MetaProperty metaProperty : declaredProperties) {
                propertyName = metaProperty.getName();
                if (!metaProperty.getId().equals(crawlId)) continue;
                if (metaProperty instanceof MetaReferenceProperty) {
                    crawlPropertyNameMap.put(propertyName + ".name", "R_" + refCnt);
                    ++refCnt;
                } else {
                    MetaPrimitiveProperty metaPrimitiveProperty = (MetaPrimitiveProperty)metaProperty;
                    if (metaPrimitiveProperty.getType() instanceof ExpressionType) {
                        crawlPropertyNameMap.put(propertyName, "E_" + expCnt);
                        ++expCnt;
                    } else {
                        String columnName = "";
                        if (metaProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore || metaProperty.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                            columnName = columnStr + columnIndex;
                            ++columnIndex;
                        }
                        if ("OBJ_ID".equals(columnName) || "OBJ_VER".equals(columnName)) {
                            columnName = "OPT_" + columnName;
                        }
                        crawlPropertyNameMap.put(propertyName, columnName);
                    }
                }
                match = true;
                break;
            }
            if (!match) {
                EntityService ehs;
                EntityHandler superEntity;
                if (superProperties == null && (superEntity = (ehs = ServiceRegistry.getRegistry().getService(EntityService.class)).getRuntimeById(meta.getInheritedEntityMetaDataId())) != null) {
                    superProperties = superEntity.getMetaData().getDeclaredPropertyList();
                }
                if (superProperties != null) {
                    for (MetaProperty metaProperty : superProperties) {
                        if (!metaProperty.getId().equals(crawlId)) continue;
                        propertyName = metaProperty.getName();
                        if (!(metaProperty instanceof MetaReferenceProperty)) {
                            String columnName = "";
                            if (metaProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore || metaProperty.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                                columnName = columnStr + columnIndex;
                                ++columnIndex;
                            }
                            if ("OBJ_ID".equals(columnName) || "OBJ_VER".equals(columnName)) {
                                columnName = "OPT_" + columnName;
                            }
                            crawlPropertyNameMap.put(propertyName, columnName);
                        }
                        match = true;
                        break;
                    }
                }
            }
            if (match) continue;
            logger.warn("### DefinitionName [" + meta.getName() + "] ###\r\ncrawlId " + crawlId + " is not found.");
        }
        return crawlPropertyNameMap;
    }

    private static /* synthetic */ Object lambda$entitySearchImpl$1(Entity e, String k, Object v) {
        if (v == null) {
            return e;
        }
        if (v instanceof List) {
            ((List)v).add(e);
            return v;
        }
        ArrayList<Entity> ret = new ArrayList<Entity>();
        ret.add((Entity)v);
        ret.add(e);
        return ret;
    }

    public static class RestoreDto {
        private String id;
        private int tenantId;
        private String objDefId;
        private String objId;
        private Long objVer;
        private DeleteLogTable.Status status;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        public String getObjDefId() {
            return this.objDefId;
        }

        public void setObjDefId(String objDefId) {
            this.objDefId = objDefId;
        }

        public String getObjId() {
            return this.objId;
        }

        public void setObjId(String objId) {
            this.objId = objId;
        }

        public Long getObjVer() {
            return this.objVer;
        }

        public void setObjVer(Long objVer) {
            this.objVer = objVer;
        }

        public DeleteLogTable.Status getStatus() {
            return this.status;
        }

        public void setStatus(DeleteLogTable.Status status) {
            this.status = status;
        }
    }

    public static class CrawlTimestampDto {
        private String objDefId;
        private String objDefVer;
        private Timestamp upDate;

        public String getObjDefId() {
            return this.objDefId;
        }

        public void setObjDefId(String objDefId) {
            this.objDefId = objDefId;
        }

        public String getObjDefVer() {
            return this.objDefVer;
        }

        public void setObjDefVer(String objDefVer) {
            this.objDefVer = objDefVer;
        }

        public Timestamp getUpDate() {
            return this.upDate;
        }

        public void setUpDate(Timestamp upDate) {
            this.upDate = upDate;
        }
    }

    protected static interface GetScore<T> {
        public double get(T var1);
    }
}

