/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.util.InfoStream;

public class IndexWriterSetting {
    private int commitLimit;
    private Double ramBufferSizeMB = 64.0;
    private MergePolicy mergePolicy;
    private InfoStream infoStream;

    public int getCommitLimit() {
        return this.commitLimit;
    }

    public void setCommitLimit(int commitLimit) {
        this.commitLimit = commitLimit;
    }

    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    public void setInfoStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public void setMergePolicy(MergePolicy mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public Double getRamBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public void setRamBufferSizeMB(Double ramBufferSizeMB) {
        this.ramBufferSizeMB = ramBufferSizeMB;
    }

    public IndexWriterConfig createIndexWriterConfig(Analyzer analyzer) {
        IndexWriterConfig config = analyzer == null ? new IndexWriterConfig() : new IndexWriterConfig(analyzer);
        if (this.ramBufferSizeMB != null) {
            config.setRAMBufferSizeMB(this.ramBufferSizeMB.doubleValue());
        }
        if (this.mergePolicy != null) {
            config.setMergePolicy(this.mergePolicy);
        }
        if (this.infoStream != null) {
            config.setInfoStream(this.infoStream);
        }
        return config;
    }
}

