/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.lucene;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.iplass.mtp.impl.fulltextsearch.lucene.IndexDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleIndexDir
implements IndexDir {
    private static Logger logger = LoggerFactory.getLogger(SimpleIndexDir.class);
    private int tenantId;
    private String defId;
    private FSDirectory directory;
    private volatile SearcherManager searcherManager;
    private RefreshSearcherTimerTask timerTask;

    SimpleIndexDir(int tenantId, String defId, FSDirectory directory, long searcherAutoRefreshTimeMinutes, Timer timer) {
        this.tenantId = tenantId;
        this.defId = defId;
        this.directory = directory;
        if (searcherAutoRefreshTimeMinutes > 0L) {
            this.timerTask = new RefreshSearcherTimerTask();
            timer.scheduleAtFixedRate((TimerTask)this.timerTask, TimeUnit.MINUTES.toMillis(searcherAutoRefreshTimeMinutes), TimeUnit.MINUTES.toMillis(searcherAutoRefreshTimeMinutes));
        }
    }

    @Override
    public String getDefId() {
        return this.defId;
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearcherManager getSearcherManager() throws IOException {
        SearcherManager sm = this.searcherManager;
        if (sm == null) {
            SimpleIndexDir simpleIndexDir = this;
            synchronized (simpleIndexDir) {
                if (this.searcherManager == null) {
                    this.searcherManager = sm = new SearcherManager((Directory)this.directory, null);
                } else {
                    sm = this.searcherManager;
                }
            }
        }
        return sm;
    }

    @Override
    public void refresh() throws IOException {
        SearcherManager sm = this.searcherManager;
        if (sm != null) {
            sm.maybeRefreshBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block18: {
            if (logger.isDebugEnabled()) {
                logger.debug("close IndexDir of " + this.tenantId + "/" + this.defId);
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            IOException ex = null;
            try {
                SimpleIndexDir simpleIndexDir = this;
                synchronized (simpleIndexDir) {
                    if (this.searcherManager != null) {
                        this.searcherManager.close();
                    }
                }
            }
            catch (IOException e) {
                ex = e;
            }
            finally {
                try {
                    this.directory.close();
                }
                catch (IOException e) {
                    if (ex != null) {
                        ex.addSuppressed(e);
                    }
                    ex = e;
                }
                if (ex == null) break block18;
                throw ex;
            }
        }
    }

    private class RefreshSearcherTimerTask
    extends TimerTask {
        private RefreshSearcherTimerTask() {
        }

        @Override
        public void run() {
            try {
                SearcherManager sm;
                if (logger.isDebugEnabled()) {
                    logger.debug("Refresh index searcher of " + SimpleIndexDir.this.tenantId + "/" + SimpleIndexDir.this.defId);
                }
                if ((sm = SimpleIndexDir.this.searcherManager) != null) {
                    sm.maybeRefresh();
                }
            }
            catch (IOException e) {
                logger.warn("Error occured when refreshing searcher of " + SimpleIndexDir.this.tenantId + "/" + SimpleIndexDir.this.defId, (Throwable)e);
            }
        }
    }
}

