/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobHandler {
    private static final Logger logger = LoggerFactory.getLogger(LobHandler.class);
    private static HashMap<String, LobHandler> handlerMap;
    private static LobHandler defaultLobHandler;
    private LobStore lobStore;
    private LobDao dao;
    private SessionService sessionService;
    private EntityService ehService;
    private EntityManager em;
    private boolean manageLobSizeOnRdb;

    public static LobHandler getInstance(String lobStoreName) {
        LobHandler h = handlerMap.get(lobStoreName);
        if (h == null) {
            h = defaultLobHandler;
        }
        return h;
    }

    public static Map<String, LobHandler> getHandlerMap() {
        return new HashMap<String, LobHandler>(handlerMap);
    }

    public LobHandler(LobStore lobStore, LobDao dao, SessionService sessionService, EntityService ehService, EntityManager em, boolean manageLobSizeOnRdb) {
        this.lobStore = lobStore;
        this.dao = dao;
        this.sessionService = sessionService;
        this.ehService = ehService;
        this.em = em;
        this.manageLobSizeOnRdb = manageLobSizeOnRdb;
    }

    public boolean canAccess(Lob lob) {
        if (lob.getDefinitionId() == null) {
            if (!this.sessionService.getSession(true).getId().equals(lob.getSessionId())) {
                return false;
            }
        } else {
            AuthContextHolder user = AuthContextHolder.getAuthContext();
            if (user.isPrivilegedExecution()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("privileged updateAll call. shrot cut auth check.");
                }
                return true;
            }
            String entityDefName = null;
            String propDefName = null;
            EntityHandler eh = this.ehService.getRuntimeById(lob.getDefinitionId());
            entityDefName = eh.getMetaData().getName();
            PropertyHandler ph = eh.getPropertyById(lob.getPropertyId(), EntityContext.getCurrentContext());
            propDefName = ph.getName();
            EntityPermission perm = new EntityPermission(entityDefName, EntityPermission.Action.REFERENCE);
            EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
            if (!eac.isPermit(perm, user)) {
                throw new NoPermissionException(LobHandler.resourceString("impl.lob.LobHandler.noPermission", EntityPermission.Action.REFERENCE.toString()));
            }
            EntityPropertyPermission propPerm = new EntityPropertyPermission(entityDefName, propDefName, EntityPropertyPermission.Action.REFERENCE);
            if (!eac.isPermit(propPerm, user)) {
                throw new NoPermissionException(LobHandler.resourceString("impl.lob.LobHandler.noPermission", EntityPropertyPermission.Action.REFERENCE.toString()));
            }
            if (eac.hasLimitCondition(perm, user)) {
                Query q = new Query().select("oid").from(entityDefName).where(new Equals("oid", lob.getOid()));
                if (eh.isVersioned()) {
                    q.versioned();
                }
                if (this.em.count(q) == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public Lob copyFor(long srcLobId, String defId, String propId, String oid, Long version) {
        Lob src = this.getBinaryData(srcLobId);
        if (src == null) {
            return null;
        }
        Lob copy = new Lob(src.getTenantId(), -1L, src.getName(), src.getType(), defId, propId, oid, version, null, "V", src.getLobDataId(), this.lobStore, this.dao, this.manageLobSizeOnRdb);
        if (!this.dao.refCountUp((copy = this.dao.create(copy, this.lobStore)).getTenantId(), copy.getLobDataId(), 1)) {
            throw new EntityConcurrentUpdateException(LobHandler.resourceString("impl.lob.LobHandler.cantUpdate", new Object[0]));
        }
        return copy;
    }

    public Lob[] getBinaryReference(long[] lobId, EntityContext context) {
        return this.dao.search(ExecuteContext.getCurrentContext().getClientTenantId(), lobId, this.lobStore);
    }

    public Lob getBinaryData(long lobId) {
        return this.dao.load(ExecuteContext.getCurrentContext().getClientTenantId(), lobId, this.lobStore);
    }

    public Lob crateBinaryDataTemporary(String name, String type, String sessionId) {
        return this.dao.crateTemporary(ExecuteContext.getCurrentContext().getClientTenantId(), name, type, sessionId, this.lobStore);
    }

    public Lob createBinaryData(String name, String type, String defId, String propId, String oid, Long version) {
        return this.dao.create(ExecuteContext.getCurrentContext().getClientTenantId(), name, type, defId, propId, oid, version, this.lobStore);
    }

    public boolean markPersistenceBinaryData(long lobId, String sessionId, String defId, String propId, String oid, Long version) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        Lob bin = this.dao.loadWithLock(tenantId, lobId, null, null, null, null, null, this.lobStore);
        if (bin == null) {
            return false;
        }
        if (!sessionId.equals(bin.getSessionId())) {
            return false;
        }
        return this.dao.markPersistence(tenantId, lobId, defId, propId, oid, version);
    }

    public boolean updateBinaryDataInfo(long lobId, String name, String type) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        return this.dao.updateBinaryDataInfo(tenantId, lobId, name, type);
    }

    public void removeBinaryData(long lobId) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        Lob forLock = this.dao.loadWithLock(tenantId, lobId, null, null, null, null, null, this.lobStore);
        if (forLock != null) {
            this.dao.remove(tenantId, lobId);
            if (forLock.getLobDataId() != -1L) {
                this.dao.refCountUp(tenantId, forLock.getLobDataId(), -1);
            }
        }
    }

    public BinaryReference toBinaryReference(Lob bin, EntityContext context) {
        if (bin.getDefinitionId() != null) {
            EntityHandler eh = context.getHandlerById(bin.getDefinitionId());
            String defName = eh.getMetaData().getName();
            String propName = null;
            for (PropertyHandler ph : eh.getPropertyList(context)) {
                if (!ph.getId().equals(bin.getPropertyId())) continue;
                propName = ph.getName();
                break;
            }
            return new BinaryReference(bin.getLobId(), bin.getName(), bin.getType(), bin.getSize(), defName, propName, bin.getOid());
        }
        return new BinaryReference(bin.getLobId(), bin.getName(), bin.getType(), bin.getSize());
    }

    public static void cleanTemporaryBinaryData() {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        LobStoreService lobStoreService = ServiceRegistry.getRegistry().getService(LobStoreService.class);
        LobDao dao = lobStoreService.getLobDao();
        List<long[]> cleanupTarget = dao.getLobIdListForCleanTemporary(-1 * lobStoreService.getTemporaryKeepDay(), tenantId);
        int limit = lobStoreService.getCleanCommitLimit() > 0 ? lobStoreService.getCleanCommitLimit() : 100;
        for (int offset = 0; offset < cleanupTarget.size(); offset += limit) {
            int offsetFinal = offset;
            try {
                Transaction.requiresNew(t -> {
                    int end = offsetFinal + limit < cleanupTarget.size() ? offsetFinal + limit : cleanupTarget.size();
                    for (int i = offsetFinal; i < end; ++i) {
                        dao.remove(tenantId, ((long[])cleanupTarget.get(i))[0]);
                        if (((long[])cleanupTarget.get(i))[1] == -1L) continue;
                        dao.refCountUp(tenantId, ((long[])cleanupTarget.get(i))[1], -1);
                    }
                });
                continue;
            }
            catch (RuntimeException e) {
                logger.error("crean up temporary lob process failed:offset=" + offset + ". try to cleanup next offset...", (Throwable)e);
            }
        }
    }

    public static void cleanLobData() {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        LobStoreService lobStoreService = ServiceRegistry.getRegistry().getService(LobStoreService.class);
        LobDao dao = lobStoreService.getLobDao();
        Map<String, LobStore> lobStoreMap = lobStoreService.getLobStoreMap();
        List<Long> lobDataIdList = dao.getLobDataIdListForClean(-1 * lobStoreService.getInvalidKeepDay(), tenantId);
        int limit = lobStoreService.getCleanCommitLimit() > 0 ? lobStoreService.getCleanCommitLimit() : 100;
        for (int offset = 0; offset < lobDataIdList.size(); offset += limit) {
            int offsetFinal = offset;
            try {
                Transaction.requiresNew(t -> {
                    int end = offsetFinal + limit < lobDataIdList.size() ? offsetFinal + limit : lobDataIdList.size();
                    for (int i = offsetFinal; i < end; ++i) {
                        Long lobDataId = (Long)lobDataIdList.get(i);
                        dao.removeData(tenantId, lobDataId);
                        for (Map.Entry le : lobStoreMap.entrySet()) {
                            ((LobStore)le.getValue()).remove(tenantId, lobDataId);
                        }
                    }
                    return null;
                });
                continue;
            }
            catch (RuntimeException e) {
                logger.error("crean up lobData process failed:offset=" + offset + ". try to cleanup next offset...", (Throwable)e);
            }
        }
    }

    public void cleanLobDataImmediately(int tenantId, long lobDataId) {
        this.dao.removeData(tenantId, lobDataId);
        this.lobStore.remove(tenantId, lobDataId);
    }

    public void removeBinaryDataByRbid(long rbid) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        List<Long> lobIdList = this.dao.getLobIdByRbid(tenantId, rbid);
        for (Long lobId : lobIdList) {
            this.removeBinaryData(lobId);
        }
        this.dao.removeFromRecycleBin(ExecuteContext.getCurrentContext().getClientTenantId(), rbid);
    }

    public int removeBinaryDataByDefId(int tenantId, String defId) {
        List<Long> markTarget = this.dao.getLobIdByDefId(tenantId, defId);
        int allCount = 0;
        for (int offset = 0; offset < markTarget.size(); offset += 100) {
            int offsetFinal = offset;
            try {
                allCount += Transaction.requiresNew(t -> {
                    int count = 0;
                    for (int i = offsetFinal; i < markTarget.size(); ++i) {
                        this.removeBinaryData((Long)markTarget.get(i));
                        ++count;
                    }
                    return count;
                }).intValue();
                continue;
            }
            catch (RuntimeException e) {
                logger.error("mark for clean lob process failed:defId=" + defId + ",offset=" + offset + ". try to mark next offset...", (Throwable)e);
            }
        }
        return allCount;
    }

    public int removeBinaryDataForDefrag(int tenantId, EntityHandler eh) {
        List<Long> markTarget = this.dao.getLobIdForDefrag(tenantId, eh);
        int allCount = 0;
        for (int offset = 0; offset < markTarget.size(); offset += 100) {
            int offsetFinal = offset;
            try {
                allCount += Transaction.requiresNew(t -> {
                    int count = 0;
                    for (int i = offsetFinal; i < markTarget.size(); ++i) {
                        this.removeBinaryData((Long)markTarget.get(i));
                        ++count;
                    }
                    return count;
                }).intValue();
                continue;
            }
            catch (RuntimeException e) {
                logger.error("mark for clean lob process failed:defId=" + eh.getMetaData().getId() + ",offset=" + offset + ". try to mark next offset...", (Throwable)e);
            }
        }
        return allCount;
    }

    public void markToRecycleBin(long lobId, long rbid) {
        this.dao.markToRecycleBin(ExecuteContext.getCurrentContext().getClientTenantId(), lobId, rbid);
    }

    public void markRestoreFromRecycleBin(long rbid) {
        this.dao.markRestoreFromRecycleBin(ExecuteContext.getCurrentContext().getClientTenantId(), rbid);
    }

    public long updateLobStoreSize() {
        int LIMIT = 1000;
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        long allCount = 0L;
        List<Long> lobDataIdList = this.dao.getLobDataIdListForLobStoreSizeUpdate(tenantId);
        for (int offset = 0; offset < lobDataIdList.size(); offset += 1000) {
            int offsetFinal = offset;
            try {
                allCount += (long)Transaction.requiresNew(t -> {
                    int updateCount = 0;
                    int limit = Math.min(offsetFinal + 1000, lobDataIdList.size());
                    for (int i = offsetFinal; i < limit; ++i) {
                        long lobDataId = (Long)lobDataIdList.get(i);
                        LobData lobData = this.lobStore.load(tenantId, lobDataId);
                        if (lobData == null || lobData.getSize() <= 0L) continue;
                        this.dao.updateLobStoreSize(tenantId, lobDataId, lobData.getSize());
                        ++updateCount;
                    }
                    return updateCount;
                }).intValue();
                continue;
            }
            catch (RuntimeException e) {
                logger.error("update size of lob store data process failed.", (Throwable)e);
                throw e;
            }
        }
        return allCount;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    static {
        ServiceRegistry sr = ServiceRegistry.getRegistry();
        SessionService sessionService = sr.getService(SessionService.class);
        EntityService ehService = sr.getService(EntityService.class);
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        LobStoreService lobStoreService = sr.getService(LobStoreService.class);
        LobDao dao = lobStoreService.getLobDao();
        handlerMap = new HashMap();
        Map<String, LobStore> lobStoreMap = lobStoreService.getLobStoreMap();
        for (Map.Entry<String, LobStore> e : lobStoreMap.entrySet()) {
            handlerMap.put(e.getKey(), new LobHandler(e.getValue(), dao, sessionService, ehService, em, lobStoreService.isManageLobSizeOnRdb()));
        }
        defaultLobHandler = new LobHandler(lobStoreService.getDefaultLobStore(), dao, sessionService, ehService, em, lobStoreService.isManageLobSizeOnRdb());
    }
}

