/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.checksum.Checksum;
import org.iplass.mtp.impl.lob.checksum.ChecksumFactory;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;

public class LobValidatedOutputStream
extends FilterOutputStream {
    private Checksum checksum;
    private Lob lob;
    private LobValidator lobValidator;
    private boolean closed;

    public LobValidatedOutputStream(OutputStream out, Lob lob, LobValidator lobValidator) {
        super(out);
        this.checksum = ChecksumFactory.getFactory().newChecksum(lobValidator.getChecksumAlgorithm());
        this.lob = lob;
        this.lobValidator = lobValidator;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.checksum.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.checksum.update(b, off, len);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.lobValidator.stored(this.lob, this.getChecksum().getValue());
            this.closed = true;
        }
    }
}

