/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.checksum;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.iplass.mtp.impl.lob.checksum.Checksum;
import org.iplass.mtp.impl.lob.checksum.MessageDigestChecksum;
import org.iplass.mtp.impl.lob.checksum.ZipChecksum;

public class ChecksumFactory {
    public static final String DEFAULT_ALGORITHM = "Adler-32";
    private static ChecksumFactory factory = new ChecksumFactory();

    public static ChecksumFactory getFactory() {
        return factory;
    }

    public Checksum newChecksum(String checksumAlgorithm) {
        if (checksumAlgorithm == null) {
            checksumAlgorithm = DEFAULT_ALGORITHM;
        }
        switch (checksumAlgorithm) {
            case "Adler-32": {
                return new ZipChecksum(new Adler32());
            }
            case "CRC-32": {
                return new ZipChecksum(new CRC32());
            }
        }
        try {
            return new MessageDigestChecksum(MessageDigest.getInstance(checksumAlgorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

