/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;
import org.iplass.mtp.impl.lob.lobstore.file.FileLobData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLobValidator
implements LobValidator {
    private static Logger logger = LoggerFactory.getLogger(ProcessLobValidator.class);
    private List<String> command;
    private String checksumAlgorithm;

    @Override
    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    @Override
    public void stored(Lob lob, String streamWriteChecksum) {
        String user = ExecuteContext.getCurrentContext().getClientId();
        String filePath = null;
        filePath = lob.getLobData() instanceof FileLobData ? ((FileLobData)lob.getLobData()).getFilePath() : "null";
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(this.command);
        cmd.add(filePath);
        cmd.add(streamWriteChecksum);
        cmd.add(lob.getName());
        cmd.add(user);
        if (logger.isDebugEnabled()) {
            logger.debug("process start:" + this.toStr(cmd));
        }
        try {
            new ProcessBuilder(cmd).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            logger.error("process start fail:" + e, (Throwable)e);
        }
    }

    private String toStr(ArrayList<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String c : command) {
            sb.append(c);
            sb.append(" ");
        }
        return sb.toString();
    }
}

