/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLobData
implements LobData {
    private static final Logger logger = LoggerFactory.getLogger(FileLobData.class);
    private boolean overwriteFile;
    private String rootDir;
    private int tenantId;
    private long lobDataId;
    private File blobFile;

    public FileLobData(int tenantId, long lobDataId, String rootDir, boolean overwriteFile) {
        this.tenantId = tenantId;
        this.lobDataId = lobDataId;
        this.rootDir = rootDir;
        this.overwriteFile = overwriteFile;
    }

    @Override
    public long getLobDataId() {
        return this.lobDataId;
    }

    @Override
    public long getSize() {
        if (this.blobFile == null) {
            this.blobFile = this.toFile(this.lobDataId);
        }
        return this.blobFile.length();
    }

    @Override
    public InputStream getBinaryInputStream() {
        return new FileBinaryDataInputStream();
    }

    @Override
    public OutputStream getBinaryOutputStream() {
        return new FileBinaryDataOutputStream();
    }

    public String getFilePath() {
        if (this.blobFile == null) {
            this.blobFile = this.toFile(this.lobDataId);
        }
        return this.blobFile.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        if (this.blobFile == null) {
            this.blobFile = this.toFile(this.lobDataId);
        }
        return this.blobFile.exists();
    }

    File toFile(Long id) {
        String idStr = id.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(this.rootDir);
        sb.append(File.separator);
        sb.append(this.tenantId);
        for (int i = idStr.length() - 1; i >= 0; --i) {
            sb.append(File.separator);
            sb.append(idStr.charAt(i));
        }
        sb.append(".dat");
        return new File(sb.toString());
    }

    private File createNewFile(Long newId) {
        File newFile = this.toFile(newId);
        File dir = newFile.getParentFile();
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new SystemException("can not create dir:" + dir.getAbsolutePath());
        }
        try {
            if (newFile.createNewFile()) {
                return newFile;
            }
            if (this.overwriteFile && newFile.exists()) {
                logger.warn("Lob file already exists. But overwrite File mode is ture, so continue process... file: " + newFile.toString());
                return newFile;
            }
            throw new SystemException("can not create file:" + newFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new SystemException("can not create file:" + newFile.getAbsolutePath() + ", cause " + e, e);
        }
    }

    @Override
    public void transferFrom(File file) throws IOException {
        Transaction t;
        if (this.blobFile == null) {
            this.blobFile = this.createNewFile(this.lobDataId);
        }
        if ((t = ServiceRegistry.getRegistry().getService(TransactionService.class).getTransacitonManager().currentTransaction()) != null && t.getStatus() == TransactionStatus.ACTIVE) {
            t.afterRollback(() -> {
                if (!this.blobFile.delete()) {
                    logger.warn("maybe can not delete file:" + this.blobFile.getAbsolutePath());
                }
            });
        }
        Files.copy(file.toPath(), this.blobFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private class FileBinaryDataInputStream
    extends InputStream {
        private FileInputStream wrapped;

        FileBinaryDataInputStream() {
            if (FileLobData.this.blobFile == null) {
                FileLobData.this.blobFile = FileLobData.this.toFile(FileLobData.this.lobDataId);
            }
            if (FileLobData.this.blobFile != null) {
                try {
                    this.wrapped = new FileInputStream(FileLobData.this.blobFile);
                }
                catch (FileNotFoundException e) {
                    logger.warn("can not find File of lobDataId:" + FileLobData.this.lobDataId + "(tenant=" + FileLobData.this.tenantId + "), so return empty data.");
                }
            }
        }

        @Override
        public int available() throws IOException {
            if (this.wrapped == null) {
                return 0;
            }
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            if (this.wrapped != null) {
                this.wrapped.close();
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            if (this.wrapped != null) {
                this.wrapped.mark(readlimit);
            }
        }

        @Override
        public boolean markSupported() {
            if (this.wrapped == null) {
                return false;
            }
            return this.wrapped.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.wrapped != null) {
                this.wrapped.reset();
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.wrapped == null) {
                return 0L;
            }
            return this.wrapped.skip(n);
        }

        @Override
        public int read() throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read();
        }
    }

    private class FileBinaryDataOutputStream
    extends OutputStream {
        private FileOutputStream wrapped;

        FileBinaryDataOutputStream() {
            if (FileLobData.this.blobFile == null) {
                FileLobData.this.blobFile = FileLobData.this.createNewFile(FileLobData.this.lobDataId);
            }
            try {
                this.wrapped = new FileOutputStream(FileLobData.this.blobFile);
            }
            catch (FileNotFoundException e) {
                throw new SystemException("can not open FileOutputStream:" + FileLobData.this.blobFile.getAbsolutePath(), e);
            }
            Transaction t = ServiceRegistry.getRegistry().getService(TransactionService.class).getTransacitonManager().currentTransaction();
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                t.afterRollback(() -> {
                    if (!FileLobData.this.blobFile.delete()) {
                        logger.warn("maybe can not delete file:" + FileLobData.this.blobFile.getAbsolutePath());
                    }
                });
            }
        }

        @Override
        public void close() throws IOException {
            if (this.wrapped != null) {
                try {
                    this.wrapped.flush();
                }
                finally {
                    this.wrapped.close();
                    this.wrapped = null;
                }
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.wrapped != null) {
                this.wrapped.flush();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.wrapped.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.wrapped.write(b);
        }
    }
}

