/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore.multi;

import java.util.List;
import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;
import org.iplass.mtp.spi.Config;

public class AddableMultiLobStore
implements LobStore {
    private List<LobStore> lobStore;
    private LobValidator lobValidator;

    public List<LobStore> getLobStore() {
        return this.lobStore;
    }

    public void setLobStore(List<LobStore> lobStore) {
        this.lobStore = lobStore;
    }

    @Override
    public void inited(LobStoreService service, Config config) {
        if (this.lobStore != null) {
            for (LobStore ls : this.lobStore) {
                ls.inited(service, config);
            }
        }
    }

    @Override
    public void destroyed() {
        if (this.lobStore != null) {
            for (LobStore ls : this.lobStore) {
                ls.destroyed();
            }
        }
    }

    @Override
    public LobData create(int tenantId, long lobDataId) {
        return this.lobStore.get(0).create(tenantId, lobDataId);
    }

    @Override
    public LobData load(int tenantId, long lobDataId) {
        LobData ld = null;
        if (this.lobStore != null) {
            for (int i = 0; i < this.lobStore.size(); ++i) {
                ld = this.lobStore.get(i).load(tenantId, lobDataId);
                if (i == this.lobStore.size() - 1) {
                    return ld;
                }
                if (ld == null || !ld.exists()) continue;
                return ld;
            }
        }
        return ld;
    }

    @Override
    public void remove(int tenantId, long lobDataId) {
        if (this.lobStore != null) {
            for (LobStore ls : this.lobStore) {
                ls.remove(tenantId, lobDataId);
            }
        }
    }

    @Override
    public LobValidator getLobValidator() {
        return this.lobValidator;
    }

    public void setLobValidator(LobValidator lobValidator) {
        this.lobValidator = lobValidator;
    }
}

