/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.sql;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class LobStoreSearchSql
extends QuerySqlHandler {
    public String toSql(int tenantId, long lobId, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_DATA_ID,REF_COUNT,B_DATA FROM LOB_STORE WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND LOB_DATA_ID=");
        sb.append(lobId);
        return sb.toString();
    }

    public Blob getBlob(ResultSet rs, RdbAdapter rdb) throws SQLException {
        if (rs.next()) {
            return rs.getBlob("B_DATA");
        }
        return null;
    }

    public InputStream getBinaryStream(ResultSet rs, RdbAdapter rdb) throws SQLException {
        if (rs.next()) {
            return rs.getBinaryStream("B_DATA");
        }
        return null;
    }

    public String toSqlForClean(int tenantId, int day, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_DATA_ID FROM LOB_STORE WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND REF_COUNT < 1");
        if (day < 0) {
            sb.append(" AND CRE_DATE < ").append(rdb.addDate(rdb.systimestamp(), day));
        }
        return sb.toString();
    }

    public String toSqlForSizeUpdate(int tenantId, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_DATA_ID FROM LOB_STORE WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND LOB_SIZE is null ");
        return sb.toString();
    }
}

