/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail.template;

import org.iplass.mtp.impl.mail.template.MetaHtmlBodyPart;
import org.iplass.mtp.impl.mail.template.MetaPlainTextBodyPart;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.mail.template.definition.LocalizedMailTemplateDefinition;

public class MetaLocalizedMailTemplate
implements MetaData {
    private static final long serialVersionUID = -3105621819550502509L;
    private String localeName;
    private String charset;
    private String subject;
    private MetaPlainTextBodyPart message;
    private MetaHtmlBodyPart htmlMessage;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MetaPlainTextBodyPart getMessage() {
        return this.message;
    }

    public void setMessage(MetaPlainTextBodyPart message) {
        this.message = message;
    }

    public MetaHtmlBodyPart getHtmlMessage() {
        return this.htmlMessage;
    }

    public void setHtmlMessage(MetaHtmlBodyPart htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public MetaLocalizedMailTemplate() {
    }

    public MetaLocalizedMailTemplate(String localeName, String stringValue) {
        this.localeName = localeName;
    }

    @Override
    public MetaLocalizedMailTemplate copy() {
        return ObjectUtil.deepCopy(this);
    }

    public void applyConfig(LocalizedMailTemplateDefinition definition) {
        this.localeName = definition.getLocaleName();
        this.charset = definition.getCharset();
        this.subject = definition.getSubject();
        if (definition.getPlainMessage() != null) {
            this.message = new MetaPlainTextBodyPart();
            this.message.setContent(definition.getPlainMessage().getContent());
        } else {
            this.message = null;
        }
        if (definition.getHtmlMessage() != null) {
            this.htmlMessage = new MetaHtmlBodyPart();
            this.htmlMessage.setContent(definition.getHtmlMessage().getContent());
            this.htmlMessage.setCharset(definition.getHtmlMessage().getCharset());
        } else {
            this.htmlMessage = null;
        }
    }

    public LocalizedMailTemplateDefinition currentConfig() {
        LocalizedMailTemplateDefinition definition = new LocalizedMailTemplateDefinition();
        definition.setLocaleName(this.getLocaleName());
        definition.setSubject(this.subject);
        definition.setCharset(this.charset);
        definition.setPlainMessage(this.message.currentConfig());
        definition.setHtmlMessage(this.htmlMessage.currentConfig());
        return definition;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public void setLocaleName(String localeName) {
        this.localeName = localeName;
    }
}

