/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.message.MessageItem;

public class MetaMessageItem
implements Serializable {
    private static final long serialVersionUID = -464261717351843618L;
    private String messageId;
    private String message;
    private List<MetaLocalizedString> localizedMessageList = new ArrayList<MetaLocalizedString>();

    public MetaMessageItem copy() {
        return ObjectUtil.deepCopy(this);
    }

    public void setValue(MessageItem messageItem) {
        this.messageId = messageItem.getMessageId();
        this.message = messageItem.getMessage();
        this.localizedMessageList = I18nUtil.toMeta(messageItem.getLocalizedMessageList());
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public MessageItem createMessageItem() {
        MessageItem ret = new MessageItem();
        this.setMessageItem(ret);
        return ret;
    }

    protected void setMessageItem(MessageItem messageItem) {
        messageItem.setMessage(this.message);
        messageItem.setMessageId(this.messageId);
        messageItem.setLocalizedMessageList(I18nUtil.toDef(this.localizedMessageList));
    }

    public List<MetaLocalizedString> getLocalizedMessageList() {
        return this.localizedMessageList;
    }

    public void setLocalizedMessageList(List<MetaLocalizedString> localizedMessageList) {
        this.localizedMessageList = localizedMessageList;
    }
}

