/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.rdb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.iplass.mtp.impl.metadata.AbstractXmlMetaDataStore;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataEntryThinWrapper;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.rdb.DeleteSQL;
import org.iplass.mtp.impl.metadata.rdb.InsertSQL;
import org.iplass.mtp.impl.metadata.rdb.SelectSQL;
import org.iplass.mtp.impl.metadata.rdb.UpdateConfigSQL;
import org.iplass.mtp.impl.metadata.rdb.UpdateSQL;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbMetaDataStore
extends AbstractXmlMetaDataStore {
    private static Logger logger = LoggerFactory.getLogger(RdbMetaDataStore.class);
    private RdbAdapter rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
    private SelectSQL select = this.rdb.getQuerySqlCreator(SelectSQL.class);
    private UpdateSQL update = this.rdb.getUpdateSqlCreator(UpdateSQL.class);
    private UpdateConfigSQL updateConfig = this.rdb.getUpdateSqlCreator(UpdateConfigSQL.class);
    private DeleteSQL delete = this.rdb.getUpdateSqlCreator(DeleteSQL.class);
    private InsertSQL insert = this.rdb.getUpdateSqlCreator(InsertSQL.class);
    private boolean useObjDefNameAndType;
    private boolean declareTransactionExplicitly = true;

    public boolean isDeclareTransactionExplicitly() {
        return this.declareTransactionExplicitly;
    }

    public void setDeclareTransactionExplicitly(boolean declareTransactionExplicitly) {
        this.declareTransactionExplicitly = declareTransactionExplicitly;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        return this.loadById(tenantId, id, -1);
    }

    @Override
    public MetaDataEntry loadById(final int tenantId, final String id, final int version) {
        SqlExecuter<MetaDataEntry> exec = new SqlExecuter<MetaDataEntry>(){

            @Override
            public MetaDataEntry logic() throws SQLException {
                MetaDataEntry ret;
                String sql = RdbMetaDataStore.this.select.createLoadByIdSQL(version);
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setLoadByIdParameter(RdbMetaDataStore.this.rdb, ps, tenantId, id, version);
                try (ResultSet rs = ps.executeQuery();){
                    ret = RdbMetaDataStore.this.select.createLoadResultData(RdbMetaDataStore.this.rdb, rs, RdbMetaDataStore.this.context);
                    if (ret != null && ret.getMetaData() == null) {
                        logger.warn("Cannot unmarshal metadata from Rdb. id:" + id + ", version:" + version);
                    }
                }
                return ret;
            }
        };
        MetaDataEntry metaData = this.withTransactionOrNot(exec);
        return metaData;
    }

    private <R> R withTransactionOrNot(SqlExecuter<R> exec) {
        if (this.declareTransactionExplicitly) {
            return (R)Transaction.required(t -> exec.execute(this.rdb, true));
        }
        return exec.execute(this.rdb, true);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(final int tenantId, final String prefixPath, final boolean withInvalid) throws MetaDataRuntimeException {
        SqlExecuter<List<MetaDataEntryInfo>> exec = new SqlExecuter<List<MetaDataEntryInfo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MetaDataEntryInfo> logic() throws SQLException {
                List<MetaDataEntryInfo> ret;
                String sql = RdbMetaDataStore.this.select.createNodeListSQL(RdbMetaDataStore.this.rdb, prefixPath, withInvalid);
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setNodeListParameter(RdbMetaDataStore.this.rdb, ps, tenantId, prefixPath);
                try (ResultSet rs = ps.executeQuery();){
                    ret = RdbMetaDataStore.this.select.createNodeListResultData(rs, RdbMetaDataStore.this.rdb);
                }
                return ret;
            }
        };
        return this.withTransactionOrNot(exec);
    }

    @Override
    public void destroyed() {
        super.destroyed();
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        super.inited(service, config);
        if (config.getValue("useObjDefNameAndType") != null) {
            this.useObjDefNameAndType = config.getValue("useObjDefNameAndType").equalsIgnoreCase("true");
        }
    }

    private MetaDataEntry loadInternal(final int tenantId, final String path, final int version) {
        SqlExecuter<MetaDataEntry> exec = new SqlExecuter<MetaDataEntry>(){

            @Override
            public MetaDataEntry logic() throws SQLException {
                MetaDataEntry ret;
                String sql = RdbMetaDataStore.this.select.createLoadSQL(version);
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setLoadParameter(RdbMetaDataStore.this.rdb, ps, tenantId, path, version);
                try (ResultSet rs = ps.executeQuery();){
                    ret = RdbMetaDataStore.this.select.createLoadResultData(RdbMetaDataStore.this.rdb, rs, RdbMetaDataStore.this.context);
                    if (ret != null && ret.getMetaData() == null) {
                        logger.warn("Cannot unmarshal metadata from Rdb. path:" + path + ", version:" + version);
                    }
                }
                return ret;
            }
        };
        MetaDataEntry metaData = this.withTransactionOrNot(exec);
        return metaData;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) throws MetaDataRuntimeException {
        int version = -1;
        return this.loadInternal(tenantId, path, -1);
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        return this.loadInternal(tenantId, path, version);
    }

    private int getStoreVersion(final int tenantId, final MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer logic() throws SQLException {
                String sql = RdbMetaDataStore.this.select.createDataCountSQL(false);
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setDataCountParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataEntry.getMetaData());
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    count = RdbMetaDataStore.this.select.getDataCountResultData(rs);
                }
                int maxVersion = -1;
                if (count > 0) {
                    sql = RdbMetaDataStore.this.select.createMaxVersionSQL();
                    ps = this.getPreparedStatement(sql);
                    RdbMetaDataStore.this.select.setMaxVersionParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataEntry.getMetaData());
                    rs = ps.executeQuery();
                    try {
                        maxVersion = RdbMetaDataStore.this.select.getMaxVersionResultData(rs);
                        if (maxVersion < 0) {
                            maxVersion = -1;
                        }
                    }
                    finally {
                        rs.close();
                    }
                    if (maxVersion >= 0) {
                        sql = RdbMetaDataStore.this.select.createDataCountSQL(true);
                        ps = this.getPreparedStatement(sql);
                        RdbMetaDataStore.this.select.setDataCountParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataEntry.getMetaData());
                        rs = ps.executeQuery();
                        int validCount = 0;
                        try {
                            validCount = RdbMetaDataStore.this.select.getDataCountResultData(rs);
                            if (validCount > 0) {
                                throw new MetaDataRuntimeException("Registered metadata already exists. path=" + metaDataEntry.getPath());
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                }
                return maxVersion + 1;
            }
        };
        return this.withTransactionOrNot(exec);
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        int ver = this.getStoreVersion(tenantId, metaDataEntry);
        this.storeImpl(tenantId, metaDataEntry, ver, false);
    }

    private void storeImpl(final int tenantId, final MetaDataEntry metaDataEntry, final int asVersion, final boolean isUpdate) throws MetaDataRuntimeException {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                Throwable throwable;
                byte[] metaData;
                Blob blob;
                String sql;
                MetaDataEntryInfo info;
                block104: {
                    Marshaller marshaller3;
                    OutputStream os;
                    PreparedStatement ps;
                    Object rs;
                    info = null;
                    sql = RdbMetaDataStore.this.select.createGetMetadataInfoSQL(RdbMetaDataStore.this.rdb, false);
                    try (PreparedStatement ps2 = this.getPreparedStatement(sql);){
                        ps2.setFetchSize(1);
                        RdbMetaDataStore.this.select.setGetMetadataInfoParameter(RdbMetaDataStore.this.rdb, ps2, tenantId, metaDataEntry.getMetaData().getId());
                        rs = ps2.executeQuery();
                        Throwable throwable2 = null;
                        try {
                            if (rs.next()) {
                                info = RdbMetaDataStore.this.select.createMetaDataEntryInfo((ResultSet)rs, RdbMetaDataStore.this.rdb);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rs != null) {
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    if (!isUpdate && info != null && info.getState() == MetaDataEntry.State.VALID) {
                        throw new MetaDataRuntimeException("MetaData:" + metaDataEntry.getPath() + "(id=" + metaDataEntry.getMetaData().getId() + ") is already exist.");
                    }
                    boolean withPathChange = false;
                    if (info != null && !info.getPath().equals(metaDataEntry.getPath())) {
                        withPathChange = true;
                    }
                    if (withPathChange) {
                        sql = RdbMetaDataStore.this.update.createUpdateWithPathSQL(RdbMetaDataStore.this.rdb);
                        ps = this.getPreparedStatement(sql);
                        rs = null;
                        try {
                            RdbMetaDataStore.this.update.setUpdateWithPathParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataEntry.getMetaData().getId(), metaDataEntry.getPath());
                            ps.executeUpdate();
                        }
                        catch (Throwable throwable5) {
                            rs = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (ps != null) {
                                if (rs != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable6) {
                                        ((Throwable)rs).addSuppressed(throwable6);
                                    }
                                } else {
                                    ps.close();
                                }
                            }
                        }
                    }
                    if (info != null && info.getState() == MetaDataEntry.State.VALID) {
                        sql = RdbMetaDataStore.this.update.createUpdateSQL(RdbMetaDataStore.this.rdb);
                        ps = this.getPreparedStatement(sql);
                        rs = null;
                        try {
                            RdbMetaDataStore.this.update.setUpdateParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataEntry.getMetaData().getId());
                            ps.executeUpdate();
                        }
                        catch (Throwable throwable7) {
                            rs = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (ps != null) {
                                if (rs != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable8) {
                                        ((Throwable)rs).addSuppressed(throwable8);
                                    }
                                } else {
                                    ps.close();
                                }
                            }
                        }
                    }
                    blob = null;
                    metaData = null;
                    if (RdbMetaDataStore.this.rdb.isSupportBlobType()) {
                        blob = this.getConnection().createBlob();
                        try {
                            os = blob.setBinaryStream(1L);
                            throwable = null;
                            try {
                                marshaller3 = RdbMetaDataStore.this.context.createMarshaller();
                                marshaller3.marshal((Object)new MetaDataEntryThinWrapper(metaDataEntry.getMetaData()), os);
                                break block104;
                            }
                            catch (Throwable marshaller2) {
                                throwable = marshaller2;
                                throw marshaller2;
                            }
                            finally {
                                if (os != null) {
                                    if (throwable != null) {
                                        try {
                                            os.close();
                                        }
                                        catch (Throwable marshaller2) {
                                            throwable.addSuppressed(marshaller2);
                                        }
                                    } else {
                                        os.close();
                                    }
                                }
                            }
                        }
                        catch (JAXBException e) {
                            throw new SQLException("Marshal\u306b\u5931\u6557", e);
                        }
                        catch (IOException e) {
                            throw new SQLException("Marshall\u306b\u5931\u6557", e);
                        }
                    }
                    try {
                        os = new ByteArrayOutputStream();
                        throwable = null;
                        try {
                            marshaller3 = RdbMetaDataStore.this.context.createMarshaller();
                            marshaller3.marshal((Object)new MetaDataEntryThinWrapper(metaDataEntry.getMetaData()), os);
                            metaData = ((ByteArrayOutputStream)os).toByteArray();
                        }
                        catch (Throwable marshaller3) {
                            throwable = marshaller3;
                            throw marshaller3;
                        }
                        finally {
                            if (os != null) {
                                if (throwable != null) {
                                    try {
                                        ((ByteArrayOutputStream)os).close();
                                    }
                                    catch (Throwable marshaller3) {
                                        throwable.addSuppressed(marshaller3);
                                    }
                                } else {
                                    ((ByteArrayOutputStream)os).close();
                                }
                            }
                        }
                    }
                    catch (JAXBException e) {
                        throw new SQLException("Marshal\u306b\u5931\u6557", e);
                    }
                    catch (IOException e) {
                        throw new SQLException("Marshall\u306b\u5931\u6557", e);
                    }
                }
                sql = RdbMetaDataStore.this.insert.createStoreSQL(RdbMetaDataStore.this.rdb, RdbMetaDataStore.this.useObjDefNameAndType);
                throwable = null;
                try (PreparedStatement ps = this.getPreparedStatement(sql);){
                    int newVersion = 0;
                    if (asVersion >= 0) {
                        newVersion = asVersion;
                    } else if (info != null) {
                        newVersion = info.getVersion() + 1;
                    }
                    if (RdbMetaDataStore.this.rdb.isSupportBlobType()) {
                        RdbMetaDataStore.this.insert.setStoreParameter(RdbMetaDataStore.this.rdb, ps, tenantId, newVersion, metaDataEntry.getMetaData(), metaDataEntry.getPath(), blob, metaDataEntry.isSharable(), metaDataEntry.isDataSharable(), metaDataEntry.isPermissionSharable(), metaDataEntry.isOverwritable(), RdbMetaDataStore.this.useObjDefNameAndType);
                    } else {
                        RdbMetaDataStore.this.insert.setStoreParameter(RdbMetaDataStore.this.rdb, ps, tenantId, newVersion, metaDataEntry.getMetaData(), metaDataEntry.getPath(), metaData, metaDataEntry.isSharable(), metaDataEntry.isDataSharable(), metaDataEntry.isPermissionSharable(), metaDataEntry.isOverwritable(), RdbMetaDataStore.this.useObjDefNameAndType);
                    }
                    ps.executeUpdate();
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                if (blob != null) {
                    blob.free();
                }
                return null;
            }
        };
        this.withTransactionOrNot(exec);
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.storeImpl(tenantId, metaDataEntry, -1, true);
    }

    @Override
    public void remove(final int tenantId, final String path) throws MetaDataRuntimeException {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                MetaDataEntry meta = RdbMetaDataStore.this.load(tenantId, path);
                if (meta == null) {
                    throw new MetaDataRuntimeException("No metaData found.path=" + path);
                }
                String sql = RdbMetaDataStore.this.update.createUpdateSQL(RdbMetaDataStore.this.rdb);
                try (PreparedStatement ps = this.getPreparedStatement(sql);){
                    RdbMetaDataStore.this.update.setUpdateParameter(RdbMetaDataStore.this.rdb, ps, tenantId, meta.getMetaData().getId());
                    int delCount = ps.executeUpdate();
                    if (delCount < 1) {
                        throw new SQLException("Delete faied. update count=" + delCount);
                    }
                }
                return null;
            }
        };
        this.withTransactionOrNot(exec);
    }

    @Override
    public void updateConfigById(final int tenantId, final String id, final MetaDataConfig config) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String sql = RdbMetaDataStore.this.updateConfig.createUpdateSQL(RdbMetaDataStore.this.rdb);
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.updateConfig.setUpdateParameter(RdbMetaDataStore.this.rdb, ps, tenantId, id, config.isSharable(), config.isDataSharable(), config.isPermissionSharable(), config.isOverwritable());
                int ret = ps.executeUpdate();
                if (ret != 1) {
                    throw new SQLException("updateConfig failed. id=" + id + ",upate counts=" + ret);
                }
                return null;
            }
        };
        this.withTransactionOrNot(exec);
    }

    @Override
    public List<Integer> getTenantIdsOf(final String id) {
        SqlExecuter<List<Integer>> exec = new SqlExecuter<List<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Integer> logic() throws SQLException {
                String sql = RdbMetaDataStore.this.select.createTenantIdListSQL();
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setTenantIdListParameter(RdbMetaDataStore.this.rdb, ps, id);
                try (ResultSet rs = ps.executeQuery();){
                    List<Integer> list = RdbMetaDataStore.this.select.getTenantIdListResultData(rs);
                    return list;
                }
            }
        };
        return this.withTransactionOrNot(exec);
    }

    @Override
    public void purgeById(final int tenantId, final String id) throws MetaDataRuntimeException {
        Transaction.required(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                @Override
                public Void logic() throws SQLException {
                    String sql = RdbMetaDataStore.this.delete.createPurgeByIdSQL();
                    PreparedStatement ps = this.getPreparedStatement(sql);
                    RdbMetaDataStore.this.delete.setPurgeByIdParameter(RdbMetaDataStore.this.rdb, ps, tenantId, id);
                    int delCount = ps.executeUpdate();
                    if (delCount <= 0) {
                        logger.warn("purge meta data, but no record deleted. tenant id = " + tenantId + ",defId = " + id);
                    }
                    return null;
                }
            };
            this.withTransactionOrNot(exec);
        });
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(final int tenantId, final String metaDataId) throws MetaDataRuntimeException {
        SqlExecuter<List<MetaDataEntryInfo>> exec = new SqlExecuter<List<MetaDataEntryInfo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MetaDataEntryInfo> logic() throws SQLException {
                List<MetaDataEntryInfo> ret;
                String sql = RdbMetaDataStore.this.select.createMetaHistorySQL();
                PreparedStatement ps = this.getPreparedStatement(sql);
                RdbMetaDataStore.this.select.setMetaHistoryParameter(RdbMetaDataStore.this.rdb, ps, tenantId, metaDataId);
                try (ResultSet rs = ps.executeQuery();){
                    ret = RdbMetaDataStore.this.select.createNodeListResultData(rs, RdbMetaDataStore.this.rdb);
                }
                return ret;
            }
        };
        return this.withTransactionOrNot(exec);
    }
}

