/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.rdb;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataEntryThinWrapper;
import org.iplass.mtp.impl.metadata.MetaDataRepositoryKind;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.metadata.rdb.UpdateConfigSQL;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSQL
extends QuerySqlHandler {
    private static Logger logger = LoggerFactory.getLogger(SelectSQL.class);
    private static final String META_DATA_ENTRY_INFO_SELECT = "SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META";
    private static final String META_DATA_LOAD_SELECT = "SELECT OBJ_DEF_VER ,OBJ_DEF_PATH ,OBJ_META_DATA ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER FROM OBJ_META";

    public String createGetMetadataInfoSQL(RdbAdapter rdb, boolean onlyValid) {
        if (onlyValid) {
            return "SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META WHERE TENANT_ID=?  AND OBJ_DEF_ID=?  AND STATUS='V'  ORDER BY OBJ_DEF_VER DESC";
        }
        return "SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META WHERE TENANT_ID=?  AND OBJ_DEF_ID=?  ORDER BY OBJ_DEF_VER DESC ";
    }

    public void setGetMetadataInfoParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String metaDataId) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, metaDataId);
    }

    public String createNodeListSQL(RdbAdapter rdb, String prefixPath, boolean withInvalid) {
        StringBuilder sb = new StringBuilder();
        if (withInvalid) {
            sb.append("SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META a WHERE TENANT_ID=?  AND OBJ_DEF_VER=(SELECT MAX(OBJ_DEF_VER) FROM OBJ_META WHERE TENANT_ID=a.TENANT_ID AND OBJ_DEF_ID=a.OBJ_DEF_ID)");
        } else {
            sb.append("SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META WHERE TENANT_ID=?  AND STATUS='V'");
        }
        if (prefixPath != null) {
            sb.append(" AND OBJ_DEF_PATH LIKE ? ").append(rdb.escape());
        }
        return sb.toString();
    }

    public void setNodeListParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String prefixPath) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        if (prefixPath != null) {
            ps.setString(num++, rdb.sanitizeForLike(prefixPath) + "%");
        }
    }

    public List<MetaDataEntryInfo> createNodeListResultData(ResultSet rs, RdbAdapter rdb) throws SQLException {
        ArrayList<MetaDataEntryInfo> result = null;
        while (rs.next()) {
            if (result == null) {
                result = new ArrayList<MetaDataEntryInfo>();
            }
            result.add(this.createMetaDataEntryInfo(rs, rdb));
        }
        return result == null ? Collections.emptyList() : result;
    }

    public MetaDataEntryInfo createMetaDataEntryInfo(ResultSet rs, RdbAdapter rdb) throws SQLException {
        MetaDataEntryInfo node = new MetaDataEntryInfo();
        int num = 1;
        node.setId(rs.getString(num++));
        node.setPath(rs.getString(num++));
        node.setDisplayName(rs.getString(num++));
        node.setDescription(rs.getString(num++));
        node.setRepository(MetaDataRepositoryKind.RDB.getDisplayName());
        boolean[] booleanShare = UpdateConfigSQL.toBooleanShare(rs.getString(num++));
        node.setSharable(booleanShare[0]);
        node.setDataSharable(booleanShare[1]);
        node.setPermissionSharable(booleanShare[2]);
        node.setOverwritable(UpdateConfigSQL.toBooleanOverwrite(rs.getString(num++)));
        node.setVersion(rs.getInt(num++));
        String stateStr = rs.getString(num++);
        if ("V".equals(stateStr)) {
            node.setState(MetaDataEntry.State.VALID);
        } else {
            node.setState(MetaDataEntry.State.INVALID);
        }
        node.setCreateDate(rs.getTimestamp(num++, rdb.rdbCalendar()));
        node.setUpdateDate(rs.getTimestamp(num++, rdb.rdbCalendar()));
        node.setCreateUser(rs.getString(num++));
        node.setUpdateUser(rs.getString(num++));
        return node;
    }

    public String createLoadSQL(int version) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT OBJ_DEF_VER ,OBJ_DEF_PATH ,OBJ_META_DATA ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER FROM OBJ_META WHERE TENANT_ID = ?  AND OBJ_DEF_PATH = ? ");
        if (version < 0) {
            sb.append(" AND STATUS = 'V' ");
        } else {
            sb.append(" AND OBJ_DEF_VER = ? ");
        }
        sb.append(" ORDER BY UP_DATE DESC");
        return sb.toString();
    }

    public void setLoadParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String path, int version) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        ps.setString(num++, path);
        if (version >= 0) {
            ps.setInt(num++, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataEntry createLoadResultData(RdbAdapter rdb, ResultSet rs, JAXBContext context) throws SQLException, JAXBException {
        if (rs.next()) {
            Blob xmlData = null;
            InputStream is = null;
            try {
                if (rdb.isSupportBlobType()) {
                    xmlData = rs.getBlob(3);
                }
                MetaDataEntry instance = new MetaDataEntry();
                Unmarshaller unmarshaller = context.createUnmarshaller();
                is = rdb.isSupportBlobType() ? xmlData.getBinaryStream() : rs.getBinaryStream(3);
                MetaDataEntryThinWrapper meta = (MetaDataEntryThinWrapper)unmarshaller.unmarshal(is);
                instance.setMetaData(meta.getMetaData());
                instance.setVersion(rs.getInt(1));
                instance.setState(MetaDataEntry.State.VALID);
                instance.setPath(rs.getString(2));
                boolean[] booleanShare = UpdateConfigSQL.toBooleanShare(rs.getString(4));
                instance.setSharable(booleanShare[0]);
                instance.setDataSharable(booleanShare[1]);
                instance.setPermissionSharable(booleanShare[2]);
                instance.setOverwritable(UpdateConfigSQL.toBooleanOverwrite(rs.getString(5)));
                instance.setVersion(rs.getInt(6));
                MetaDataEntry metaDataEntry = instance;
                return metaDataEntry;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.warn("can not close inputstream resource:" + is, (Throwable)e);
                    }
                }
                if (xmlData != null) {
                    xmlData.free();
                }
            }
        }
        return null;
    }

    public String createLoadByIdSQL(int version) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT OBJ_DEF_VER ,OBJ_DEF_PATH ,OBJ_META_DATA ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER FROM OBJ_META WHERE TENANT_ID = ?  AND OBJ_DEF_ID = ? ");
        if (version < 0) {
            sb.append(" AND STATUS = 'V' ");
        } else {
            sb.append(" AND OBJ_DEF_VER = ? ");
        }
        return sb.toString();
    }

    public void setLoadByIdParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String id, int version) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        ps.setString(num++, id);
        if (version >= 0) {
            ps.setInt(num++, version);
        }
    }

    public String createMaxVersionSQL() {
        return "SELECT MAX(OBJ_DEF_VER)  FROM OBJ_META WHERE TENANT_ID = ?  AND OBJ_DEF_ID = ? ";
    }

    public void setMaxVersionParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, RootMetaData metaData) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        ps.setString(num++, metaData.getId());
    }

    public int getMaxVersionResultData(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    public String createDataCountSQL(boolean validOnly) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(OBJ_DEF_ID)  FROM OBJ_META WHERE TENANT_ID = ?  AND OBJ_DEF_ID = ? ");
        if (validOnly) {
            sb.append(" AND STATUS = 'V' ");
        }
        return sb.toString();
    }

    public void setDataCountParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, RootMetaData metaData) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        ps.setString(num++, metaData.getId());
    }

    public int getDataCountResultData(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public String createTenantIdListSQL() {
        return "SELECT TENANT_ID FROM OBJ_META WHERE OBJ_DEF_ID = ?  AND STATUS = 'V'";
    }

    public void setTenantIdListParameter(RdbAdapter rdb, PreparedStatement ps, String metaDataId) throws SQLException {
        int num = 1;
        ps.setString(num++, metaDataId);
    }

    public List<Integer> getTenantIdListResultData(ResultSet rs) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(rs.getInt(1));
        }
        return list;
    }

    public String createMetaHistorySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT OBJ_DEF_ID ,OBJ_DEF_PATH ,OBJ_DEF_DISP_NAME ,OBJ_DESC ,SHARABLE ,OVERWRITABLE ,OBJ_DEF_VER ,STATUS ,CRE_DATE ,UP_DATE ,CRE_USER ,UP_USER FROM OBJ_META WHERE TENANT_ID = ?  AND OBJ_DEF_ID = ?  ORDER BY OBJ_DEF_VER DESC ");
        return sb.toString();
    }

    public void setMetaHistoryParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String path) throws SQLException {
        int num = 1;
        ps.setInt(num++, tenantId);
        ps.setString(num++, path);
    }
}

