/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.parser;

import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseException;

public class ParseContext {
    public static char[] WHITE_SPACES = new char[]{' ', '\t', '\n', '\r', '\f', '\b'};
    public static char[] TOKEN_DELIMITERS = new char[]{' ', '\t', '\n', '\r', '\f', '\b', '(', ')', '[', ']', ',', '+', '-', '*', '/', '=', '!', '>', '<'};
    private String stream;
    private int currentIndex;
    private int offset;

    public ParseContext() {
    }

    public ParseContext(String stream) {
        this.stream = stream;
    }

    ParseContext(String stream, int offset) {
        this(stream);
        this.offset = offset;
    }

    public int totalCurrentIndex() {
        return this.currentIndex + this.offset;
    }

    public void reset(String stream) {
        this.stream = stream;
        this.currentIndex = 0;
        this.offset = 0;
    }

    public void setCurrentIndex(int currentIndex) throws ParseException {
        if (currentIndex < 0 || currentIndex > this.stream.length()) {
            throw new ParseException(new EvalError("stream is end.", null, this));
        }
        this.currentIndex = currentIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getLength() {
        return this.stream.length();
    }

    public char peekChar() {
        if (this.currentIndex >= this.stream.length()) {
            return '\u0000';
        }
        return this.stream.charAt(this.currentIndex);
    }

    public char popChar() {
        if (this.currentIndex == this.stream.length()) {
            return '\u0000';
        }
        char res = this.stream.charAt(this.currentIndex);
        ++this.currentIndex;
        return res;
    }

    public void pushBack() throws IndexOutOfBoundsException {
        if (this.currentIndex == 0) {
            throw new StringIndexOutOfBoundsException("already top of stream");
        }
        --this.currentIndex;
    }

    public boolean isEnd() {
        return this.currentIndex == this.stream.length();
    }

    public ParseContext subContext(int begin, int end) throws IndexOutOfBoundsException {
        return new ParseContext(this.stream.substring(begin, end), this.offset + begin);
    }

    public int indexOf(char c) {
        for (int i = this.currentIndex; i < this.stream.length(); ++i) {
            if (c != this.stream.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int i = this.stream.length() - 1; i >= this.currentIndex; --i) {
            if (c != this.stream.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean consumeChars(char[] ignores) {
        char c;
        boolean isConsume = false;
        while (!this.isEnd() && this.isContains(c = this.peekChar(), ignores)) {
            this.popChar();
            isConsume = true;
        }
        return isConsume;
    }

    public boolean consumeChars(int length) throws ParseException {
        this.setCurrentIndex(this.getCurrentIndex() + length);
        return true;
    }

    private boolean isContains(char c, char[] checkChars) {
        for (int i = 0; i < checkChars.length; ++i) {
            if (c != checkChars[i]) continue;
            return true;
        }
        return false;
    }

    public String nextToken(char[] delimiters) {
        int endIndex;
        int beginIndex = this.getCurrentIndex();
        while (!this.isEnd()) {
            char c = this.popChar();
            if (!this.isContains(c, delimiters)) continue;
            this.pushBack();
            break;
        }
        if (beginIndex < (endIndex = this.getCurrentIndex())) {
            return this.stream.substring(beginIndex, endIndex);
        }
        return null;
    }

    public String innerToken(char delimiter, boolean withDoubleDelimierEscape) {
        char del1 = this.popChar();
        if (del1 != delimiter) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.isEnd()) {
                return null;
            }
            char c = this.popChar();
            if (c == delimiter) {
                if (!withDoubleDelimierEscape || this.peekChar() != delimiter) break;
                this.popChar();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean startsWith(String prefix) {
        return this.stream.startsWith(prefix, this.currentIndex);
    }

    public boolean equalsNextToken(String expectedToken, char[] delimiters) throws ParseException {
        int i = this.getCurrentIndex();
        String token = this.nextToken(delimiters);
        this.setCurrentIndex(i);
        return expectedToken.equalsIgnoreCase(token);
    }

    public String toString() {
        return this.stream.toString();
    }
}

