/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.parser.SyntaxRegister;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class SyntaxService
implements Service {
    private Map<String, SyntaxContext> contexts;

    public SyntaxContext getSyntaxContext(String contextName) {
        return this.contexts.get(contextName);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        this.contexts = new HashMap<String, SyntaxContext>();
        List<String> registList = config.getValues("syntaxRegister");
        for (String r : registList) {
            SyntaxRegister sr;
            try {
                sr = (SyntaxRegister)Class.forName(r).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("SyntaxRegister not found.", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("SyntaxRegister can not instantiate.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("SyntaxRegister can not instantiate.", e);
            }
            this.contexts.put(sr.getContextName(), new SyntaxContext(sr.getSyntax()));
        }
    }
}

