/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;

public class PropertySerializeUtil {
    public static final byte NULL = 0;
    public static final byte AUTONUMBER = 1;
    @Deprecated
    public static final byte BINARY_OLD = 2;
    public static final byte BINARY = 15;
    public static final byte BOOLEAN = 3;
    public static final byte DATE = 4;
    public static final byte DATETIME = 5;
    public static final byte DECIMAL = 6;
    public static final byte EXPRESSION = 7;
    public static final byte FLOAT = 8;
    public static final byte INTEGER = 9;
    public static final byte LONGTEXT = 10;
    public static final byte REFERENCE = 11;
    public static final byte SELECT = 12;
    public static final byte STRING = 13;
    public static final byte TIME = 14;
    public static final byte ARRAY_MASK = 64;
    public static final byte NULL_ARRAY = 64;
    public static final byte AUTONUMBER_ARRAY = 65;
    @Deprecated
    public static final byte BINARY_ARRAY_OLD = 66;
    public static final byte BINARY_ARRAY = 79;
    public static final byte BOOLEAN_ARRAY = 67;
    public static final byte DATE_ARRAY = 68;
    public static final byte DATETIME_ARRAY = 69;
    public static final byte DECIMAL_ARRAY = 70;
    public static final byte EXPRESSION_ARRAY = 71;
    public static final byte FLOAT_ARRAY = 72;
    public static final byte INTEGER_ARRAY = 73;
    public static final byte LONGTEXT_ARRAY = 74;
    public static final byte REFERENCE_ARRAY = 75;
    public static final byte SELECT_ARRAY = 76;
    public static final byte STRING_ARRAY = 77;
    public static final byte TIME_ARRAY = 78;
    private static final Map<Class<?>, Byte> typeMap;

    public static byte typeOf(PropertyDefinitionType pdType) {
        switch (pdType) {
            case AUTONUMBER: {
                return 1;
            }
            case BINARY: {
                return 15;
            }
            case BOOLEAN: {
                return 3;
            }
            case DATE: {
                return 4;
            }
            case DATETIME: {
                return 5;
            }
            case DECIMAL: {
                return 6;
            }
            case FLOAT: {
                return 8;
            }
            case INTEGER: {
                return 9;
            }
            case LONGTEXT: {
                return 10;
            }
            case REFERENCE: {
                return 11;
            }
            case SELECT: {
                return 12;
            }
            case STRING: {
                return 13;
            }
            case TIME: {
                return 14;
            }
            case EXPRESSION: {
                return 7;
            }
        }
        throw new IllegalArgumentException("not support type:" + (Object)((Object)pdType));
    }

    public static Object read(DataInput is) throws IOException {
        byte dt = is.readByte();
        switch (dt) {
            case 0: {
                return null;
            }
            case 2: {
                return new BinaryReference(is.readLong(), null, null, 0L);
            }
            case 15: {
                long lobId = is.readLong();
                dt = is.readByte();
                if (dt == 0) {
                    return new BinaryReference(lobId, null, null, 0L);
                }
                return new BinaryReference(lobId, is.readUTF(), null, 0L);
            }
            case 3: {
                return is.readBoolean();
            }
            case 4: {
                return new Date(is.readLong());
            }
            case 5: {
                Timestamp ts = new Timestamp(is.readLong());
                ts.setNanos(is.readInt());
                return ts;
            }
            case 6: {
                return new BigDecimal(is.readUTF());
            }
            case 8: {
                return is.readDouble();
            }
            case 9: {
                return is.readLong();
            }
            case 12: {
                String val = is.readUTF();
                byte ddt = is.readByte();
                if (ddt == 0) {
                    return new SelectValue(val);
                }
                return new SelectValue(val, is.readUTF());
            }
            case 13: {
                return is.readUTF();
            }
            case 14: {
                return new Time(is.readLong());
            }
            case 77: {
                int length = is.readInt();
                String[] strArray = new String[length];
                for (int i = 0; i < strArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 13) continue;
                    strArray[i] = is.readUTF();
                }
                return strArray;
            }
            case 73: {
                int length = is.readInt();
                Long[] longArray = new Long[length];
                for (int i = 0; i < longArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 9) continue;
                    longArray[i] = is.readLong();
                }
                return longArray;
            }
            case 72: {
                int length = is.readInt();
                Double[] doubleArray = new Double[length];
                for (int i = 0; i < doubleArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 8) continue;
                    doubleArray[i] = is.readDouble();
                }
                return doubleArray;
            }
            case 76: {
                int length = is.readInt();
                SelectValue[] selectArray = new SelectValue[length];
                for (int i = 0; i < selectArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 12) continue;
                    selectArray[i] = new SelectValue(is.readUTF());
                    if (is.readByte() == 0) continue;
                    selectArray[i].setDisplayName(is.readUTF());
                }
                return selectArray;
            }
            case 69: {
                int length = is.readInt();
                Timestamp[] tsArray = new Timestamp[length];
                for (int i = 0; i < tsArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 5) continue;
                    tsArray[i] = new Timestamp(is.readLong());
                    tsArray[i].setNanos(is.readInt());
                }
                return tsArray;
            }
            case 68: {
                int length = is.readInt();
                Date[] dateArray = new Date[length];
                for (int i = 0; i < dateArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 4) continue;
                    dateArray[i] = new Date(is.readLong());
                }
                return dateArray;
            }
            case 67: {
                int length = is.readInt();
                Boolean[] boolArray = new Boolean[length];
                for (int i = 0; i < boolArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 3) continue;
                    boolArray[i] = is.readBoolean();
                }
                return boolArray;
            }
            case 66: {
                int length = is.readInt();
                BinaryReference[] binOldArray = new BinaryReference[length];
                for (int i = 0; i < binOldArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 2) continue;
                    binOldArray[i] = new BinaryReference(is.readLong(), null, null, 0L);
                }
                return binOldArray;
            }
            case 79: {
                int length = is.readInt();
                BinaryReference[] binArray = new BinaryReference[length];
                for (int i = 0; i < binArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 15) continue;
                    binArray[i] = new BinaryReference(is.readLong(), null, null, 0L);
                    if (is.readByte() == 0) continue;
                    binArray[i].setName(is.readUTF());
                }
                return binArray;
            }
            case 70: {
                int length = is.readInt();
                BigDecimal[] decArray = new BigDecimal[length];
                for (int i = 0; i < decArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 6) continue;
                    decArray[i] = new BigDecimal(is.readUTF());
                }
                return decArray;
            }
            case 78: {
                int length = is.readInt();
                Time[] timeArray = new Time[length];
                for (int i = 0; i < timeArray.length; ++i) {
                    dt = is.readByte();
                    if (dt != 14) continue;
                    timeArray[i] = new Time(is.readLong());
                }
                return timeArray;
            }
        }
        throw new IllegalArgumentException("unknown data format type:" + dt);
    }

    public static void write(DataOutput os, Object value) throws IOException {
        byte bt = PropertySerializeUtil.typeOf(value, false);
        os.writeByte(bt);
        switch (bt) {
            case 0: {
                break;
            }
            case 13: {
                os.writeUTF((String)value);
                break;
            }
            case 9: {
                os.writeLong((Long)value);
                break;
            }
            case 8: {
                os.writeDouble((Double)value);
                break;
            }
            case 12: {
                SelectValue sv = (SelectValue)value;
                os.writeUTF(sv.getValue());
                if (sv.getDisplayName() == null) {
                    os.writeByte(0);
                    break;
                }
                os.writeByte(13);
                os.writeUTF(sv.getDisplayName());
                break;
            }
            case 5: {
                Timestamp ts = (Timestamp)value;
                os.writeLong(ts.getTime());
                os.writeInt(ts.getNanos());
                break;
            }
            case 4: {
                os.writeLong(((Date)value).getTime());
                break;
            }
            case 3: {
                os.writeBoolean((Boolean)value);
                break;
            }
            case 15: {
                BinaryReference br = (BinaryReference)value;
                os.writeLong(br.getLobId());
                if (br.getName() == null) {
                    os.writeByte(0);
                    break;
                }
                os.writeByte(13);
                os.writeUTF(br.getName());
                break;
            }
            case 6: {
                os.writeUTF(((BigDecimal)value).toString());
                break;
            }
            case 14: {
                os.writeLong(((Time)value).getTime());
                break;
            }
            case 77: {
                String[] strArray = (String[])value;
                os.writeInt(strArray.length);
                for (int i = 0; i < strArray.length; ++i) {
                    if (strArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(13);
                    os.writeUTF(strArray[i]);
                }
                break;
            }
            case 73: {
                Long[] longArray = (Long[])value;
                os.writeInt(longArray.length);
                for (int i = 0; i < longArray.length; ++i) {
                    if (longArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(9);
                    os.writeLong(longArray[i]);
                }
                break;
            }
            case 72: {
                Double[] doubleArray = (Double[])value;
                os.writeInt(doubleArray.length);
                for (int i = 0; i < doubleArray.length; ++i) {
                    if (doubleArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(8);
                    os.writeDouble(doubleArray[i]);
                }
                break;
            }
            case 76: {
                SelectValue[] selectArray = (SelectValue[])value;
                os.writeInt(selectArray.length);
                for (int i = 0; i < selectArray.length; ++i) {
                    if (selectArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(12);
                    os.writeUTF(selectArray[i].getValue());
                    if (selectArray[i].getDisplayName() == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(13);
                    os.writeUTF(selectArray[i].getDisplayName());
                }
                break;
            }
            case 69: {
                Timestamp[] tsArray = (Timestamp[])value;
                os.writeInt(tsArray.length);
                for (int i = 0; i < tsArray.length; ++i) {
                    if (tsArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(5);
                    os.writeLong(tsArray[i].getTime());
                    os.writeInt(tsArray[i].getNanos());
                }
                break;
            }
            case 68: {
                Date[] dateArray = (Date[])value;
                os.writeInt(dateArray.length);
                for (int i = 0; i < dateArray.length; ++i) {
                    if (dateArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(4);
                    os.writeLong(dateArray[i].getTime());
                }
                break;
            }
            case 67: {
                Boolean[] boolArray = (Boolean[])value;
                os.writeInt(boolArray.length);
                for (int i = 0; i < boolArray.length; ++i) {
                    if (boolArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(3);
                    os.writeBoolean(boolArray[i]);
                }
                break;
            }
            case 79: {
                BinaryReference[] binArray = (BinaryReference[])value;
                os.writeInt(binArray.length);
                for (int i = 0; i < binArray.length; ++i) {
                    if (binArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(15);
                    os.writeLong(binArray[i].getLobId());
                    if (binArray[i].getName() == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(13);
                    os.writeUTF(binArray[i].getName());
                }
                break;
            }
            case 70: {
                BigDecimal[] decArray = (BigDecimal[])value;
                os.writeInt(decArray.length);
                for (int i = 0; i < decArray.length; ++i) {
                    if (decArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(6);
                    os.writeUTF(decArray[i].toString());
                }
                break;
            }
            case 78: {
                Time[] timeArray = (Time[])value;
                os.writeInt(timeArray.length);
                for (int i = 0; i < timeArray.length; ++i) {
                    if (timeArray[i] == null) {
                        os.writeByte(0);
                        continue;
                    }
                    os.writeByte(14);
                    os.writeLong(timeArray[i].getTime());
                }
                break;
            }
        }
    }

    public static byte typeOf(Object value, boolean strictCheck) {
        if (value == null) {
            return 0;
        }
        Byte bt = typeMap.get(value.getClass());
        if (bt != null) {
            return bt;
        }
        if (strictCheck) {
            throw new IllegalArgumentException("not support type:" + value);
        }
        return 0;
    }

    static {
        HashMap map = new HashMap();
        map.put(null, (byte)0);
        map.put(BinaryReference.class, (byte)15);
        map.put(Boolean.class, (byte)3);
        map.put(Date.class, (byte)4);
        map.put(Timestamp.class, (byte)5);
        map.put(BigDecimal.class, (byte)6);
        map.put(Double.class, (byte)8);
        map.put(Long.class, (byte)9);
        map.put(Entity.class, (byte)11);
        map.put(SelectValue.class, (byte)12);
        map.put(String.class, (byte)13);
        map.put(Time.class, (byte)14);
        map.put(BinaryReference[].class, (byte)79);
        map.put(Boolean[].class, (byte)67);
        map.put(boolean[].class, (byte)67);
        map.put(Date[].class, (byte)68);
        map.put(Timestamp[].class, (byte)69);
        map.put(BigDecimal[].class, (byte)70);
        map.put(Double[].class, (byte)72);
        map.put(double[].class, (byte)72);
        map.put(Long[].class, (byte)73);
        map.put(long[].class, (byte)73);
        map.put(Entity[].class, (byte)75);
        map.put(SelectValue[].class, (byte)76);
        map.put(String[].class, (byte)77);
        map.put(Time[].class, (byte)78);
        typeMap = map;
    }
}

