/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.basic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeType
extends BasicType {
    private static final long serialVersionUID = 3911004797303862636L;
    private static final int hash = 19;
    private static Logger logger = LoggerFactory.getLogger(DateTimeType.class);
    static boolean OLD_FORMAT_FLAG = false;

    @Override
    public int hashCode() {
        return 19;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DateTimeType;
    }

    @Override
    public DateTimeProperty createPropertyDefinitionInstance() {
        return new DateTimeProperty();
    }

    @Override
    public DateTimeType copy() {
        return new DateTimeType();
    }

    @Override
    public Class<?> storeType() {
        return Timestamp.class;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.DATETIME;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (OLD_FORMAT_FLAG) {
            return DateUtil.getDateTimeInstance(2, 2, true).format(value);
        }
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", true);
        return sdf.format(value);
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            if (OLD_FORMAT_FLAG) {
                return new Timestamp(DateUtil.getDateTimeInstance(2, 2, true).parse(strValue).getTime());
            }
            SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", true);
            return new Timestamp(sdf.parse(strValue).getTime());
        }
        catch (ParseException e) {
            try {
                return ConvertUtil.convertFromString(Timestamp.class, strValue);
            }
            catch (RuntimeException ee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Can't parse to DateTime:" + strValue);
                }
                return null;
            }
        }
    }

    static {
        String flagStr = System.getProperty("mtp.property.oldformat");
        if (flagStr != null && flagStr.equalsIgnoreCase("TRUE")) {
            OLD_FORMAT_FLAG = true;
        }
    }
}

